/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.servicecomb.core.filter.ConsumerFilter;
import org.apache.servicecomb.core.filter.EdgeFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.filter.InvocationFilterChains;
import org.apache.servicecomb.core.filter.ProviderFilter;
import org.apache.servicecomb.foundation.common.utils.StringBuilderUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class FilterChainsManager {
    private InvocationFilterChains consumerChains;
    private InvocationFilterChains providerChains;
    private InvocationFilterChains edgeChains;

    @Autowired
    public FilterChainsManager setEdgeFilters(List<EdgeFilter> filters) {
        this.edgeChains = new InvocationFilterChains(filters);
        return this;
    }

    @Autowired
    public FilterChainsManager setConsumerFilters(List<ConsumerFilter> filters) {
        this.consumerChains = new InvocationFilterChains(filters);
        return this;
    }

    @Autowired
    public FilterChainsManager setProviderFilters(List<ProviderFilter> filters) {
        this.providerChains = new InvocationFilterChains(filters);
        return this;
    }

    public FilterChainsManager init() {
        return this;
    }

    public FilterNode findConsumerChain(String application, String serviceName) {
        return this.consumerChains.findChain(application, serviceName);
    }

    public FilterNode findProducerChain(String application, String serviceName) {
        return this.providerChains.findChain(application, serviceName);
    }

    public FilterNode findEdgeChain(String application, String serviceName) {
        return this.edgeChains.findChain(application, serviceName);
    }

    public String collectResolvedChains() {
        StringBuilder sb = new StringBuilder();
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"consumer: ", (Object[])new Object[0]);
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"  filters: %s", (Object[])new Object[]{this.collectFilterNames(this.consumerChains)});
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"producer: ", (Object[])new Object[0]);
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"  filters: %s", (Object[])new Object[]{this.collectFilterNames(this.providerChains)});
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"edge: ", (Object[])new Object[0]);
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"  filters: %s", (Object[])new Object[]{this.collectFilterNames(this.edgeChains)});
        return StringBuilderUtils.deleteLast((StringBuilder)sb, (int)1).toString();
    }

    private List<String> collectFilterNames(InvocationFilterChains chains) {
        return chains.getFilters().stream().map(filter -> filter.getName() + "(" + filter.getOrder() + ")").collect(Collectors.toList());
    }
}

