/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteOutput;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesCarrier;
import com.google.protobuf.RopeByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

public class ZeroByteStringHelper {
    public static ByteString wrap(byte[] bs) {
        return ByteString.wrap((byte[])bs);
    }

    public static ByteString wrap(byte[] bs, int offset, int len) {
        return ByteString.wrap((byte[])bs, (int)offset, (int)len);
    }

    public static ByteString wrap(ByteBuffer buf) {
        return ByteString.wrap((ByteBuffer)buf);
    }

    public static byte[] getByteArray(ByteString byteString) {
        BytesCarrier carrier = new BytesCarrier();
        try {
            byteString.writeTo((ByteOutput)carrier);
            if (carrier.isValid()) {
                return carrier.getValue();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteString.toByteArray();
    }

    public static ByteString concatenate(ByteString left, ByteString right) {
        return RopeByteString.concatenate((ByteString)left, (ByteString)right);
    }

    public static ByteString concatenate(List<ByteBuffer> byteBuffers) {
        int size = byteBuffers.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return ZeroByteStringHelper.wrap(byteBuffers.get(0));
        }
        ByteString left = null;
        for (ByteBuffer buf : byteBuffers) {
            if (buf.remaining() <= 0) continue;
            if (left == null) {
                left = ZeroByteStringHelper.wrap(buf);
                continue;
            }
            left = ZeroByteStringHelper.concatenate(left, ZeroByteStringHelper.wrap(buf));
        }
        return left;
    }
}

