/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.access.data;

import jakarta.persistence.Query;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAPaging;

public class JPAPage
implements JPAPaging {
    private int pageSize;
    private int startPage;
    private int nextPage;
    private List<Object> pagedEntries;

    protected JPAPage(int startPage, int nextPage, List<Object> pagedEntities, int pageSize) {
        this.pageSize = pageSize;
        this.startPage = startPage;
        this.nextPage = nextPage;
        this.pagedEntries = pagedEntities;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public List<Object> getPagedEntities() {
        return this.pagedEntries;
    }

    public int getNextPage() {
        return this.nextPage;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public static class JPAPageBuilder {
        private int pageSize;
        private int startPage;
        private int nextPage;
        private int top = -1;
        private int skip;
        private int skipToken;
        private Query query;
        private List<Object> entities;
        private List<Object> pagedEntities;

        public JPAPageBuilder pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public JPAPageBuilder query(Query query) {
            this.query = query;
            return this;
        }

        public JPAPage build() {
            if (this.entities != null) {
                return this.buildFromEntities();
            }
            return this.buildFromQuery();
        }

        private JPAPage buildFromEntities() {
            TopSkip topSkip = this.formulateTopSkip();
            this.pagedEntities = new ArrayList<Object>();
            Integer top = topSkip.top;
            Integer skip = topSkip.skip;
            if (skip == null || topSkip.skip <= 0) {
                skip = 1;
            }
            if (top == null || topSkip.top <= 0) {
                top = 0;
            }
            int i = skip - 1;
            for (int j = 0; j < top && i < this.entities.size(); ++j) {
                this.pagedEntities.add(this.entities.get(i++));
            }
            this.formulateNextPage();
            return new JPAPage(this.startPage, this.nextPage, this.pagedEntities, this.pageSize);
        }

        private JPAPage buildFromQuery() {
            TopSkip topSkip = this.formulateTopSkip();
            if (topSkip.skip != null) {
                this.query.setFirstResult(topSkip.skip.intValue());
            }
            if (topSkip.top != null) {
                this.query.setMaxResults(topSkip.top.intValue());
            }
            this.pagedEntities = this.query.getResultList();
            this.formulateNextPage();
            return new JPAPage(this.startPage, this.nextPage, this.pagedEntities, this.pageSize);
        }

        private TopSkip formulateTopSkip() {
            TopSkip topSkip = new TopSkip();
            int size = 0;
            if (this.pageSize <= 0) {
                if (this.skip > 0) {
                    topSkip.skip = this.skip;
                }
                if (this.top > 0) {
                    topSkip.top = this.top;
                }
            } else if (this.skip >= this.pageSize) {
                this.startPage = this.skipToken;
                this.nextPage = 0;
            } else {
                size = this.top + this.skip;
                topSkip.top = size > this.pageSize ? (this.skip == 0 ? Integer.valueOf(this.pageSize) : Integer.valueOf(this.pageSize - this.skip)) : (this.top > 0 ? Integer.valueOf(this.top) : Integer.valueOf(this.pageSize));
                this.startPage = this.skipToken;
                topSkip.skip = this.skip > 0 ? Integer.valueOf(this.startPage + this.skip) : Integer.valueOf(this.startPage);
            }
            return topSkip;
        }

        private void formulateNextPage() {
            this.nextPage = this.pagedEntities.isEmpty() ? 0 : (this.pagedEntities.size() < this.pageSize ? 0 : this.startPage + this.pageSize);
        }

        public JPAPageBuilder skip(int skip) {
            this.skip = skip;
            this.skip = skip < 0 ? 0 : skip;
            return this;
        }

        public JPAPageBuilder skipToken(String skipToken) throws NumberFormatException {
            if (skipToken == null) {
                this.skipToken = 0;
            } else {
                this.skipToken = new Integer(skipToken);
                if (this.skipToken < 0) {
                    this.skipToken = 0;
                }
            }
            return this;
        }

        public JPAPageBuilder top(int top) {
            this.top = top < 0 ? 0 : top;
            return this;
        }

        public JPAPageBuilder entities(List<Object> result) {
            this.entities = result;
            return this;
        }

        private static class TopSkip {
            private Integer top;
            private Integer skip;

            private TopSkip() {
            }
        }
    }
}

