/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stream.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.nifi.stream.io.exception.BytePatternNotFoundException;
import org.apache.nifi.stream.io.util.NonThreadSafeCircularBuffer;

public class StreamUtils {
    public static long copy(InputStream source, OutputStream destination) throws IOException {
        int len;
        byte[] buffer = new byte[8192];
        long totalCount = 0L;
        while ((len = source.read(buffer)) > 0) {
            destination.write(buffer, 0, len);
            totalCount += (long)len;
        }
        return totalCount;
    }

    public static void copy(InputStream source, OutputStream destination, long numBytes) throws IOException {
        int len;
        byte[] buffer = new byte[8192];
        long bytesLeft = numBytes;
        while ((len = source.read(buffer, 0, (int)Math.min(bytesLeft, (long)buffer.length))) > 0) {
            destination.write(buffer, 0, len);
            bytesLeft -= (long)len;
        }
        if (bytesLeft > 0L) {
            throw new EOFException("Attempted to copy " + numBytes + " bytes but only " + (numBytes - bytesLeft) + " bytes were available");
        }
    }

    public static void fillBuffer(InputStream source, byte[] destination) throws IOException {
        StreamUtils.fillBuffer(source, destination, true);
    }

    public static int fillBuffer(InputStream source, byte[] destination, boolean ensureCapacity) throws IOException {
        int bytesRead;
        int len;
        for (bytesRead = 0; bytesRead < destination.length; bytesRead += len) {
            len = source.read(destination, bytesRead, destination.length - bytesRead);
            if (len >= 0) continue;
            if (!ensureCapacity) break;
            throw new EOFException("Expected to read " + destination.length + " bytes but encountered EOF after " + bytesRead + " bytes");
        }
        return bytesRead;
    }

    public static void read(InputStream source, byte[] destination, int byteCount) throws IOException {
        int len;
        if (destination.length < byteCount) {
            throw new IllegalArgumentException();
        }
        for (int bytesRead = 0; bytesRead < byteCount; bytesRead += len) {
            len = source.read(destination, bytesRead, byteCount - bytesRead);
            if (len >= 0) continue;
            throw new EOFException("Expected to consume " + byteCount + " bytes but consumed only " + bytesRead);
        }
    }

    public static byte[] copyInclusive(InputStream in, OutputStream out, int maxBytes, byte[] ... stoppers) throws IOException {
        NonThreadSafeCircularBuffer circ;
        if (stoppers.length == 0) {
            return null;
        }
        ArrayList<NonThreadSafeCircularBuffer> circularBuffers = new ArrayList<NonThreadSafeCircularBuffer>();
        for (byte[] stopper : stoppers) {
            circularBuffers.add(new NonThreadSafeCircularBuffer(stopper));
        }
        long bytesRead = 0L;
        block1: while (true) {
            int next;
            if ((next = in.read()) == -1) {
                return null;
            }
            if (maxBytes > 0 && ++bytesRead >= (long)maxBytes) {
                throw new BytePatternNotFoundException("Did not encounter any byte pattern that was expected; data does not appear to be in the expected format");
            }
            out.write(next);
            Iterator iterator = circularBuffers.iterator();
            do {
                if (!iterator.hasNext()) continue block1;
            } while (!(circ = (NonThreadSafeCircularBuffer)iterator.next()).addAndCompare((byte)next));
            break;
        }
        return circ.getByteArray();
    }

    public static byte[] copyExclusive(InputStream in, OutputStream out, int maxBytes, byte[] ... stoppers) throws IOException {
        if (stoppers.length == 0) {
            return null;
        }
        int longest = 0;
        NonThreadSafeCircularBuffer longestBuffer = null;
        ArrayList<NonThreadSafeCircularBuffer> circularBuffers = new ArrayList<NonThreadSafeCircularBuffer>();
        for (byte[] stopper : stoppers) {
            NonThreadSafeCircularBuffer circularBuffer = new NonThreadSafeCircularBuffer(stopper);
            if (stopper.length > longest) {
                longest = stopper.length;
                longestBuffer = circularBuffer;
                circularBuffers.add(0, circularBuffer);
                continue;
            }
            circularBuffers.add(circularBuffer);
        }
        long bytesRead = 0L;
        int next;
        while ((next = in.read()) != -1) {
            if (maxBytes > 0 && bytesRead++ > (long)maxBytes) {
                throw new BytePatternNotFoundException("Did not encounter any byte pattern that was expected; data does not appear to be in the expected format");
            }
            for (NonThreadSafeCircularBuffer circ : circularBuffers) {
                if (!circ.addAndCompare((byte)next)) continue;
                int bytesToCopy = longest - circ.getByteArray().length;
                for (int i = 0; i < bytesToCopy; ++i) {
                    int oldestByte = longestBuffer.getOldestByte();
                    if (oldestByte == -1) continue;
                    out.write(oldestByte);
                    longestBuffer.addAndCompare((byte)0);
                }
                return circ.getByteArray();
            }
            if (!longestBuffer.isFilled()) continue;
            out.write(longestBuffer.getOldestByte());
        }
        return null;
    }

    public static void skip(InputStream stream, long bytesToSkip) throws IOException {
        long skippedThisIteration;
        if (bytesToSkip <= 0L) {
            return;
        }
        long actualBytesToSkip = bytesToSkip - 1L;
        for (long totalSkipped = 0L; totalSkipped < actualBytesToSkip; totalSkipped += skippedThisIteration) {
            skippedThisIteration = stream.skip(actualBytesToSkip - totalSkipped);
            if (skippedThisIteration != 0L) continue;
            int nextByte = stream.read();
            if (nextByte == -1) {
                throw new EOFException();
            }
            ++totalSkipped;
        }
        int lastByte = stream.read();
        if (lastByte == -1) {
            throw new EOFException();
        }
    }
}

