/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.policies;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.AccessPolicyAction;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.AccessPolicyResult;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.toolkit.client.PoliciesClient;

public class GetAccessPolicy
extends AbstractNiFiCommand<AccessPolicyResult> {
    public GetAccessPolicy() {
        super("get-policy", AccessPolicyResult.class);
    }

    @Override
    public String getDescription() {
        return "Retrieves the configuration for an access policy.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.POLICY_RESOURCE.createOption());
        this.addOption(CommandOption.POLICY_ACTION.createOption());
    }

    @Override
    public AccessPolicyResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, CommandException, MissingOptionException {
        PoliciesClient policyClient = client.getPoliciesClient();
        String resource = this.getRequiredArg(properties, CommandOption.POLICY_RESOURCE);
        AccessPolicyAction actionType = AccessPolicyAction.valueOf(this.getRequiredArg(properties, CommandOption.POLICY_ACTION).toUpperCase().trim());
        return new AccessPolicyResult(this.getResultType(properties), policyClient.getAccessPolicy(resource, actionType.toString().toLowerCase()));
    }
}

