/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.nifi.minifi.toolkit.schema.RemotePortSchema;
import org.apache.nifi.minifi.toolkit.schema.common.BaseSchemaWithIdAndName;
import org.apache.nifi.minifi.toolkit.schema.common.StringUtil;

public class RemoteProcessGroupSchema
extends BaseSchemaWithIdAndName {
    public static final String URL_KEY = "url";
    public static final String TIMEOUT_KEY = "timeout";
    public static final String TRANSPORT_PROTOCOL_KEY = "transport protocol";
    public static final String S2S_PROXY_REQUIRES_HTTP = "Site-To-Site proxy support requires HTTP transport protocol";
    public static final String PROXY_HOST_KEY = "proxy host";
    public static final String PROXY_PORT_KEY = "proxy port";
    public static final String PROXY_USER_KEY = "proxy user";
    public static final String PROXY_PASSWORD_KEY = "proxy password";
    public static final String LOCAL_NETWORK_INTERFACE_KEY = "local network interface";
    public static final String EXPECTED_PROXY_HOST_IF_PROXY_PORT = "expected proxy host to be set if proxy port is";
    public static final String EXPECTED_PROXY_HOST_IF_PROXY_USER = "expected proxy host to be set if proxy user is";
    public static final String EXPECTED_PROXY_USER_IF_PROXY_PASSWORD = "expected proxy user to be set if proxy password is";
    public static final String EXPECTED_PROXY_PASSWORD_IF_PROXY_USER = "expected proxy password to be set if proxy user is";
    public static final String DEFAULT_COMMENT = "";
    public static final String DEFAULT_TIMEOUT = "30 secs";
    public static final String DEFAULT_YIELD_PERIOD = "10 sec";
    public static final String DEFAULT_TRANSPORT_PROTOCOL = "RAW";
    public static final String DEFAULT_PROXY_HOST = "";
    public static final Integer DEFAULT_PROXY_PORT = null;
    public static final String DEFAULT_PROXY_USER = "";
    public static final String DEFAULT_PROXY_PASSWORD = "";
    public static final String DEFAULT_NETWORK_INTERFACE = "";
    private final String urls;
    private List<RemotePortSchema> inputPorts;
    private List<RemotePortSchema> outputPorts;
    private String comment = "";
    private String timeout = "30 secs";
    private String yieldPeriod = "10 sec";
    private String transportProtocol = "RAW";
    private String proxyHost = "";
    private Integer proxyPort = DEFAULT_PROXY_PORT;
    private String proxyUser = "";
    private String proxyPassword = "";
    private String localNetworkInterface = "";

    public RemoteProcessGroupSchema(Map map) {
        super(map, "RemoteProcessGroup(id: {id}, name: {name})");
        String wrapperName = this.getWrapperName();
        this.urls = this.getRequiredKeyAsType(map, URL_KEY, String.class, wrapperName);
        this.inputPorts = this.convertListToType(this.getOptionalKeyAsType(map, "Input Ports", List.class, wrapperName, new ArrayList()), "input port", RemotePortSchema.class, "Input Ports");
        this.addIssuesIfNotNull(this.inputPorts);
        this.outputPorts = this.convertListToType(this.getOptionalKeyAsType(map, "Output Ports", List.class, wrapperName, new ArrayList()), "output port", RemotePortSchema.class, "Output Ports");
        this.addIssuesIfNotNull(this.outputPorts);
        if (this.inputPorts.isEmpty() && this.outputPorts.isEmpty()) {
            this.addValidationIssue("Expected either 'Input Ports', 'Output Ports' in section '" + wrapperName + "' to have value(s)");
        }
        this.comment = this.getOptionalKeyAsType(map, "comment", String.class, wrapperName, "");
        this.timeout = this.getOptionalKeyAsType(map, TIMEOUT_KEY, String.class, wrapperName, DEFAULT_TIMEOUT);
        this.yieldPeriod = this.getOptionalKeyAsType(map, "yield period", String.class, wrapperName, DEFAULT_YIELD_PERIOD);
        this.transportProtocol = this.getOptionalKeyAsType(map, TRANSPORT_PROTOCOL_KEY, String.class, wrapperName, DEFAULT_TRANSPORT_PROTOCOL);
        if (!TransportProtocolOptions.valid(this.transportProtocol)) {
            this.addValidationIssue(TRANSPORT_PROTOCOL_KEY, wrapperName, "it must be either 'RAW' or 'HTTP' but is '" + this.transportProtocol + "'");
        }
        this.localNetworkInterface = this.getOptionalKeyAsType(map, LOCAL_NETWORK_INTERFACE_KEY, String.class, wrapperName, "");
        this.proxyHost = this.getOptionalKeyAsType(map, PROXY_HOST_KEY, String.class, wrapperName, "");
        this.proxyPort = this.getOptionalKeyAsType(map, PROXY_PORT_KEY, Integer.class, wrapperName, DEFAULT_PROXY_PORT);
        this.proxyUser = this.getOptionalKeyAsType(map, PROXY_USER_KEY, String.class, wrapperName, "");
        this.proxyPassword = this.getOptionalKeyAsType(map, PROXY_PASSWORD_KEY, String.class, wrapperName, "");
        if (StringUtil.isNullOrEmpty(this.proxyHost)) {
            if (this.proxyPort != null) {
                this.addValidationIssue(PROXY_PORT_KEY, wrapperName, EXPECTED_PROXY_HOST_IF_PROXY_PORT);
            }
            if (!StringUtil.isNullOrEmpty(this.proxyUser)) {
                this.addValidationIssue(PROXY_USER_KEY, wrapperName, EXPECTED_PROXY_HOST_IF_PROXY_USER);
            }
        } else if (!TransportProtocolOptions.HTTP.name().equals(this.transportProtocol)) {
            this.addValidationIssue(PROXY_HOST_KEY, wrapperName, S2S_PROXY_REQUIRES_HTTP);
        }
        if (StringUtil.isNullOrEmpty(this.proxyUser)) {
            if (!StringUtil.isNullOrEmpty(this.proxyPassword)) {
                this.addValidationIssue(PROXY_PASSWORD_KEY, wrapperName, EXPECTED_PROXY_USER_IF_PROXY_PASSWORD);
            }
        } else if (StringUtil.isNullOrEmpty(this.proxyPassword)) {
            this.addValidationIssue(PROXY_USER_KEY, wrapperName, EXPECTED_PROXY_PASSWORD_IF_PROXY_USER);
        }
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> result = super.toMap();
        result.put(URL_KEY, this.urls);
        result.put("comment", this.comment);
        result.put(TIMEOUT_KEY, this.timeout);
        result.put("yield period", this.yieldPeriod);
        result.put(TRANSPORT_PROTOCOL_KEY, this.transportProtocol);
        result.put(PROXY_HOST_KEY, this.proxyHost);
        result.put(PROXY_PORT_KEY, this.proxyPort == null ? "" : this.proxyPort);
        result.put(PROXY_USER_KEY, this.proxyUser);
        result.put(PROXY_PASSWORD_KEY, this.proxyPassword);
        result.put(LOCAL_NETWORK_INTERFACE_KEY, this.localNetworkInterface);
        RemoteProcessGroupSchema.putListIfNotNull(result, "Input Ports", this.inputPorts);
        RemoteProcessGroupSchema.putListIfNotNull(result, "Output Ports", this.outputPorts);
        return result;
    }

    public String getComment() {
        return this.comment;
    }

    public String getUrls() {
        return this.urls;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public String getYieldPeriod() {
        return this.yieldPeriod;
    }

    public List<RemotePortSchema> getInputPorts() {
        return this.inputPorts;
    }

    public List<RemotePortSchema> getOutputPorts() {
        return this.outputPorts;
    }

    public String getTransportProtocol() {
        return this.transportProtocol;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public void setTransportProtocol(String transportProtocol) {
        this.transportProtocol = transportProtocol;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setLocalNetworkInterface(String LocalNetworkInterface) {
        this.localNetworkInterface = LocalNetworkInterface;
    }

    public String getLocalNetworkInterface() {
        return this.localNetworkInterface;
    }

    public static enum TransportProtocolOptions {
        RAW,
        HTTP;


        public static boolean valid(String input) {
            return RAW.name().equals(input) || HTTP.name().equals(input);
        }
    }
}

