/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.fold;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import jpt.sun.source.tree.CompilationUnitTree;
import jpt.sun.source.tree.Tree;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.editor.base.fold.JavaElementFoldVisitor;
import org.netbeans.modules.java.editor.fold.Bundle;
import org.netbeans.modules.java.editor.fold.JavaElementFoldManagerTaskFactory;
import org.netbeans.modules.java.editor.semantic.ScanningCancellableTask;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldInfo;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class JavaElementFoldManager
implements FoldManager {
    private FoldOperation operation;
    private FileObject file;
    private JavaElementFoldTask task;
    private boolean first = true;
    public static final FoldType INITIAL_COMMENT_FOLD_TYPE = FoldType.INITIAL_COMMENT;
    public static final FoldType IMPORTS_FOLD_TYPE = FoldType.create("import", Bundle.FoldType_Imports(), new org.netbeans.api.editor.fold.FoldTemplate(0, 0, "..."));
    public static final FoldType JAVADOC_FOLD_TYPE = FoldType.DOCUMENTATION.derive("javadoc", Bundle.FoldType_Javadoc(), new org.netbeans.api.editor.fold.FoldTemplate(3, 2, "/**...*/"));
    public static final FoldType METHOD_BLOCK_FOLD_TYPE = FoldType.MEMBER.derive("method", Bundle.FoldType_Methods(), new org.netbeans.api.editor.fold.FoldTemplate(1, 1, "{...}"));
    public static final FoldType CODE_BLOCK_FOLD_TYPE = FoldType.CODE_BLOCK.derive("code-block", Bundle.FoldType_CodeBlocks(), new org.netbeans.api.editor.fold.FoldTemplate(1, 1, "{...}"));
    public static final FoldType INNERCLASS_TYPE = FoldType.NESTED.derive("innerclass", "Inner Classes", new org.netbeans.api.editor.fold.FoldTemplate(1, 1, "{...}"));

    @Override
    public void init(FoldOperation operation) {
        this.operation = operation;
    }

    @Override
    public synchronized void initFolds(FoldHierarchyTransaction transaction) {
        Document doc = this.operation.getHierarchy().getComponent().getDocument();
        Object od = doc.getProperty("stream");
        if (od instanceof DataObject) {
            FileObject file = ((DataObject)od).getPrimaryFile();
            this.task = JavaElementFoldTask.getTask(file);
            this.task.setJavaElementFoldManager(this, file);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
        this.invalidate();
    }

    @Override
    public void removeUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
        this.invalidate();
    }

    @Override
    public void changedUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    @Override
    public void removeEmptyNotify(Fold emptyFold) {
        this.removeDamagedNotify(emptyFold);
    }

    @Override
    public void removeDamagedNotify(Fold damagedFold) {
    }

    @Override
    public void expandNotify(Fold expandedFold) {
    }

    @Override
    public synchronized void release() {
        if (this.task != null) {
            this.task.setJavaElementFoldManager(this, null);
        }
        this.task = null;
        this.file = null;
    }

    private synchronized void invalidate() {
        if (this.task != null) {
            this.task.invalidate();
        }
    }

    static final class JavaElementFoldTask
    extends ScanningCancellableTask<CompilationInfo> {
        private static final Map<DataObject, JavaElementFoldTask> file2Task = new WeakHashMap<DataObject, JavaElementFoldTask>();
        private AtomicLong version = new AtomicLong(0L);
        private Collection<Reference<JavaElementFoldManager>> managers = new ArrayList<Reference<JavaElementFoldManager>>(2);

        JavaElementFoldTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static JavaElementFoldTask getTask(FileObject file) {
            try {
                DataObject od = DataObject.find(file);
                Map<DataObject, JavaElementFoldTask> map = file2Task;
                synchronized (map) {
                    JavaElementFoldTask task = file2Task.get(od);
                    if (task == null) {
                        task = new JavaElementFoldTask();
                        file2Task.put(od, task);
                    }
                    return task;
                }
            }
            catch (DataObjectNotFoundException ex) {
                Logger.getLogger(JavaElementFoldManager.class.getName()).log(Level.FINE, null, ex);
                return new JavaElementFoldTask();
            }
        }

        void invalidate() {
            this.version.incrementAndGet();
        }

        synchronized void setJavaElementFoldManager(JavaElementFoldManager manager, FileObject file) {
            if (file == null) {
                Iterator<Reference<JavaElementFoldManager>> it = this.managers.iterator();
                while (it.hasNext()) {
                    Reference<JavaElementFoldManager> ref = it.next();
                    JavaElementFoldManager fm = ref.get();
                    if (fm != null && fm != manager) continue;
                    it.remove();
                    break;
                }
            } else {
                this.managers.add(new WeakReference<JavaElementFoldManager>(manager));
                JavaElementFoldManagerTaskFactory.doRefresh(file);
            }
        }

        private synchronized Object findLiveManagers() {
            Object oneMgr = null;
            ArrayList<JavaElementFoldManager> result = null;
            Iterator<Reference<JavaElementFoldManager>> it = this.managers.iterator();
            while (it.hasNext()) {
                Reference<JavaElementFoldManager> ref = it.next();
                JavaElementFoldManager fm = ref.get();
                if (fm == null) {
                    it.remove();
                    continue;
                }
                if (result != null) {
                    result.add(fm);
                    continue;
                }
                if (oneMgr != null) {
                    result = new ArrayList<JavaElementFoldManager>(2);
                    result.add((JavaElementFoldManager)oneMgr);
                    result.add(fm);
                    continue;
                }
                oneMgr = fm;
            }
            return result != null ? result : oneMgr;
        }

        @Override
        public void run(CompilationInfo info) {
            this.resume();
            final Object mgrs = this.findLiveManagers();
            if (mgrs == null) {
                return;
            }
            long startTime = System.currentTimeMillis();
            CompilationUnitTree cu = info.getCompilationUnit();
            final Document doc = info.getSnapshot().getSource().getDocument(false);
            if (doc == null) {
                return;
            }
            final JavaElementFoldVisitor<FoldInfo> v = new JavaElementFoldVisitor<FoldInfo>(info, cu, info.getTrees().getSourcePositions(), doc, new JavaElementFoldVisitor.FoldCreator<FoldInfo>(){

                @Override
                public FoldInfo createImportsFold(int start, int end) {
                    return FoldInfo.range(start, end, IMPORTS_FOLD_TYPE);
                }

                @Override
                public FoldInfo createInnerClassFold(int start, int end) {
                    return FoldInfo.range(start, end, INNERCLASS_TYPE);
                }

                @Override
                public FoldInfo createMethodFold(int start, int end) {
                    return FoldInfo.range(start, end, METHOD_BLOCK_FOLD_TYPE);
                }

                @Override
                public FoldInfo createCodeBlockFold(int start, int end) {
                    return FoldInfo.range(start, end, CODE_BLOCK_FOLD_TYPE);
                }

                @Override
                public FoldInfo createJavadocFold(int start, int end) {
                    return FoldInfo.range(start, end, JAVADOC_FOLD_TYPE);
                }

                @Override
                public FoldInfo createInitialCommentFold(int start, int end) {
                    return FoldInfo.range(start, end, INITIAL_COMMENT_FOLD_TYPE);
                }
            });
            this.scan(v, (Tree)cu, null);
            final long stamp = this.version.get();
            if (v.isStopped() || this.isCancelled()) {
                return;
            }
            v.checkInitialFold();
            if (v.isStopped() || this.isCancelled()) {
                return;
            }
            if (mgrs instanceof JavaElementFoldManager) {
                JavaElementFoldManager javaElementFoldManager = (JavaElementFoldManager)mgrs;
                Objects.requireNonNull(javaElementFoldManager);
                SwingUtilities.invokeLater(javaElementFoldManager.new CommitFolds(doc, v.getFolds(), v.getAnchors(), this.version, stamp));
            } else {
                SwingUtilities.invokeLater(new Runnable(){
                    Collection<JavaElementFoldManager> jefms;
                    {
                        this.jefms = (Collection)mgrs;
                    }

                    @Override
                    public void run() {
                        Iterator<JavaElementFoldManager> iterator = this.jefms.iterator();
                        while (iterator.hasNext()) {
                            JavaElementFoldManager jefm;
                            JavaElementFoldManager javaElementFoldManager = jefm = iterator.next();
                            Objects.requireNonNull(javaElementFoldManager);
                            javaElementFoldManager.new CommitFolds(doc, v.getFolds(), v.getAnchors(), version, stamp).run();
                        }
                    }
                });
            }
            long endTime = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Folds - 1", new Object[]{info.getFileObject(), endTime - startTime});
        }
    }

    private class CommitFolds
    implements Runnable {
        private boolean insideRender;
        private Document doc;
        private List<FoldInfo> infos;
        private List<Integer> anchors;
        private long startTime;
        private AtomicLong version;
        private long stamp;

        public CommitFolds(Document doc, List<FoldInfo> infos, List<Integer> anchors, AtomicLong version, long stamp) {
            this.doc = doc;
            this.infos = infos;
            this.version = version;
            this.stamp = stamp;
            this.anchors = anchors;
        }

        private FoldInfo expanded(FoldInfo info) {
            FoldInfo ex = FoldInfo.range(info.getStart(), info.getEnd(), info.getType());
            if (info.getTemplate() != info.getType().getTemplate()) {
                ex = ex.withTemplate(info.getTemplate());
            }
            if (info.getDescriptionOverride() != null) {
                ex = ex.withDescription(info.getDescriptionOverride());
            }
            ex.attach(info.getExtraInfo());
            return ex.collapsed(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int caretPos = -1;
            if (!this.insideRender) {
                this.startTime = System.currentTimeMillis();
                this.insideRender = true;
                JavaElementFoldManager.this.operation.getHierarchy().getComponent().getDocument().render(this);
                return;
            }
            if (JavaElementFoldManager.this.first) {
                JTextComponent c = JavaElementFoldManager.this.operation.getHierarchy().getComponent();
                Object od = this.doc.getProperty("stream");
                if (od instanceof DataObject) {
                    int idx;
                    DataObject d = (DataObject)od;
                    EditorCookie cake = d.getCookie(EditorCookie.class);
                    JEditorPane[] panes = cake.getOpenedPanes();
                    int n = idx = panes == null ? -1 : Arrays.asList(panes).indexOf(c);
                    if (idx != -1) {
                        caretPos = c.getCaret().getDot();
                    }
                }
            }
            JavaElementFoldManager.this.operation.getHierarchy().lock();
            try {
                Map<FoldInfo, Fold> folds;
                if (this.version.get() != this.stamp || JavaElementFoldManager.this.operation.getHierarchy().getComponent().getDocument() != this.doc) {
                    return;
                }
                int expandIndex = -1;
                if (caretPos >= 0) {
                    for (int i = 0; i < this.anchors.size(); ++i) {
                        FoldType ft;
                        int a = this.anchors.get(i);
                        if (a > caretPos) continue;
                        FoldInfo fi = this.infos.get(i);
                        if (a == caretPos && ((ft = fi.getType()).isKindOf(FoldType.INITIAL_COMMENT) || ft.isKindOf(FoldType.COMMENT) || ft.isKindOf(FoldType.DOCUMENTATION)) || fi.getEnd() <= caretPos) continue;
                        expandIndex = i;
                        break;
                    }
                }
                if (expandIndex != -1) {
                    this.infos = new ArrayList<FoldInfo>(this.infos);
                    this.infos.set(expandIndex, this.expanded(this.infos.get(expandIndex)));
                }
                if ((folds = JavaElementFoldManager.this.operation.update(this.infos, null, null)) == null) {
                    return;
                }
                JavaElementFoldManager.this.first = false;
            }
            catch (BadLocationException e) {
                Exceptions.printStackTrace(e);
            }
            finally {
                JavaElementFoldManager.this.operation.getHierarchy().unlock();
            }
            long endTime = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Folds - 2", new Object[]{JavaElementFoldManager.this.file, endTime - this.startTime});
        }
    }

    protected static final class FoldTemplate {
        private FoldType type;
        private String description;
        private int startGuardedLength;
        private int endGuardedLength;

        protected FoldTemplate(FoldType type, String description, int startGuardedLength, int endGuardedLength) {
            this.type = type;
            this.description = description;
            this.startGuardedLength = startGuardedLength;
            this.endGuardedLength = endGuardedLength;
        }

        public FoldType getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        public int getStartGuardedLength() {
            return this.startGuardedLength;
        }

        public int getEndGuardedLength() {
            return this.endGuardedLength;
        }
    }
}

