/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui.customizer.vmo;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.api.common.project.ui.customizer.vmo.JavaVMOption;
import org.netbeans.modules.java.api.common.project.ui.customizer.vmo.OptionValue;
import org.netbeans.modules.java.api.common.project.ui.customizer.vmo.SwitchNode;
import org.netbeans.modules.java.api.common.project.ui.customizer.vmo.UserPropertyNode;
import org.openide.util.NbBundle;

public class ValueCellEditor
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor {
    private JTextField textEditor = new JTextField();
    private JCheckBox booleanEditor = new JCheckBox();
    private JLabel label;
    private JCheckBox booleanLabel;
    private static final String EMPTY_TEXT = "";
    private JComponent currentEditor;
    private int editedRow;
    private int editedColumn;
    private SoftReference<JTable> lastTable;
    private static final String DEFAULT_USER_PROPERTY_NAME_VALUE = NbBundle.getMessage(ValueCellEditor.class, "ValueCellEditor.virtualUserProperty.name");
    private static final String DEFAULT_USER_PROPERTY_TEXT = NbBundle.getMessage(ValueCellEditor.class, "ValueCellEditor.virtualUserProperty.text");
    private static final ResourceBundle BUNDLE = NbBundle.getBundle(ValueCellEditor.class);

    public ValueCellEditor() {
        this.booleanEditor.setOpaque(false);
        this.booleanEditor.getModel().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ValueCellEditor.this.stopCellEditing();
            }
        });
        this.booleanLabel = new JCheckBox();
        this.booleanLabel.setOpaque(false);
        this.label = new JLabel();
        this.label.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 5));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String text;
        if (value instanceof JavaVMOption) {
            JavaVMOption option = (JavaVMOption)value;
            if (column == 1 && (option instanceof SwitchNode || option.getValue() instanceof OptionValue.SwitchOnly)) {
                SwitchNode sn = (SwitchNode)option;
                this.booleanLabel.setSelected(((OptionValue.SwitchOnly)sn.getValue()).getValue());
                return this.booleanLabel;
            }
            text = this.extractText(option, column);
        } else {
            text = EMPTY_TEXT;
        }
        this.label.setText(text);
        return this.label;
    }

    private String extractText(@NonNull JavaVMOption<?> option, int column) {
        Object ov = option.getValue();
        if (option instanceof UserPropertyNode) {
            Map.Entry entry;
            Map.Entry entry2 = entry = ov != null ? (Map.Entry)((OptionValue.StringPair)ov).getValue() : null;
            if (entry == null) {
                return column == 0 ? DEFAULT_USER_PROPERTY_TEXT : EMPTY_TEXT;
            }
            switch (column) {
                case 0: {
                    String s = (String)entry.getKey();
                    return s != null ? s : DEFAULT_USER_PROPERTY_TEXT;
                }
                case 1: {
                    String s = (String)entry.getValue();
                    return s != null ? s : EMPTY_TEXT;
                }
            }
        } else {
            switch (column) {
                case 0: {
                    String rawName = option.getName();
                    String key = "ValueCellEditor." + rawName + ".text." + option.getClass().getSimpleName();
                    if (BUNDLE.containsKey(key)) {
                        return BUNDLE.getString(key);
                    }
                    return rawName;
                }
                case 1: {
                    Object o = ((OptionValue)ov).getValue();
                    return o != null ? o.toString() : EMPTY_TEXT;
                }
            }
            return EMPTY_TEXT;
        }
        return EMPTY_TEXT;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.lastTable = new SoftReference<JTable>(table);
        this.editedColumn = column;
        this.editedRow = row;
        JavaVMOption option = (JavaVMOption)value;
        if (column == 0) {
            this.textEditor.setText(this.extractText(option, column));
            this.currentEditor = this.textEditor;
            return this.textEditor;
        }
        if (option instanceof SwitchNode) {
            SwitchNode sn = (SwitchNode)option;
            this.booleanEditor.setSelected(((OptionValue.SwitchOnly)sn.getValue()).getValue());
            this.currentEditor = this.booleanEditor;
            return this.booleanEditor;
        }
        this.textEditor.setText(this.extractText(option, column));
        this.currentEditor = this.textEditor;
        return this.textEditor;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.currentEditor == this.booleanEditor) {
            return new OptionValue.SwitchOnly(this.booleanEditor.isSelected());
        }
        if (this.lastTable != null) {
            JTable table = this.lastTable.get();
            if (table == null) {
                throw new IllegalStateException("The reference to table is null");
            }
            JavaVMOption option = (JavaVMOption)table.getValueAt(this.editedRow, this.editedColumn);
            Object value = option.getValue();
            if (option instanceof UserPropertyNode) {
                OptionValue.StringPair pair = value != null ? (OptionValue.StringPair)value : new OptionValue.StringPair();
                Map.Entry sse = (Map.Entry)pair.getValue();
                if (this.editedColumn == 0) {
                    Object text = this.textEditor.getText();
                    if (text == null || ((String)text).isEmpty() || DEFAULT_USER_PROPERTY_TEXT.equals(((String)text).trim())) {
                        text = "D" + DEFAULT_USER_PROPERTY_NAME_VALUE;
                    } else if (!((String)text).startsWith("D")) {
                        text = "D" + (String)text;
                    }
                    AbstractMap.SimpleEntry<String, String> replacement = new AbstractMap.SimpleEntry<String, String>(((String)text).trim(), (String)sse.getValue());
                    pair.setValue((Map.Entry<String, String>)replacement);
                    return pair;
                }
                if (this.editedColumn == 1) {
                    sse.setValue(this.textEditor.getText());
                    pair.setValue(sse);
                    return pair;
                }
            } else if (value instanceof OptionValue.SimpleString) {
                ((OptionValue.SimpleString)value).setValue(this.textEditor.getText());
                return value;
            }
        }
        throw new IllegalStateException("This option is not supported.");
    }
}

