/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import jakarta.faces.context.FacesContext;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AccessKeyLogger
extends HashMap<Character, List<String>> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final char[] KEYS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    private AccessKeyLogger() {
    }

    private static AccessKeyLogger getInstance(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        AccessKeyLogger keyMap = (AccessKeyLogger)requestMap.get(AccessKeyLogger.class.getName());
        if (keyMap == null) {
            keyMap = new AccessKeyLogger();
            requestMap.put(AccessKeyLogger.class.getName(), keyMap);
        }
        return keyMap;
    }

    public static void addAccessKey(FacesContext facesContext, Character key, String clientId) {
        if (LOG.isDebugEnabled()) {
            List<String> clientIds;
            AccessKeyLogger instance = AccessKeyLogger.getInstance(facesContext);
            if (instance.containsKey(key)) {
                clientIds = (List)instance.get(key);
            } else {
                clientIds = new ArrayList();
                instance.put(key, clientIds);
            }
            clientIds.add(clientId);
            LOG.debug("Using accessKey='{}' for clientId='{}'", (Object)key, (Object)clientId);
        }
    }

    public static void logStatus(FacesContext facesContext) {
        if (LOG.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            AccessKeyLogger instance = AccessKeyLogger.getInstance(facesContext);
            builder.append("Used access keys:");
            for (Map.Entry entry : instance.entrySet()) {
                builder.append("\n'");
                builder.append(entry.getKey());
                builder.append("' -> ");
                builder.append(entry.getValue());
            }
            builder.append("\nFree access keys: ");
            for (Object key : (Object)KEYS) {
                builder.append((char)(instance.containsKey(Character.valueOf((char)key)) ? 46 : (char)key));
            }
            LOG.debug(builder.toString());
        }
    }
}

