/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.slf4j;

import java.io.PrintStream;

class OutputChoice {
    final OutputChoiceType outputChoiceType;
    final PrintStream targetPrintStream;

    OutputChoice(OutputChoiceType outputChoiceType) {
        if (outputChoiceType == OutputChoiceType.FILE) {
            throw new IllegalArgumentException();
        }
        this.outputChoiceType = outputChoiceType;
        this.targetPrintStream = outputChoiceType == OutputChoiceType.CACHED_SYS_OUT ? System.out : (outputChoiceType == OutputChoiceType.CACHED_SYS_ERR ? System.err : null);
    }

    OutputChoice(PrintStream printStream) {
        this.outputChoiceType = OutputChoiceType.FILE;
        this.targetPrintStream = printStream;
    }

    PrintStream getTargetPrintStream() {
        return switch (this.outputChoiceType) {
            default -> throw new IncompatibleClassChangeError();
            case OutputChoiceType.SYS_OUT -> System.out;
            case OutputChoiceType.SYS_ERR -> System.err;
            case OutputChoiceType.CACHED_SYS_ERR, OutputChoiceType.CACHED_SYS_OUT, OutputChoiceType.FILE -> this.targetPrintStream;
        };
    }

    static enum OutputChoiceType {
        SYS_OUT,
        CACHED_SYS_OUT,
        SYS_ERR,
        CACHED_SYS_ERR,
        FILE;

    }
}

