/*
 * Decompiled with CFR 0.152.
 */
package cisco.infra.dft.mojo.mgmt;

import cisco.infra.dft.dma.pom.enforcer.HasDevelopers;
import cisco.infra.dft.email.Email;
import cisco.infra.dft.mojo.mgmt.EmailLog;
import cisco.infra.dma.maven.mojo.AbstractDmaMojo;
import cisco.infra.dma.repo.BadDmaName;
import cisco.infra.dma.repo.Namespaces;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Developer;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.EnforcerTestUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.xml.sax.SAXException;

public class ValidatePomsInRepo
extends AbstractDmaMojo {
    private int failureCount = 0;
    private int okayCount = 0;
    private WebConversation wc;
    private Log emailLog;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.emailLog = new EmailLog();
        this.setLog(this.emailLog);
        try {
            this.start();
            Email.trivialSend("dma-reports@cisco.com", "robevans@cisco.com", "Repo Health", this.getLog().toString());
        }
        catch (Exception e) {
            throw new MojoExecutionException("For heaven sake!!", e);
        }
    }

    private void start() throws MalformedURLException, IOException, SAXException, Exception {
        this.wc = new WebConversation();
        GetMethodWebRequest req = new GetMethodWebRequest("http://releng.cisco.com/svn/cisco.repo/");
        WebResponse resp = this.wc.getResponse((WebRequest)req);
        WebLink[] links = resp.getLinks();
        for (int i = 0; i < links.length; ++i) {
            WebLink webLink = links[i];
            this.followLink(webLink);
        }
        this.summaryReport();
    }

    public Log getLog() {
        return super.getLog();
    }

    private void followLink(WebLink webLink) throws Exception {
        System.out.print(".");
        if (webLink.getURLString().equals("http://subversion.tigris.org/")) {
            return;
        }
        if (webLink.getURLString().equals("pom.xml")) {
            this.validatePom(webLink);
            return;
        }
        WebResponse response = webLink.click();
        if (!response.getContentType().equals("text/html")) {
            return;
        }
        WebLink[] links = response.getLinks();
        for (int i = 0; i < links.length; ++i) {
            WebLink possiblePom;
            WebLink link = links[i];
            if (i > 0 && (possiblePom = links[i - 1]).getURLString().equals("pom.xml")) {
                return;
            }
            if (link.getURLString().equals("../")) continue;
            this.followLink(link);
        }
    }

    private void validatePom(WebLink webLink) throws IOException, XmlPullParserException, SAXException {
        System.out.println("");
        this.getLog().info((CharSequence)"************************************************************************************");
        String pom = webLink.click().getText();
        HasDevelopers mojo = new HasDevelopers();
        MavenProject project = this.createMavenProject(pom);
        this.getLog().info((CharSequence)webLink.getRequest().getURL().toString());
        EnforcerRuleHelper helper = EnforcerTestUtils.getHelper((MavenProject)project);
        boolean pass = true;
        try {
            mojo.execute(helper);
        }
        catch (EnforcerRuleException e) {
            pass = false;
        }
        this.reportValidation(project, pass);
        this.getLog().info((CharSequence)"************************************************************************************");
    }

    private void reportValidation(MavenProject project, boolean pass) {
        if (pass) {
            ++this.okayCount;
            this.reportValidationSuccess();
        } else {
            ++this.failureCount;
            this.reportValidationFailure(project);
        }
    }

    private void reportValidationSuccess() {
        this.getLog().info((CharSequence)"Validation OKAY");
    }

    private void reportValidationFailure(MavenProject project) {
        this.getLog().info((CharSequence)"FAILURE");
        this.listContacts(project);
    }

    private void summaryReport() {
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("Validation Failures  : " + this.failureCount));
        this.getLog().info((CharSequence)("Validation Successes : " + this.okayCount));
    }

    private void listContacts(MavenProject project) {
        this.getLog().info((CharSequence)"\t Project Contacts");
        List developers = project.getDevelopers();
        if (developers == null) {
            return;
        }
        Iterator iterator = developers.iterator();
        while (iterator.hasNext()) {
            Developer developer = (Developer)iterator.next();
            this.getLog().info((CharSequence)("\t\t" + developer.getEmail() + " " + developer.getRoles().toString()));
        }
    }

    public MavenProject createMavenProject(String pom) throws IOException, XmlPullParserException {
        MavenProject project = this.deserializePomString(pom);
        this.getLog().info((CharSequence)("Validating -- " + project.getId()));
        if (project.getModel().getParent() != null) {
            Parent parent = project.getModel().getParent();
            try {
                this.loadParentDevelopers(project, parent);
            }
            catch (BadDmaName e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
        return project;
    }

    private MavenProject loadParentDevelopers(MavenProject project, Parent parent) throws BadDmaName, MalformedURLException, IOException, SAXException, XmlPullParserException {
        MavenProject parentProject = this.fetchParentFromSvn(parent);
        this.mergeDevelopers(project, parentProject);
        if (parentProject.getModel().getParent() != null) {
            this.getLog().info((CharSequence)"Fetching the parent's parent");
            MavenProject grandParent = this.loadParentDevelopers(project, parentProject.getModel().getParent());
        }
        return project;
    }

    private MavenProject fetchParentFromSvn(Parent parent) throws BadDmaName, MalformedURLException, IOException, SAXException, XmlPullParserException {
        String URL2 = Namespaces.getDmaRepoUrlForProject((Parent)parent) + "/trunk/pom.xml";
        this.getLog().info((CharSequence)("Fetching parent POM -- " + URL2));
        WebConversation wc1 = new WebConversation();
        GetMethodWebRequest req = new GetMethodWebRequest(URL2);
        WebResponse resp = wc1.getResponse((WebRequest)req);
        String parentPom = resp.getText();
        MavenProject p = this.deserializePomString(parentPom);
        return p;
    }

    private void mergeDevelopers(MavenProject project, MavenProject parentProject) throws BadDmaName, MalformedURLException, IOException, SAXException, XmlPullParserException {
        if (parentProject == null || project == null) {
            return;
        }
        Iterator iterator = parentProject.getDevelopers().iterator();
        while (iterator.hasNext()) {
            Developer d = (Developer)iterator.next();
            project.getDevelopers().add(d);
        }
    }

    private MavenProject deserializePomString(String pom) throws IOException, XmlPullParserException {
        StringReader reader = new StringReader(pom);
        MavenXpp3Reader modelReader = new MavenXpp3Reader();
        Model model = modelReader.read((Reader)reader);
        MavenProject project = new MavenProject(model);
        return project;
    }
}

