/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.errorhandler;

import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.reifier.errorhandler.ErrorHandlerReifier;
import org.apache.camel.util.ObjectHelper;

public class ErrorHandlerRefReifier
extends ErrorHandlerReifier<ErrorHandlerBuilderRef> {
    public ErrorHandlerRefReifier(Route route, ErrorHandlerFactory definition) {
        super(route, (ErrorHandlerBuilderRef)definition);
    }

    @Override
    public Processor createErrorHandler(Processor processor) throws Exception {
        ErrorHandlerFactory handler = this.lookupErrorHandler(this.route);
        return ErrorHandlerReifier.reifier(this.route, handler).createErrorHandler(processor);
    }

    private ErrorHandlerFactory lookupErrorHandler(Route route) {
        ErrorHandlerFactory handler = ErrorHandlerReifier.lookupErrorHandlerFactory(route, ((ErrorHandlerBuilderRef)this.definition).getRef());
        ObjectHelper.notNull((Object)handler, (String)("error handler '" + ((ErrorHandlerBuilderRef)this.definition).getRef() + "'"));
        route.addErrorHandlerFactoryReference((ErrorHandlerFactory)this.definition, handler);
        return handler;
    }
}

