/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.keyprovider;

import java.security.KeyPair;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.GenericUtils;

@FunctionalInterface
public interface KeyIdentityProvider {
    public static final KeyIdentityProvider EMPTY_KEYS_PROVIDER = new KeyIdentityProvider(){

        @Override
        public Iterable<KeyPair> loadKeys() {
            return Collections.emptyList();
        }

        public String toString() {
            return "EMPTY";
        }
    };
    public static final Function<KeyIdentityProvider, Iterable<KeyPair>> LOADER = p -> p == null ? Collections.emptyList() : p.loadKeys();

    public Iterable<KeyPair> loadKeys();

    public static KeyIdentityProvider providerOf(ClientSession session) {
        return session == null ? EMPTY_KEYS_PROVIDER : KeyIdentityProvider.resolveKeyIdentityProvider(session.getRegisteredIdentities(), session.getKeyPairProvider());
    }

    public static Iterator<KeyPair> iteratorOf(ClientSession session) {
        return KeyIdentityProvider.iteratorOf(KeyIdentityProvider.providerOf(session));
    }

    public static Iterator<KeyPair> iteratorOf(KeyIdentityProvider identities, KeyIdentityProvider keys) {
        return KeyIdentityProvider.iteratorOf(KeyIdentityProvider.resolveKeyIdentityProvider(identities, keys));
    }

    public static Iterator<KeyPair> iteratorOf(KeyIdentityProvider provider) {
        return GenericUtils.iteratorOf(provider == null ? null : provider.loadKeys());
    }

    public static KeyIdentityProvider resolveKeyIdentityProvider(KeyIdentityProvider identities, KeyIdentityProvider keys) {
        if (keys == null || identities == keys) {
            return identities;
        }
        if (identities == null) {
            return keys;
        }
        return KeyIdentityProvider.multiProvider(identities, keys);
    }

    public static KeyIdentityProvider multiProvider(KeyIdentityProvider ... providers) {
        return KeyIdentityProvider.multiProvider(GenericUtils.asList(providers));
    }

    public static KeyIdentityProvider multiProvider(Collection<? extends KeyIdentityProvider> providers) {
        return GenericUtils.isEmpty(providers) ? EMPTY_KEYS_PROVIDER : KeyIdentityProvider.wrap(KeyIdentityProvider.iterableOf(providers));
    }

    public static Iterable<KeyPair> iterableOf(Collection<? extends KeyIdentityProvider> providers) {
        Iterable<Supplier> keysSuppliers = GenericUtils.wrapIterable(providers, p -> p::loadKeys);
        return GenericUtils.multiIterableSuppliers(keysSuppliers);
    }

    public static KeyIdentityProvider wrap(KeyPair ... pairs) {
        return KeyIdentityProvider.wrap(GenericUtils.asList(pairs));
    }

    public static KeyIdentityProvider wrap(Iterable<KeyPair> pairs) {
        return pairs == null ? EMPTY_KEYS_PROVIDER : () -> pairs;
    }
}

