/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.csv;

import java.io.Writer;
import org.apache.juneau.UriResolver;
import org.apache.juneau.serializer.SerializerWriter;

public class CsvWriter
extends SerializerWriter {
    protected CsvWriter(Writer out, boolean useWhitespace, int maxIndent, char quoteChar, boolean trimStrings, UriResolver uriResolver) {
        super(out, useWhitespace, maxIndent, trimStrings, quoteChar, uriResolver);
    }

    @Override
    public CsvWriter append(char c) {
        super.append(c);
        return this;
    }

    @Override
    public CsvWriter append(char[] value) {
        super.append(value);
        return this;
    }

    @Override
    public CsvWriter append(int indent, char c) {
        super.append(indent, c);
        return this;
    }

    @Override
    public CsvWriter append(int indent, String text) {
        super.append(indent, text);
        return this;
    }

    @Override
    public CsvWriter append(Object text) {
        super.append(text);
        return this;
    }

    @Override
    public CsvWriter append(String text) {
        super.append(text);
        return this;
    }

    @Override
    public CsvWriter appendIf(boolean b, char c) {
        super.appendIf(b, c);
        return this;
    }

    @Override
    public CsvWriter appendIf(boolean b, String text) {
        super.appendIf(b, text);
        return this;
    }

    @Override
    public CsvWriter appendln(int indent, String text) {
        super.appendln(indent, text);
        return this;
    }

    @Override
    public CsvWriter appendln(String text) {
        super.appendln(text);
        return this;
    }

    @Override
    public CsvWriter appendUri(Object value) {
        super.appendUri(value);
        return this;
    }

    @Override
    public CsvWriter cr(int depth) {
        super.cr(depth);
        return this;
    }

    @Override
    public CsvWriter cre(int depth) {
        super.cre(depth);
        return this;
    }

    @Override
    public CsvWriter i(int indent) {
        super.i(indent);
        return this;
    }

    @Override
    public CsvWriter ie(int indent) {
        super.ie(indent);
        return this;
    }

    @Override
    public CsvWriter nl(int indent) {
        super.nl(indent);
        return this;
    }

    @Override
    public CsvWriter nlIf(boolean flag, int indent) {
        super.nlIf(flag, indent);
        return this;
    }

    @Override
    public CsvWriter q() {
        super.q();
        return this;
    }

    @Override
    public CsvWriter s() {
        super.s();
        return this;
    }

    @Override
    public CsvWriter sIf(boolean flag) {
        super.sIf(flag);
        return this;
    }

    @Override
    public CsvWriter w(char value) {
        super.w(value);
        return this;
    }

    @Override
    public CsvWriter w(String value) {
        super.w(value);
        return this;
    }

    public void writeEntry(Object value) {
        if (value == null) {
            this.w("null");
        } else {
            String s = value.toString();
            boolean mustQuote = false;
            for (int i = 0; i < s.length() && !mustQuote; ++i) {
                char c = s.charAt(i);
                if (!Character.isWhitespace(c) && c != ',') continue;
                mustQuote = true;
            }
            if (mustQuote) {
                this.w('\"').w(s).w('\"');
            } else {
                this.w(s);
            }
        }
    }
}

