/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.httppart;

import java.lang.reflect.Type;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.assertions.FluentIntegerAssertion;
import org.apache.juneau.assertions.FluentListAssertion;
import org.apache.juneau.assertions.FluentLongAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.assertions.FluentZonedDateTimeAssertion;
import org.apache.juneau.commons.reflect.ConstructorInfo;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.HttpParts;
import org.apache.juneau.http.part.BasicBooleanPart;
import org.apache.juneau.http.part.BasicCsvArrayPart;
import org.apache.juneau.http.part.BasicDatePart;
import org.apache.juneau.http.part.BasicIntegerPart;
import org.apache.juneau.http.part.BasicLongPart;
import org.apache.juneau.http.part.BasicStringPart;
import org.apache.juneau.http.part.BasicUriPart;
import org.apache.juneau.http.response.BadRequest;
import org.apache.juneau.http.response.BasicHttpException;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SimplePartParser;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.rest.RestRequest;

public class RequestHttpPart {
    private final HttpPartType partType;
    private final String name;
    private final RestRequest request;
    private HttpPartParserSession parser;
    private HttpPartSchema schema;
    String value;

    public RequestHttpPart(HttpPartType partType, RestRequest request, String name, String value) {
        this.partType = partType;
        this.request = request;
        this.name = name;
        this.value = value;
        this.parser(null);
    }

    public <T> Optional<T> as(Class<T> type) throws BasicHttpException {
        return this.as(this.request.getBeanSession().getClassMeta(type));
    }

    public <T> Optional<T> as(ClassMeta<T> type) throws BasicHttpException {
        try {
            ConstructorInfo cc;
            if (HttpParts.isHttpPart((HttpPartType)this.partType, type) && Utils.nn((Object)(cc = (ConstructorInfo)HttpParts.getConstructor(type).orElse(null)))) {
                if (!this.isPresent()) {
                    return Utils.opte();
                }
                if (cc.hasParameterTypes(new Class[]{String.class})) {
                    return Utils.opt((Object)cc.newInstance(new Object[]{this.get()}));
                }
                if (cc.hasParameterTypes(new Class[]{String.class, String.class})) {
                    return Utils.opt((Object)cc.newInstance(new Object[]{this.getName(), this.get()}));
                }
            }
            return Utils.opt((Object)this.parser.parse(HttpPartType.HEADER, this.schema, this.orElse(null), type));
        }
        catch (ParseException e) {
            throw new BadRequest((Throwable)e, "Could not parse {0} parameter ''{1}''.", new Object[]{this.partType.toString().toLowerCase(), this.getName()});
        }
    }

    public <T> Optional<T> as(Type type, Type ... args) throws BasicHttpException {
        return this.as(this.request.getBeanSession().getClassMeta(type, args));
    }

    public Optional<Boolean> asBoolean() {
        return this.asBooleanPart().asBoolean();
    }

    public BasicBooleanPart asBooleanPart() {
        return new BasicBooleanPart(this.getName(), this.getValue());
    }

    public Optional<List<String>> asCsvArray() {
        return this.asCsvArrayPart().asList();
    }

    public BasicCsvArrayPart asCsvArrayPart() {
        return new BasicCsvArrayPart(this.getName(), this.getValue());
    }

    public Optional<ZonedDateTime> asDate() {
        return this.asDatePart().asZonedDateTime();
    }

    public BasicDatePart asDatePart() {
        return new BasicDatePart(this.getName(), this.getValue());
    }

    public Optional<Integer> asInteger() {
        return this.asIntegerPart().asInteger();
    }

    public BasicIntegerPart asIntegerPart() {
        return new BasicIntegerPart(this.getName(), this.getValue());
    }

    public Optional<Long> asLong() {
        return this.asLongPart().asLong();
    }

    public BasicLongPart asLongPart() {
        return new BasicLongPart(this.getName(), this.getValue());
    }

    public Matcher asMatcher(Pattern pattern) throws BasicHttpException {
        return pattern.matcher(this.orElse(""));
    }

    public Matcher asMatcher(String regex) throws BasicHttpException {
        return this.asMatcher(regex, 0);
    }

    public Matcher asMatcher(String regex, int flags) throws BasicHttpException {
        return this.asMatcher(Pattern.compile(regex, flags));
    }

    public FluentListAssertion<String, RequestHttpPart> assertCsvArray() {
        return new FluentListAssertion((List)this.asCsvArrayPart().asList().orElse(null), (Object)this);
    }

    public FluentZonedDateTimeAssertion<RequestHttpPart> assertDate() {
        return new FluentZonedDateTimeAssertion((ZonedDateTime)this.asDatePart().asZonedDateTime().orElse(null), (Object)this);
    }

    public FluentIntegerAssertion<RequestHttpPart> assertInteger() {
        return new FluentIntegerAssertion((Integer)this.asIntegerPart().asInteger().orElse(null), (Object)this);
    }

    public FluentLongAssertion<RequestHttpPart> assertLong() {
        return new FluentLongAssertion((Long)this.asLongPart().asLong().orElse(null), (Object)this);
    }

    public FluentStringAssertion<RequestHttpPart> assertString() {
        return new FluentStringAssertion(this.orElse(null), (Object)this);
    }

    public Optional<String> asString() {
        return Utils.opt((Object)this.getValue());
    }

    public BasicStringPart asStringPart() {
        return new BasicStringPart(this.getName(), this.getValue());
    }

    public BasicUriPart asUriPart() {
        return new BasicUriPart(this.getName(), this.getValue());
    }

    public RequestHttpPart def(String def) {
        if (this.value == null) {
            this.value = def;
        }
        return this;
    }

    public String get() {
        return this.asString().get();
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isPresent() {
        return this.asString().isPresent();
    }

    public String orElse(String other) {
        return this.asString().orElse(other);
    }

    public RequestHttpPart parser(HttpPartParserSession value) {
        this.parser = value == null ? SimplePartParser.DEFAULT_SESSION : value;
        return this;
    }

    public RequestHttpPart schema(HttpPartSchema value) {
        this.schema = value;
        return this;
    }

    public String toString() {
        return this.getName() + "=" + this.getValue();
    }

    protected RestRequest getRequest() {
        return this.request;
    }
}

