/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client.remote;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.annotation.Content;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.remote.RemoteOp;
import org.apache.juneau.http.remote.RemoteUtils;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.bean.RequestBeanMeta;
import org.apache.juneau.rest.client.remote.RemoteMetadataException;
import org.apache.juneau.rest.client.remote.RemoteOperationArg;
import org.apache.juneau.rest.client.remote.RemoteOperationBeanArg;
import org.apache.juneau.rest.client.remote.RemoteOperationReturn;
import org.apache.juneau.rest.common.utils.HttpUtils;

public class RemoteOperationMeta {
    private final String httpMethod;
    private final String fullPath;
    private final RemoteOperationArg[] pathArgs;
    private final RemoteOperationArg[] queryArgs;
    private final RemoteOperationArg[] headerArgs;
    private final RemoteOperationArg[] formDataArgs;
    private final RemoteOperationBeanArg[] requestArgs;
    private final RemoteOperationArg contentArg;
    private final RemoteOperationReturn methodReturn;
    private final Class<?>[] exceptions;
    private final Map<String, String> pathDefaults;
    private final Map<String, String> queryDefaults;
    private final Map<String, String> headerDefaults;
    private final Map<String, String> formDataDefaults;
    private final String contentDefault;

    public RemoteOperationMeta(String parentPath, Method m, String defaultMethod) {
        Builder b = new Builder(parentPath, m, defaultMethod);
        this.httpMethod = b.httpMethod;
        this.fullPath = b.fullPath;
        this.pathArgs = b.pathArgs.toArray(new RemoteOperationArg[b.pathArgs.size()]);
        this.queryArgs = b.queryArgs.toArray(new RemoteOperationArg[b.queryArgs.size()]);
        this.formDataArgs = b.formDataArgs.toArray(new RemoteOperationArg[b.formDataArgs.size()]);
        this.headerArgs = b.headerArgs.toArray(new RemoteOperationArg[b.headerArgs.size()]);
        this.requestArgs = b.requestArgs.toArray(new RemoteOperationBeanArg[b.requestArgs.size()]);
        this.contentArg = b.bodyArg;
        this.methodReturn = b.methodReturn;
        this.exceptions = m.getExceptionTypes();
        this.pathDefaults = Collections.unmodifiableMap(b.pathDefaults);
        this.queryDefaults = Collections.unmodifiableMap(b.queryDefaults);
        this.headerDefaults = Collections.unmodifiableMap(b.headerDefaults);
        this.formDataDefaults = Collections.unmodifiableMap(b.formDataDefaults);
        this.contentDefault = b.contentDefault;
    }

    public RemoteOperationMeta forEachException(Consumer<Class<?>> action) {
        for (Class<?> e : this.exceptions) {
            action.accept(e);
        }
        return this;
    }

    public RemoteOperationMeta forEachFormDataArg(Consumer<RemoteOperationArg> action) {
        for (RemoteOperationArg a : this.formDataArgs) {
            action.accept(a);
        }
        return this;
    }

    public RemoteOperationMeta forEachHeaderArg(Consumer<RemoteOperationArg> action) {
        for (RemoteOperationArg a : this.headerArgs) {
            action.accept(a);
        }
        return this;
    }

    public RemoteOperationMeta forEachPathArg(Consumer<RemoteOperationArg> action) {
        for (RemoteOperationArg a : this.pathArgs) {
            action.accept(a);
        }
        return this;
    }

    public RemoteOperationMeta forEachQueryArg(Consumer<RemoteOperationArg> action) {
        for (RemoteOperationArg a : this.queryArgs) {
            action.accept(a);
        }
        return this;
    }

    public RemoteOperationMeta forEachRequestArg(Consumer<RemoteOperationBeanArg> action) {
        for (RemoteOperationBeanArg a : this.requestArgs) {
            action.accept(a);
        }
        return this;
    }

    public RemoteOperationArg getContentArg() {
        return this.contentArg;
    }

    public String getContentDefault() {
        return this.contentDefault;
    }

    public String getFormDataDefault(String name) {
        return this.formDataDefaults.get(name);
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public String getHeaderDefault(String name) {
        return this.headerDefaults.get(name);
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getPathDefault(String name) {
        return this.pathDefaults.get(name);
    }

    public String getQueryDefault(String name) {
        return this.queryDefaults.get(name);
    }

    public RemoteOperationReturn getReturns() {
        return this.methodReturn;
    }

    private static class Builder {
        String httpMethod;
        String fullPath;
        String path;
        List<RemoteOperationArg> pathArgs = new LinkedList<RemoteOperationArg>();
        List<RemoteOperationArg> queryArgs = new LinkedList<RemoteOperationArg>();
        List<RemoteOperationArg> headerArgs = new LinkedList<RemoteOperationArg>();
        List<RemoteOperationArg> formDataArgs = new LinkedList<RemoteOperationArg>();
        List<RemoteOperationBeanArg> requestArgs = new LinkedList<RemoteOperationBeanArg>();
        RemoteOperationArg bodyArg;
        RemoteOperationReturn methodReturn;
        Map<String, String> pathDefaults = new LinkedHashMap<String, String>();
        Map<String, String> queryDefaults = new LinkedHashMap<String, String>();
        Map<String, String> headerDefaults = new LinkedHashMap<String, String>();
        Map<String, String> formDataDefaults = new LinkedHashMap<String, String>();
        String contentDefault = null;
        static final AnnotationProvider AP = AnnotationProvider.INSTANCE;

        Builder(String parentPath, Method m, String defaultMethod) {
            MethodInfo mi = MethodInfo.of(m);
            List<AnnotationInfo<?>> al = CollectionUtils.rstream(AP.find(mi, new AnnotationTraversal[0])).filter(RemoteUtils.REMOTE_OP_GROUP).toList();
            if (al.isEmpty()) {
                al = CollectionUtils.rstream(AP.find(mi.getReturnType().unwrap(Value.class, Optional.class), new AnnotationTraversal[0])).filter(RemoteUtils.REMOTE_OP_GROUP).toList();
            }
            Value<String> _httpMethod = Value.empty();
            Value<String> _path = Value.empty();
            al.stream().map(x -> x.getName().substring(6).toUpperCase()).filter(x -> !x.equals("OP")).forEach(x -> _httpMethod.set((String)x));
            al.forEach(ai -> ai.getValue(String.class, "method").filter(StringUtils.NOT_EMPTY).ifPresent(x -> _httpMethod.set(x.trim().toUpperCase())));
            al.forEach(ai -> ai.getValue(String.class, "path").filter(StringUtils.NOT_EMPTY).ifPresent(x -> _path.set(x.trim())));
            this.httpMethod = _httpMethod.orElse("").trim();
            this.path = _path.orElse("").trim();
            Value value = Value.empty();
            al.stream().filter(x -> x.isType(RemoteOp.class) && Utils.ne(((RemoteOp)x.inner()).value().trim())).forEach(x -> value.set(((RemoteOp)x.inner()).value().trim()));
            if (value.isPresent()) {
                String v = (String)value.get();
                int i = v.indexOf(32);
                if (i == -1) {
                    this.httpMethod = v;
                } else {
                    this.httpMethod = v.substring(0, i).trim();
                    this.path = v.substring(i).trim();
                }
            } else {
                al.stream().filter(x -> !x.isType(RemoteOp.class) && Utils.ne(x.getValue(String.class, "value").filter(StringUtils.NOT_EMPTY).orElse("").trim())).forEach(x -> value.set(x.getValue(String.class, "value").filter(StringUtils.NOT_EMPTY).get().trim()));
                if (value.isPresent()) {
                    this.path = (String)value.get();
                }
            }
            if (this.path.isEmpty()) {
                this.path = HttpUtils.detectHttpPath(m, Utils.nullIfEmpty(this.httpMethod));
            }
            if (this.httpMethod.isEmpty()) {
                this.httpMethod = HttpUtils.detectHttpMethod(m, true, defaultMethod);
            }
            this.path = StringUtils.trimSlashes(this.path);
            if (!StringUtils.isOneOf(this.httpMethod, "DELETE", "GET", "POST", "PUT", "OPTIONS", "HEAD", "CONNECT", "TRACE", "PATCH")) {
                throw new RemoteMetadataException(m, "Invalid value specified for @RemoteOp(httpMethod) annotation: '" + this.httpMethod + "'.  Valid values are [DELETE,GET,POST,PUT,OPTIONS,HEAD,CONNECT,TRACE,PATCH].", new Object[0]);
            }
            this.methodReturn = new RemoteOperationReturn(mi);
            this.fullPath = this.path.indexOf("://") != -1 ? this.path : (parentPath.isEmpty() ? StringUtils.urlEncodePath(this.path) : StringUtils.trimSlashes(parentPath) + "/" + StringUtils.urlEncodePath(this.path));
            mi.getParameters().forEach(x -> {
                RequestBeanMeta rmba;
                RemoteOperationArg rma = RemoteOperationArg.create(x);
                if (Utils.nn(rma)) {
                    HttpPartType pt = rma.getPartType();
                    if (pt == HttpPartType.HEADER) {
                        this.headerArgs.add(rma);
                    } else if (pt == HttpPartType.QUERY) {
                        this.queryArgs.add(rma);
                    } else if (pt == HttpPartType.FORMDATA) {
                        this.formDataArgs.add(rma);
                    } else if (pt == HttpPartType.PATH) {
                        this.pathArgs.add(rma);
                    } else {
                        this.bodyArg = rma;
                    }
                }
                if (Utils.nn(rmba = RequestBeanMeta.create(x, AnnotationWorkList.create()))) {
                    this.requestArgs.add(new RemoteOperationBeanArg(x.getIndex(), rmba));
                }
            });
            Builder.processHeaderDefaults(mi, this.headerDefaults);
            Builder.processQueryDefaults(mi, this.queryDefaults);
            Builder.processFormDataDefaults(mi, this.formDataDefaults);
            Builder.processPathDefaults(mi, this.pathDefaults);
            this.processContentDefaults(mi);
        }

        private void processContentDefaults(MethodInfo mi) {
            AP.find(Content.class, mi, new AnnotationTraversal[0]).stream().map(x -> ((Content)x.inner()).def()).filter(StringUtils::isNotBlank).findFirst().ifPresent(x -> {
                this.contentDefault = x;
            });
        }

        private static void processFormDataDefaults(MethodInfo mi, Map<String, String> defaults) {
            CollectionUtils.rstream(AP.find(FormData.class, mi, new AnnotationTraversal[0])).map(AnnotationInfo::inner).filter(x -> StringUtils.isAnyNotEmpty(x.name(), x.value()) && Utils.ne(x.def())).forEach(x -> defaults.put(StringUtils.firstNonEmpty(x.name(), x.value()), x.def()));
        }

        private static void processHeaderDefaults(MethodInfo mi, Map<String, String> defaults) {
            CollectionUtils.rstream(AP.find(Header.class, mi, new AnnotationTraversal[0])).map(AnnotationInfo::inner).filter(x -> StringUtils.isAnyNotEmpty(x.name(), x.value()) && Utils.ne(x.def())).forEach(x -> defaults.put(StringUtils.firstNonEmpty(x.name(), x.value()), x.def()));
        }

        private static void processPathDefaults(MethodInfo mi, Map<String, String> defaults) {
            CollectionUtils.rstream(AP.find(Path.class, mi, new AnnotationTraversal[0])).map(AnnotationInfo::inner).filter(x -> StringUtils.isAnyNotEmpty(x.name(), x.value()) && Utils.neq("_NONE_", x.def())).forEach(x -> defaults.put(StringUtils.firstNonEmpty(x.name(), x.value()), x.def()));
        }

        private static void processQueryDefaults(MethodInfo mi, Map<String, String> defaults) {
            CollectionUtils.rstream(AP.find(Query.class, mi, new AnnotationTraversal[0])).map(AnnotationInfo::inner).filter(x -> StringUtils.isAnyNotEmpty(x.name(), x.value()) && Utils.ne(x.def())).forEach(x -> defaults.put(StringUtils.firstNonEmpty(x.name(), x.value()), x.def()));
        }
    }
}

