/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.objecttools;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.objecttools.ObjectTool;
import org.apache.juneau.objecttools.SortArgs;

public class ObjectSorter
implements ObjectTool<SortArgs> {
    public static final ObjectSorter DEFAULT = new ObjectSorter();

    public static ObjectSorter create() {
        return new ObjectSorter();
    }

    @Override
    public Object run(BeanSession session, Object input, SortArgs args) {
        if (input == null) {
            return null;
        }
        Map<String, Boolean> sort = args.getSort();
        if (sort.isEmpty()) {
            return input;
        }
        ClassMeta<Object> type = session.getClassMetaForObject(input);
        if (!type.isCollectionOrArray()) {
            return input;
        }
        ArrayList<SortEntry> l = null;
        if (type.isArray()) {
            int size = Array.getLength(input);
            l = CollectionUtils.listOfSize(size);
            for (int i = 0; i < size; ++i) {
                l.add(new SortEntry(session, Array.get(input, i)));
            }
        } else {
            Collection c2 = (Collection)input;
            ArrayList<SortEntry> l2 = l = CollectionUtils.listOfSize(c2.size());
            c2.forEach(x -> l2.add(new SortEntry(session, x)));
        }
        ArrayList<String> columns = CollectionUtils.toList(sort.keySet());
        Collections.reverse(columns);
        ArrayList<SortEntry> l3 = l;
        columns.forEach(c -> {
            boolean isDesc = (Boolean)sort.get(c);
            l3.forEach(se -> se.setSort((String)c, isDesc));
            Collections.sort(l3);
        });
        ArrayList l2 = CollectionUtils.listOfSize(l.size());
        l.forEach(x -> l2.add(x.o));
        return l2;
    }

    public <R> List<R> run(Object input, String sortArgs) {
        Object r = this.run(BeanContext.DEFAULT_SESSION, input, SortArgs.create(sortArgs));
        if (r instanceof List) {
            List r2 = (List)r;
            return r2;
        }
        if (r instanceof Collection) {
            Collection r2 = (Collection)r;
            return CollectionUtils.toList(r2);
        }
        if (Utils.isArray(r)) {
            return CollectionUtils.l((Object[])r);
        }
        return null;
    }

    private static class SortEntry
    implements Comparable {
        Object o;
        ClassMeta<?> cm;
        BeanSession bs;
        Object sortVal;
        boolean isDesc;

        SortEntry(BeanSession bs, Object o) {
            this.o = o;
            this.bs = bs;
            this.cm = bs.getClassMetaForObject(o);
        }

        public int compareTo(Object o) {
            if (this.isDesc) {
                return Utils.cmp(((SortEntry)o).sortVal, this.sortVal);
            }
            return Utils.cmp(this.sortVal, ((SortEntry)o).sortVal);
        }

        void setSort(String sortCol, boolean isDesc) {
            this.isDesc = isDesc;
            this.sortVal = this.cm == null ? null : (this.cm.isMap() ? ((Map)this.o).get(sortCol) : (this.cm.isBean() ? this.bs.toBeanMap(this.o).get(sortCol) : null));
        }
    }
}

