/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config.store;

import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.Context;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.collections.HashKey;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.config.internal.ConfigMap;
import org.apache.juneau.config.store.ConfigStoreListener;

public abstract class ConfigStore
extends Context
implements Closeable {
    private final ConcurrentHashMap<String, ConfigMap> configMaps = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Set<ConfigStoreListener>> listeners = new ConcurrentHashMap();

    protected ConfigStore(Builder builder) {
        super(builder);
    }

    public abstract boolean exists(String var1);

    public synchronized ConfigMap getMap(String name) throws IOException {
        ConfigMap cm = this.configMaps.get(name = this.resolveName(name));
        if (Utils.nn(cm)) {
            return cm;
        }
        cm = new ConfigMap(this, name);
        ConfigMap cm2 = this.configMaps.putIfAbsent(name, cm);
        if (Utils.nn(cm2)) {
            return cm2;
        }
        this.register(name, cm);
        return cm;
    }

    public abstract String read(String var1) throws IOException;

    public synchronized ConfigStore register(String name, ConfigStoreListener l) {
        name = this.resolveName(name);
        Set s = this.listeners.computeIfAbsent(name, k -> CollectionUtils.synced(Collections.newSetFromMap(new IdentityHashMap())));
        s.add(l);
        return this;
    }

    public synchronized ConfigStore unregister(String name, ConfigStoreListener l) {
        Set<ConfigStoreListener> s = this.listeners.get(name = this.resolveName(name));
        if (Utils.nn(s)) {
            s.remove(l);
        }
        return this;
    }

    public synchronized ConfigStore update(String name, String contents) {
        Set<ConfigStoreListener> s = this.listeners.get(name = this.resolveName(name));
        if (Utils.nn(s)) {
            this.listeners.get(name).forEach(x -> x.onChange(contents));
        }
        return this;
    }

    public synchronized ConfigStore update(String name, String ... contentLines) {
        name = this.resolveName(name);
        StringBuilder sb = new StringBuilder();
        for (String l : contentLines) {
            sb.append(l).append('\n');
        }
        return this.update(name, sb.toString());
    }

    public abstract String write(String var1, String var2, String var3) throws IOException;

    protected String resolveName(String name) {
        return name;
    }

    @Override
    protected FluentMap<String, Object> properties() {
        return super.properties();
    }

    public static abstract class Builder
    extends Context.Builder {
        protected Builder() {
        }

        protected Builder(Builder copyFrom) {
            super(copyFrom);
        }

        protected Builder(ConfigStore copyFrom) {
            super(copyFrom);
        }

        @Override
        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        @Override
        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        @Override
        public Builder applyAnnotations(Class<?> ... from) {
            super.applyAnnotations(from);
            return this;
        }

        @Override
        public Builder applyAnnotations(Object ... from) {
            super.applyAnnotations(from);
            return this;
        }

        @Override
        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache(value);
            return this;
        }

        @Override
        public abstract Builder copy();

        @Override
        public Builder debug() {
            super.debug();
            return this;
        }

        @Override
        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        @Override
        public Builder type(Class<? extends Context> value) {
            super.type(value);
            return this;
        }
    }
}

