/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config.event;

import java.util.List;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.config.event.ConfigEventType;

public class ConfigEvent {
    private final ConfigEventType type;
    private final String config;
    private final String section;
    private final String key;
    private final String value;
    private final String comment;
    private final List<String> preLines;
    private final String modifiers;

    public static ConfigEvent removeEntry(String config, String section, String key) {
        return new ConfigEvent(ConfigEventType.REMOVE_ENTRY, config, section, key, null, null, null, null);
    }

    public static ConfigEvent removeSection(String config, String section) {
        return new ConfigEvent(ConfigEventType.REMOVE_SECTION, config, section, null, null, null, null, null);
    }

    public static ConfigEvent setEntry(String config, String section, String key, String value, String modifiers, String comment, List<String> prelines) {
        return new ConfigEvent(ConfigEventType.SET_ENTRY, config, section, key, value, modifiers, comment, prelines);
    }

    public static ConfigEvent setSection(String config, String section, List<String> prelines) {
        return new ConfigEvent(ConfigEventType.SET_SECTION, config, section, null, null, null, null, prelines);
    }

    protected ConfigEvent(ConfigEventType type, String config, String section, String key, String value, String modifiers, String comment, List<String> preLines) {
        this.type = type;
        this.config = config;
        this.section = section;
        this.key = key;
        this.value = value;
        this.comment = comment;
        this.preLines = preLines;
        this.modifiers = modifiers;
    }

    public String getComment() {
        return this.comment;
    }

    public String getConfig() {
        return this.config;
    }

    public String getKey() {
        return this.key;
    }

    public String getModifiers() {
        return this.modifiers;
    }

    public List<String> getPreLines() {
        return this.preLines;
    }

    public String getSection() {
        return this.section;
    }

    public ConfigEventType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return switch (this.type) {
            case ConfigEventType.REMOVE_SECTION -> "REMOVE_SECTION(" + this.section + ")";
            case ConfigEventType.REMOVE_ENTRY -> "REMOVE_ENTRY(" + this.section + (this.section.isEmpty() ? "" : "/") + this.key + ")";
            case ConfigEventType.SET_SECTION -> "SET_SECTION(" + this.section + ", preLines=" + StringUtils.join(this.preLines, '|') + ")";
            case ConfigEventType.SET_ENTRY -> {
                String val;
                StringBuilder out = new StringBuilder("SET(");
                out.append(this.section + (this.section.isEmpty() ? "" : "/") + this.key);
                if (Utils.nn(this.modifiers)) {
                    out.append(this.modifiers);
                }
                out.append(" = ");
                String v1 = val = this.value == null ? "null" : this.value;
                if (val.indexOf(10) != -1) {
                    val = val.replaceAll("(\\r?\\n)", "$1\t");
                }
                if (val.indexOf(35) != -1) {
                    val = val.replace("#", "\\#");
                }
                out.append(val);
                if (Utils.ne(this.comment)) {
                    out.append(" # ").append(this.comment);
                }
                out.append(')');
                yield out.toString();
            }
            default -> null;
        };
    }
}

