/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.mock;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.security.Principal;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.http.HttpRequest;
import org.apache.juneau.common.internal.IOUtils;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.http.HttpHeaders;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.rest.mock.MockHttpSession;
import org.apache.juneau.rest.mock.MockRestRequest;
import org.apache.juneau.rest.util.BoundedServletInputStream;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;

public class MockServletRequest
implements HttpServletRequest {
    private String method = "GET";
    private Map<String, String[]> queryDataMap = CollectionUtils.map();
    private Map<String, String[]> formDataMap;
    private Map<String, String[]> headerMap = new TreeMap<String, String[]>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, Object> attributeMap = CollectionUtils.map();
    private String characterEncoding = "UTF-8";
    private byte[] content = new byte[0];
    private String protocol = "HTTP/1.1";
    private String scheme = "http";
    private String serverName = "localhost";
    private int serverPort = 8080;
    private String remoteAddr = "";
    private String remoteHost = "";
    private Locale locale = Locale.ENGLISH;
    private int remotePort;
    private String localName;
    private String localAddr;
    private int localPort;
    private Map<String, RequestDispatcher> requestDispatcher = CollectionUtils.map();
    private ServletContext servletContext;
    private DispatcherType dispatcherType;
    private String authType;
    private Cookie[] cookies;
    private String pathInfo;
    private String pathTranslated;
    private String contextPath = "";
    private String queryString;
    private String remoteUser;
    private Principal userPrincipal;
    private String requestedSessionId;
    private String requestURI;
    private String servletPath = "";
    private HttpSession httpSession = MockHttpSession.create();
    private String uri = "";
    private Set<String> roles = CollectionUtils.set(new String[0]);

    public static MockServletRequest create() {
        MockServletRequest r = new MockServletRequest();
        return r;
    }

    public static MockServletRequest create(String method, String uri, Object ... pathArgs) {
        return MockServletRequest.create().method(method).uri(StringUtils.format(uri, pathArgs));
    }

    public MockServletRequest uri(String uri) {
        this.uri = uri = StringUtils.emptyIfNull(uri);
        if (uri.indexOf(63) != -1) {
            String qs = uri.substring(uri.indexOf(63) + 1);
            if (qs.indexOf(35) != -1) {
                qs = qs.substring(0, qs.indexOf(35));
            }
            this.queryString = qs;
            this.queryDataMap.putAll(RestUtils.parseQuery(qs));
        }
        return this;
    }

    public MockServletRequest roles(String ... roles) {
        this.roles = CollectionUtils.set(roles);
        return this;
    }

    public MockServletRequest pathVars(Map<String, String> pathVars) {
        if (pathVars != null) {
            this.attributeMap.put("juneau.pathVars", new TreeMap<String, String>(pathVars));
        }
        return this;
    }

    public MockServletRequest pathVars(String ... pairs) {
        return this.pathVars(CollectionUtils.mapBuilder(String.class, String.class, new Type[0]).addPairs(pairs).build());
    }

    public MockServletRequest role(String role) {
        this.roles = CollectionUtils.set(role);
        return this;
    }

    public MockServletRequest method(String value) {
        this.method = value;
        return this;
    }

    public MockServletRequest characterEncoding(String value) {
        this.characterEncoding = value;
        return this;
    }

    public MockServletRequest protocol(String value) {
        this.protocol = value;
        return this;
    }

    public MockServletRequest scheme(String value) {
        this.scheme = value;
        return this;
    }

    public MockServletRequest serverName(String value) {
        this.serverName = value;
        return this;
    }

    public MockServletRequest serverPort(int value) {
        this.serverPort = value;
        return this;
    }

    public MockServletRequest remoteAddr(String value) {
        this.remoteAddr = value;
        return this;
    }

    public MockServletRequest remoteHost(String value) {
        this.remoteHost = value;
        return this;
    }

    public MockServletRequest locale(Locale value) {
        this.locale = value;
        return this;
    }

    public MockServletRequest remotePort(int value) {
        this.remotePort = value;
        return this;
    }

    public MockServletRequest localName(String value) {
        this.localName = value;
        return this;
    }

    public MockServletRequest localAddr(String value) {
        this.localAddr = value;
        return this;
    }

    public MockServletRequest localPort(int value) {
        this.localPort = value;
        return this;
    }

    public MockServletRequest requestDispatcher(String name, RequestDispatcher value) {
        this.requestDispatcher.put(name, value);
        return this;
    }

    public MockServletRequest servletContext(ServletContext value) {
        this.servletContext = value;
        return this;
    }

    public MockServletRequest dispatcherType(DispatcherType value) {
        this.dispatcherType = value;
        return this;
    }

    public MockServletRequest authType(String value) {
        this.authType = value;
        return this;
    }

    public MockServletRequest cookies(Cookie[] value) {
        this.cookies = value;
        return this;
    }

    public MockServletRequest pathInfo(String value) {
        this.pathInfo = value;
        return this;
    }

    public MockServletRequest pathTranslated(String value) {
        this.pathTranslated = value;
        return this;
    }

    public MockServletRequest contextPath(String value) {
        this.contextPath = value;
        return this;
    }

    public MockServletRequest queryString(String value) {
        this.queryString = value;
        return this;
    }

    public MockServletRequest remoteUser(String value) {
        this.remoteUser = value;
        return this;
    }

    public MockServletRequest userPrincipal(Principal value) {
        this.userPrincipal = value;
        return this;
    }

    public MockServletRequest requestedSessionId(String value) {
        this.requestedSessionId = value;
        return this;
    }

    public MockServletRequest requestURI(String value) {
        this.requestURI = value;
        return this;
    }

    public MockServletRequest servletPath(String value) {
        this.servletPath = value;
        return this;
    }

    public MockServletRequest httpSession(HttpSession value) {
        this.httpSession = value;
        return this;
    }

    public Object getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributeMap.keySet());
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) throws UnsupportedEncodingException {
        this.characterEncoding = characterEncoding;
    }

    public int getContentLength() {
        return this.content == null ? 0 : this.content.length;
    }

    public long getContentLengthLong() {
        return this.content == null ? 0L : (long)this.content.length;
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.formDataMap != null) {
            this.content = UrlEncodingSerializer.DEFAULT.toString(this.formDataMap).getBytes();
        }
        return new BoundedServletInputStream(new ByteArrayInputStream(this.content), Integer.MAX_VALUE);
    }

    public String getParameter(String name) {
        String[] s = this.getParameterMap().get(name);
        return s == null || s.length == 0 ? null : s[0];
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(CollectionUtils.listFrom(this.getParameterMap().keySet()));
    }

    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }

    public Map<String, String[]> getParameterMap() {
        if ("POST".equalsIgnoreCase(this.method)) {
            if (this.formDataMap == null) {
                this.formDataMap = RestUtils.parseQuery(IOUtils.read(this.content));
            }
            return this.formDataMap;
        }
        return this.queryDataMap;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this.characterEncoding));
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setAttribute(String name, Object o) {
        this.attributeMap.put(name, o);
    }

    public void removeAttribute(String name) {
        this.attributeMap.remove(name);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(CollectionUtils.alist(this.locale));
    }

    public boolean isSecure() {
        return false;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.requestDispatcher.get(path);
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return null;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return null;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public DispatcherType getDispatcherType() {
        return this.dispatcherType;
    }

    public String getAuthType() {
        return this.authType;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public long getDateHeader(String name) {
        String s = this.getHeader(name);
        return s == null ? 0L : ((ZonedDateTime)HttpHeaders.date((String)s).asZonedDateTime().get()).toInstant().toEpochMilli();
    }

    public String getHeader(String name) {
        String[] s = this.headerMap.get(name);
        return s == null || s.length == 0 ? null : s[0];
    }

    public Enumeration<String> getHeaders(String name) {
        String[] s = this.headerMap.get(name);
        return Collections.enumeration(CollectionUtils.alist(s == null ? new String[]{} : s));
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headerMap.keySet());
    }

    public int getIntHeader(String name) {
        String s = this.getHeader(name);
        return s == null || s.isEmpty() ? 0 : Integer.parseInt(s);
    }

    public String getMethod() {
        return this.method;
    }

    public String getPathInfo() {
        if (this.pathInfo == null) {
            this.pathInfo = this.getRequestURI();
            if (StringUtils.isNotEmpty(this.contextPath)) {
                this.pathInfo = this.pathInfo.substring(this.contextPath.length());
            }
            if (StringUtils.isNotEmpty(this.servletPath)) {
                this.pathInfo = this.pathInfo.substring(this.servletPath.length());
            }
        }
        return StringUtils.nullIfEmpty(StringUtils.urlDecode(this.pathInfo));
    }

    public String getPathTranslated() {
        if (this.pathTranslated == null) {
            this.pathTranslated = "/mock-path" + this.getPathInfo();
        }
        return this.pathTranslated;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getQueryString() {
        if (this.queryString == null) {
            if (this.queryDataMap.isEmpty()) {
                this.queryString = "";
            } else {
                StringBuilder sb = new StringBuilder();
                this.queryDataMap.forEach((k, v) -> {
                    if (v == null) {
                        sb.append(sb.length() == 0 ? "" : "&").append(StringUtils.urlEncode(k));
                    } else {
                        for (String v2 : v) {
                            sb.append(sb.length() == 0 ? "" : "&").append(StringUtils.urlEncode(k)).append('=').append(StringUtils.urlEncode(v2));
                        }
                    }
                });
                this.queryString = sb.toString();
            }
        }
        return StringUtils.isEmpty(this.queryString) ? null : this.queryString;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public boolean isUserInRole(String role) {
        return this.roles.contains(role);
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public String getRequestURI() {
        if (this.requestURI == null) {
            this.requestURI = this.uri;
            this.requestURI = this.requestURI.replaceAll("^\\w+\\:\\/\\/[^\\/]+", "").replaceAll("\\?.*$", "");
        }
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.uri.replaceAll("\\?.*$", ""));
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession(boolean create) {
        return this.httpSession;
    }

    public HttpSession getSession() {
        return this.httpSession;
    }

    public String changeSessionId() {
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return false;
    }

    public void login(String username, String password) throws ServletException {
    }

    public void logout() throws ServletException {
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return null;
    }

    public Part getPart(String name) throws IOException, ServletException {
        return null;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        return null;
    }

    public MockServletRequest header(String name, Object value) {
        if (value != null) {
            String[] stringArray;
            if (value instanceof String[]) {
                stringArray = (String[])value;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = value.toString();
            }
            String[] v1 = stringArray;
            String[] v2 = this.headerMap.get(name);
            String[] v3 = ArrayUtils.combine(v2, v1);
            this.headerMap.put(name, v3);
        }
        return this;
    }

    public MockServletRequest attribute(String name, Object value) {
        this.attributeMap.put(name, value);
        return this;
    }

    public MockServletRequest content(Object value) {
        try {
            if (value instanceof byte[]) {
                this.content = (byte[])value;
            } else if (value instanceof Reader) {
                this.content = IOUtils.readBytes((Reader)value);
            } else if (value instanceof InputStream) {
                this.content = IOUtils.readBytes((InputStream)value);
            } else if (value instanceof CharSequence) {
                this.content = ((CharSequence)value).toString().getBytes();
            } else if (value != null) {
                this.content = value.toString().getBytes();
            }
        }
        catch (IOException e) {
            throw ThrowableUtils.asRuntimeException(e);
        }
        return this;
    }

    protected MockServletRequest debug(boolean value) {
        if (value) {
            this.header("Debug", "true");
        }
        return this;
    }

    public MockServletRequest noTrace(boolean value) {
        if (value) {
            this.header("No-Trace", "true");
        }
        return this;
    }

    public MockServletRequest applyOverrides(HttpRequest req) {
        if (req instanceof MockRestRequest) {
            MockRestRequest mreq = (MockRestRequest)((Object)req);
            mreq.getAttributeMap().forEach(this::attribute);
            mreq.getRequestDispatcherMap().forEach(this::requestDispatcher);
            if (mreq.getCharacterEncoding() != null) {
                this.characterEncoding(mreq.getCharacterEncoding());
            }
            if (mreq.getProtocol() != null) {
                this.protocol(mreq.getProtocol());
            }
            if (mreq.getScheme() != null) {
                this.scheme(mreq.getScheme());
            }
            if (mreq.getServerName() != null) {
                this.serverName(mreq.getServerName());
            }
            if (mreq.getRemoteAddr() != null) {
                this.remoteAddr(mreq.getRemoteAddr());
            }
            if (mreq.getRemoteHost() != null) {
                this.remoteHost(mreq.getRemoteHost());
            }
            if (mreq.getLocalName() != null) {
                this.localName(mreq.getLocalName());
            }
            if (mreq.getLocalAddr() != null) {
                this.localAddr(mreq.getLocalAddr());
            }
            if (mreq.getPathInfo() != null) {
                this.pathInfo(mreq.getPathInfo());
            }
            if (mreq.getPathTranslated() != null) {
                this.pathTranslated(mreq.getPathTranslated());
            }
            if (mreq.getContextPath() != null) {
                this.contextPath(mreq.getContextPath());
            }
            if (mreq.getQueryString() != null) {
                this.queryString(mreq.getQueryString());
            }
            if (mreq.getRemoteUser() != null) {
                this.remoteUser(mreq.getRemoteUser());
            }
            if (mreq.getRequestedSessionId() != null) {
                this.requestedSessionId(mreq.getRequestedSessionId());
            }
            if (mreq.getRequestURI() != null) {
                this.requestURI(mreq.getRequestURI());
            }
            if (mreq.getServletPath() != null) {
                this.servletPath(mreq.getServletPath());
            }
            if (mreq.getAuthType() != null) {
                this.authType(mreq.getAuthType());
            }
            if (mreq.getServerPort() != null) {
                this.serverPort(mreq.getServerPort());
            }
            if (mreq.getRemotePort() != null) {
                this.remotePort(mreq.getRemotePort());
            }
            if (mreq.getLocalPort() != null) {
                this.localPort(mreq.getLocalPort());
            }
            if (mreq.getLocale() != null) {
                this.locale(mreq.getLocale());
            }
            if (mreq.getServletContext() != null) {
                this.servletContext(mreq.getServletContext());
            }
            if (mreq.getDispatcherType() != null) {
                this.dispatcherType(mreq.getDispatcherType());
            }
            if (mreq.getCookies() != null) {
                this.cookies(mreq.getCookies());
            }
            if (mreq.getUserPrincipal() != null) {
                this.userPrincipal(mreq.getUserPrincipal());
            }
            if (mreq.getHttpSession() != null) {
                this.httpSession(mreq.getHttpSession());
            }
            if (mreq.getRoles() != null) {
                this.roles(mreq.getRoles());
            }
        }
        return this;
    }

    public String getRequestId() {
        return null;
    }

    public String getProtocolRequestId() {
        return null;
    }

    public ServletConnection getServletConnection() {
        return null;
    }
}

