/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.serializer;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.BeanTraverseBuilder;
import org.apache.juneau.BinaryFormat;
import org.apache.juneau.ContextCache;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.Visibility;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.serializer.SerializerListener;
import org.apache.juneau.svl.VarResolverSession;

public class SerializerGroupBuilder
extends BeanTraverseBuilder {
    private final List<Object> serializers = new ArrayList<Object>();

    public SerializerGroupBuilder() {
    }

    public SerializerGroupBuilder(SerializerGroup copyFrom) {
        super(copyFrom.getPropertyStore());
        CollectionUtils.addReverse(this.serializers, copyFrom.getSerializers());
    }

    public SerializerGroupBuilder append(Class<?> ... s) {
        CollectionUtils.addReverse(this.serializers, s);
        return this;
    }

    public SerializerGroupBuilder append(Serializer ... s) {
        CollectionUtils.addReverse(this.serializers, s);
        return this;
    }

    public SerializerGroupBuilder append(List<Object> s) {
        CollectionUtils.addReverse(this.serializers, s);
        return this;
    }

    public SerializerGroupBuilder append(Object ... s) {
        CollectionUtils.addReverse(this.serializers, s);
        return this;
    }

    @Override
    public SerializerGroup build() {
        ArrayList<Serializer> l = new ArrayList<Serializer>();
        for (Object s : this.serializers) {
            Class c = null;
            PropertyStore ps = this.getPropertyStore();
            if (s instanceof Class) {
                c = (Class)s;
                l.add((Serializer)ContextCache.INSTANCE.create(c, ps));
                continue;
            }
            l.add((Serializer)s);
        }
        return new SerializerGroup(this.getPropertyStore(), ArrayUtils.toReverseArray(Serializer.class, l));
    }

    public SerializerGroupBuilder addBeanTypes(boolean value) {
        return this.set("Serializer.addBeanTypes.b", value);
    }

    public SerializerGroupBuilder addBeanTypes() {
        return this.set("Serializer.addBeanTypes.b", true);
    }

    public SerializerGroupBuilder addRootType(boolean value) {
        return this.set("Serializer.addRootType.b", value);
    }

    public SerializerGroupBuilder addRootType() {
        return this.set("Serializer.addRootType.b", true);
    }

    public SerializerGroupBuilder listener(Class<? extends SerializerListener> value) {
        return this.set("Serializer.listener.c", value);
    }

    public SerializerGroupBuilder sortCollections(boolean value) {
        return this.set("Serializer.sortCollections.b", value);
    }

    public SerializerGroupBuilder sortCollections() {
        return this.set("Serializer.sortCollections.b", true);
    }

    public SerializerGroupBuilder sortMaps(boolean value) {
        return this.set("Serializer.sortMaps.b", value);
    }

    public SerializerGroupBuilder sortMaps() {
        return this.set("Serializer.sortMaps.b", true);
    }

    public SerializerGroupBuilder trimEmptyCollections(boolean value) {
        return this.set("Serializer.trimEmptyCollections.b", value);
    }

    public SerializerGroupBuilder trimEmptyCollections() {
        return this.set("Serializer.trimEmptyCollections.b", true);
    }

    public SerializerGroupBuilder trimEmptyMaps(boolean value) {
        return this.set("Serializer.trimEmptyMaps.b", value);
    }

    public SerializerGroupBuilder trimEmptyMaps() {
        return this.set("Serializer.trimEmptyMaps.b", true);
    }

    public SerializerGroupBuilder trimNullProperties(boolean value) {
        return this.set("Serializer.trimNullProperties.b", value);
    }

    public SerializerGroupBuilder trimStrings(boolean value) {
        return this.set("Serializer.trimStrings.b", value);
    }

    public SerializerGroupBuilder trimStrings() {
        return this.set("Serializer.trimStrings.b", true);
    }

    public SerializerGroupBuilder uriContext(UriContext value) {
        return this.set("Serializer.uriContext.s", value);
    }

    public SerializerGroupBuilder uriRelativity(UriRelativity value) {
        return this.set("Serializer.uriRelativity.s", (Object)value);
    }

    public SerializerGroupBuilder uriResolution(UriResolution value) {
        return this.set("Serializer.uriResolution.s", (Object)value);
    }

    public SerializerGroupBuilder binaryOutputFormat(BinaryFormat value) {
        return this.set("OutputStreamSerializer.binaryFormat.s", (Object)value);
    }

    public SerializerGroupBuilder fileCharset(Charset value) {
        return this.set("WriterSerializer.fileCharset.s", value);
    }

    public SerializerGroupBuilder maxIndent(int value) {
        return this.set("WriterSerializer.maxIndent.i", value);
    }

    public SerializerGroupBuilder quoteChar(char value) {
        return this.set("WriterSerializer.quoteChar.s", Character.valueOf(value));
    }

    public SerializerGroupBuilder sq() {
        return this.quoteChar('\'');
    }

    public SerializerGroupBuilder streamCharset(Charset value) {
        return this.set("WriterSerializer.streamCharset.s", value);
    }

    public SerializerGroupBuilder useWhitespace(boolean value) {
        return this.set("WriterSerializer.useWhitespace.b", value);
    }

    public SerializerGroupBuilder useWhitespace() {
        return this.set("WriterSerializer.useWhitespace.b", true);
    }

    public SerializerGroupBuilder ws() {
        return this.useWhitespace();
    }

    @Override
    public SerializerGroupBuilder detectRecursions(boolean value) {
        super.detectRecursions(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder detectRecursions() {
        super.detectRecursions();
        return this;
    }

    @Override
    public SerializerGroupBuilder ignoreRecursions(boolean value) {
        super.ignoreRecursions(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder ignoreRecursions() {
        super.ignoreRecursions();
        return this;
    }

    @Override
    public SerializerGroupBuilder initialDepth(int value) {
        super.initialDepth(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder maxDepth(int value) {
        super.maxDepth(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder annotations(Annotation ... values) {
        super.annotations(values);
        return this;
    }

    @Override
    public SerializerGroupBuilder beanClassVisibility(Visibility value) {
        super.beanClassVisibility(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder beanConstructorVisibility(Visibility value) {
        super.beanConstructorVisibility(value);
        return this;
    }

    @Override
    @Deprecated
    public SerializerGroupBuilder beanDictionary(Class<?> ... values) {
        super.beanDictionary((Class[])values);
        return this;
    }

    @Override
    @Deprecated
    public SerializerGroupBuilder beanDictionary(Object ... values) {
        super.beanDictionary(values);
        return this;
    }

    @Override
    @Deprecated
    public SerializerGroupBuilder beanDictionaryReplace(Class<?> ... values) {
        super.beanDictionaryReplace((Class[])values);
        return this;
    }

    @Override
    @Deprecated
    public SerializerGroupBuilder beanDictionaryReplace(Object ... values) {
        super.beanDictionaryReplace(values);
        return this;
    }

    @Override
    @Deprecated
    public SerializerGroupBuilder beanDictionaryRemove(Class<?> ... values) {
        super.beanDictionaryRemove((Class[])values);
        return this;
    }

    @Override
    @Deprecated
    public SerializerGroupBuilder beanDictionaryRemove(Object ... values) {
        super.beanDictionaryRemove(values);
        return this;
    }

    @Override
    public SerializerGroupBuilder beanFieldVisibility(Visibility value) {
        super.beanFieldVisibility(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder beanFilters(Class<?> ... values) {
        super.beanFilters((Class[])values);
        return this;
    }

    @Override
    public SerializerGroupBuilder beanFilters(Object ... values) {
        super.beanFilters(values);
        return this;
    }

    @Override
    public SerializerGroupBuilder beanFiltersReplace(Class<?> ... values) {
        super.beanFiltersReplace((Class[])values);
        return this;
    }

    @Override
    public SerializerGroupBuilder beanFiltersReplace(Object ... values) {
        super.beanFiltersReplace(values);
        return this;
    }

    @Override
    public SerializerGroupBuilder beanFiltersRemove(Class<?> ... values) {
        super.beanFiltersRemove((Class[])values);
        return this;
    }

    @Override
    public SerializerGroupBuilder beanFiltersRemove(Object ... values) {
        super.beanFiltersRemove(values);
        return this;
    }

    @Override
    public SerializerGroupBuilder beanMapPutReturnsOldValue(boolean value) {
        super.beanMapPutReturnsOldValue(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder beanMapPutReturnsOldValue() {
        super.beanMapPutReturnsOldValue();
        return this;
    }

    @Override
    public SerializerGroupBuilder beanMethodVisibility(Visibility value) {
        super.beanMethodVisibility(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder beansRequireDefaultConstructor(boolean value) {
        super.beansRequireDefaultConstructor(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder beansRequireDefaultConstructor() {
        super.beansRequireDefaultConstructor();
        return this;
    }

    @Override
    public SerializerGroupBuilder beansRequireSerializable(boolean value) {
        super.beansRequireSerializable(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder beansRequireSerializable() {
        super.beansRequireSerializable();
        return this;
    }

    @Override
    public SerializerGroupBuilder beansRequireSettersForGetters(boolean value) {
        super.beansRequireSettersForGetters(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder beansRequireSettersForGetters() {
        super.beansRequireSettersForGetters();
        return this;
    }

    @Override
    public SerializerGroupBuilder beansRequireSomeProperties(boolean value) {
        super.beansRequireSomeProperties(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder beanTypePropertyName(String value) {
        super.beanTypePropertyName(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder bpi(Class<?> beanClass, String value) {
        super.bpi((Class)beanClass, value);
        return this;
    }

    @Override
    public SerializerGroupBuilder bpi(Map<String, String> values) {
        super.bpi((Map)values);
        return this;
    }

    @Override
    public SerializerGroupBuilder bpi(String beanClassName, String value) {
        super.bpi(beanClassName, value);
        return this;
    }

    @Override
    public SerializerGroupBuilder bpx(Class<?> beanClass, String properties) {
        super.bpx((Class)beanClass, properties);
        return this;
    }

    @Override
    public SerializerGroupBuilder bpx(Map<String, String> values) {
        super.bpx((Map)values);
        return this;
    }

    @Override
    public SerializerGroupBuilder bpx(String beanClassName, String value) {
        super.bpx(beanClassName, value);
        return this;
    }

    @Override
    public SerializerGroupBuilder bpro(Class<?> beanClass, String value) {
        super.bpro((Class)beanClass, value);
        return this;
    }

    @Override
    public SerializerGroupBuilder bpro(Map<String, String> values) {
        super.bpro((Map)values);
        return this;
    }

    @Override
    public SerializerGroupBuilder bpro(String beanClassName, String value) {
        super.bpro(beanClassName, value);
        return this;
    }

    @Override
    public SerializerGroupBuilder bpwo(Class<?> beanClass, String properties) {
        super.bpwo((Class)beanClass, properties);
        return this;
    }

    @Override
    public SerializerGroupBuilder bpwo(Map<String, String> values) {
        super.bpwo((Map)values);
        return this;
    }

    @Override
    public SerializerGroupBuilder bpwo(String beanClassName, String value) {
        super.bpwo(beanClassName, value);
        return this;
    }

    @Override
    public SerializerGroupBuilder debug() {
        super.debug();
        return this;
    }

    @Override
    public SerializerGroupBuilder dictionary(Class<?> ... values) {
        super.dictionary((Class[])values);
        return this;
    }

    @Override
    public SerializerGroupBuilder dictionary(Object ... values) {
        super.dictionary(values);
        return this;
    }

    @Override
    public SerializerGroupBuilder dictionaryReplace(Class<?> ... values) {
        super.dictionaryReplace((Class[])values);
        return this;
    }

    @Override
    public SerializerGroupBuilder dictionaryReplace(Object ... values) {
        super.dictionaryReplace(values);
        return this;
    }

    @Override
    public SerializerGroupBuilder dictionaryRemove(Class<?> ... values) {
        super.dictionaryRemove((Class[])values);
        return this;
    }

    @Override
    public SerializerGroupBuilder dictionaryRemove(Object ... values) {
        super.dictionaryRemove(values);
        return this;
    }

    @Override
    public <T> SerializerGroupBuilder example(Class<T> c, T o) {
        super.example((Class)c, (Object)o);
        return this;
    }

    @Override
    public <T> SerializerGroupBuilder exampleJson(Class<T> c, String value) {
        super.exampleJson((Class)c, value);
        return this;
    }

    @Override
    public SerializerGroupBuilder ignoreInvocationExceptionsOnGetters(boolean value) {
        super.ignoreInvocationExceptionsOnGetters(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder ignoreInvocationExceptionsOnGetters() {
        super.ignoreInvocationExceptionsOnGetters();
        return this;
    }

    @Override
    public SerializerGroupBuilder ignoreInvocationExceptionsOnSetters(boolean value) {
        super.ignoreInvocationExceptionsOnSetters(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder ignoreInvocationExceptionsOnSetters() {
        super.ignoreInvocationExceptionsOnSetters();
        return this;
    }

    @Override
    public SerializerGroupBuilder ignorePropertiesWithoutSetters(boolean value) {
        super.ignorePropertiesWithoutSetters(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder ignoreUnknownBeanProperties(boolean value) {
        super.ignoreUnknownBeanProperties(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder ignoreUnknownBeanProperties() {
        super.ignoreUnknownBeanProperties();
        return this;
    }

    @Override
    public SerializerGroupBuilder ignoreUnknownNullBeanProperties(boolean value) {
        super.ignoreUnknownNullBeanProperties(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder implClass(Class<?> interfaceClass, Class<?> implClass) {
        super.implClass((Class)interfaceClass, (Class)implClass);
        return this;
    }

    @Override
    public SerializerGroupBuilder implClasses(Map<String, Class<?>> values) {
        super.implClasses((Map)values);
        return this;
    }

    @Override
    public SerializerGroupBuilder locale(Locale value) {
        super.locale(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder mediaType(MediaType value) {
        super.mediaType(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder notBeanClasses(Class<?> ... values) {
        super.notBeanClasses((Class[])values);
        return this;
    }

    @Override
    public SerializerGroupBuilder notBeanClasses(Object ... values) {
        super.notBeanClasses(values);
        return this;
    }

    @Override
    public SerializerGroupBuilder notBeanClassesReplace(Class<?> ... values) {
        super.notBeanClassesReplace((Class[])values);
        return this;
    }

    @Override
    public SerializerGroupBuilder notBeanClassesReplace(Object ... values) {
        super.notBeanClassesReplace(values);
        return this;
    }

    @Override
    public SerializerGroupBuilder notBeanClassesRemove(Class<?> ... values) {
        super.notBeanClassesRemove((Class[])values);
        return this;
    }

    @Override
    public SerializerGroupBuilder notBeanClassesRemove(Object ... values) {
        super.notBeanClassesRemove(values);
        return this;
    }

    @Override
    public SerializerGroupBuilder notBeanPackages(Object ... values) {
        super.notBeanPackages(values);
        return this;
    }

    @Override
    public SerializerGroupBuilder notBeanPackages(String ... values) {
        super.notBeanPackages(values);
        return this;
    }

    @Override
    public SerializerGroupBuilder notBeanPackagesReplace(String ... values) {
        super.notBeanPackagesReplace(values);
        return this;
    }

    @Override
    public SerializerGroupBuilder notBeanPackagesReplace(Object ... values) {
        super.notBeanPackagesReplace(values);
        return this;
    }

    @Override
    public SerializerGroupBuilder notBeanPackagesRemove(String ... values) {
        super.notBeanPackagesRemove(values);
        return this;
    }

    @Override
    public SerializerGroupBuilder notBeanPackagesRemove(Object ... values) {
        super.notBeanPackagesRemove(values);
        return this;
    }

    @Override
    public SerializerGroupBuilder pojoSwaps(Class<?> ... values) {
        super.pojoSwaps((Class[])values);
        return this;
    }

    @Override
    public SerializerGroupBuilder pojoSwaps(Object ... values) {
        super.pojoSwaps(values);
        return this;
    }

    @Override
    public SerializerGroupBuilder pojoSwapsReplace(Class<?> ... values) {
        super.pojoSwapsReplace((Class[])values);
        return this;
    }

    @Override
    public SerializerGroupBuilder pojoSwapsReplace(Object ... values) {
        super.pojoSwapsReplace(values);
        return this;
    }

    @Override
    public SerializerGroupBuilder pojoSwapsRemove(Class<?> ... values) {
        super.pojoSwapsRemove((Class[])values);
        return this;
    }

    @Override
    public SerializerGroupBuilder pojoSwapsRemove(Object ... values) {
        super.pojoSwapsRemove(values);
        return this;
    }

    @Override
    public SerializerGroupBuilder sortProperties(boolean value) {
        super.sortProperties(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder sortProperties() {
        super.sortProperties();
        return this;
    }

    @Override
    public SerializerGroupBuilder timeZone(TimeZone value) {
        super.timeZone(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder useEnumNames(boolean value) {
        super.useEnumNames(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder useEnumNames() {
        super.useEnumNames();
        return this;
    }

    @Override
    public SerializerGroupBuilder useInterfaceProxies(boolean value) {
        super.useInterfaceProxies(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder useJavaBeanIntrospector(boolean value) {
        super.useJavaBeanIntrospector(value);
        return this;
    }

    @Override
    public SerializerGroupBuilder useJavaBeanIntrospector() {
        super.useJavaBeanIntrospector();
        return this;
    }

    @Override
    public SerializerGroupBuilder set(String name, Object value) {
        super.set(name, value);
        return this;
    }

    @Override
    public SerializerGroupBuilder set(Map<String, Object> properties) {
        super.set((Map)properties);
        return this;
    }

    @Override
    public SerializerGroupBuilder add(Map<String, Object> properties) {
        super.add((Map)properties);
        return this;
    }

    @Override
    public SerializerGroupBuilder addTo(String name, Object value) {
        super.addTo(name, value);
        return this;
    }

    @Override
    public SerializerGroupBuilder addTo(String name, String key, Object value) {
        super.addTo(name, key, value);
        return this;
    }

    @Override
    public SerializerGroupBuilder removeFrom(String name, Object value) {
        super.removeFrom(name, value);
        return this;
    }

    @Override
    public SerializerGroupBuilder apply(PropertyStore copyFrom) {
        super.apply(copyFrom);
        return this;
    }

    @Override
    public SerializerGroupBuilder applyAnnotations(AnnotationList al, VarResolverSession vrs) {
        super.applyAnnotations(al, vrs);
        return this;
    }

    @Override
    public SerializerGroupBuilder applyAnnotations(Class<?> ... fromClasses) {
        super.applyAnnotations((Class[])fromClasses);
        return this;
    }

    @Override
    public SerializerGroupBuilder applyAnnotations(Method ... fromMethods) {
        super.applyAnnotations(fromMethods);
        return this;
    }
}

