/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config.store;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.DefaultFilteringObjectMap;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.config.store.ConfigClasspathStoreBuilder;
import org.apache.juneau.config.store.ConfigStore;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;

@ConfigurableContext
public class ConfigClasspathStore
extends ConfigStore {
    static final String PREFIX = "ConfigClasspathStore";
    public static final ConfigClasspathStore DEFAULT = ConfigClasspathStore.create().build();
    private final ConcurrentHashMap<String, String> cache = new ConcurrentHashMap();

    public static ConfigClasspathStoreBuilder create() {
        return new ConfigClasspathStoreBuilder();
    }

    @Override
    public ConfigClasspathStoreBuilder builder() {
        return new ConfigClasspathStoreBuilder(this.getPropertyStore());
    }

    protected ConfigClasspathStore(PropertyStore ps) {
        super(ps);
    }

    @Override
    public synchronized String read(String name) throws IOException {
        String s = this.cache.get(name);
        if (s != null) {
            return s;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try (InputStream in = cl.getResourceAsStream(name);){
            if (in != null) {
                this.cache.put(name, IOUtils.read(in, IOUtils.UTF8));
            }
        }
        return StringUtils.emptyIfNull(this.cache.get(name));
    }

    @Override
    public synchronized String write(String name, String expectedContents, String newContents) throws IOException {
        if (StringUtils.isEquals(expectedContents, newContents)) {
            return null;
        }
        String currentContents = this.read(name);
        if (expectedContents != null && !StringUtils.isEquals(currentContents, expectedContents)) {
            return currentContents;
        }
        this.update(name, newContents);
        return null;
    }

    @Override
    public synchronized boolean exists(String name) {
        try {
            return !this.read(name).isEmpty();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public synchronized ConfigClasspathStore update(String name, String newContents) {
        if (newContents == null) {
            this.cache.remove(name);
        } else {
            this.cache.put(name, newContents);
        }
        super.update(name, newContents);
        return this;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public ObjectMap toMap() {
        return super.toMap().append(PREFIX, new DefaultFilteringObjectMap());
    }
}

