/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.thrift;

import java.io.OutputStream;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.thrift.TRDF;
import org.apache.jena.riot.thrift.ThriftConvert;
import org.apache.jena.riot.thrift.wire.RDF_PrefixDecl;
import org.apache.jena.riot.thrift.wire.RDF_Quad;
import org.apache.jena.riot.thrift.wire.RDF_StreamRow;
import org.apache.jena.riot.thrift.wire.RDF_Term;
import org.apache.jena.riot.thrift.wire.RDF_Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;

public class StreamRDF2Thrift
implements StreamRDF,
AutoCloseable {
    private final OutputStream out = null;
    private final TProtocol protocol;
    private PrefixMap pmap = PrefixMapFactory.create();
    private final boolean encodeValues;
    private final RDF_StreamRow tStreamRow = new RDF_StreamRow();
    private final RDF_Triple ttriple = new RDF_Triple();
    private final RDF_Quad tquad = new RDF_Quad();
    private final RDF_Term tsubject = new RDF_Term();
    private final RDF_Term tpredicate = new RDF_Term();
    private final RDF_Term tobject = new RDF_Term();
    private final RDF_Term tgraph = new RDF_Term();

    public StreamRDF2Thrift(OutputStream out) {
        this(out, false);
    }

    public StreamRDF2Thrift(OutputStream out, boolean encodeValues) {
        this(TRDF.protocol(out), encodeValues);
    }

    public StreamRDF2Thrift(TProtocol out, boolean encodeValues) {
        this.protocol = out;
        this.pmap = PrefixMapFactory.create();
        this.encodeValues = encodeValues;
    }

    @Override
    public void start() {
    }

    @Override
    public void triple(Triple triple) {
        this.doTriple(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTriple(Node subject, Node predicate, Node object) {
        ThriftConvert.toThrift(subject, this.pmap, this.tsubject, this.encodeValues);
        ThriftConvert.toThrift(predicate, this.pmap, this.tpredicate, this.encodeValues);
        ThriftConvert.toThrift(object, this.pmap, this.tobject, this.encodeValues);
        this.ttriple.setS(this.tsubject);
        this.ttriple.setP(this.tpredicate);
        this.ttriple.setO(this.tobject);
        this.tStreamRow.setTriple(this.ttriple);
        try {
            this.tStreamRow.write(this.protocol);
        }
        catch (TException e2) {
            TRDF.exception(e2);
        }
        finally {
            this.tStreamRow.clear();
            this.ttriple.clear();
            this.tsubject.clear();
            this.tpredicate.clear();
            this.tobject.clear();
        }
    }

    @Override
    public void quad(Quad quad) {
        if (quad.getGraph() == null || quad.isDefaultGraph()) {
            this.doTriple(quad.getSubject(), quad.getPredicate(), quad.getObject());
            return;
        }
        ThriftConvert.toThrift(quad.getGraph(), this.pmap, this.tgraph, this.encodeValues);
        ThriftConvert.toThrift(quad.getSubject(), this.pmap, this.tsubject, this.encodeValues);
        ThriftConvert.toThrift(quad.getPredicate(), this.pmap, this.tpredicate, this.encodeValues);
        ThriftConvert.toThrift(quad.getObject(), this.pmap, this.tobject, this.encodeValues);
        this.tquad.setG(this.tgraph);
        this.tquad.setS(this.tsubject);
        this.tquad.setP(this.tpredicate);
        this.tquad.setO(this.tobject);
        this.tStreamRow.setQuad(this.tquad);
        try {
            this.tStreamRow.write(this.protocol);
        }
        catch (TException e2) {
            TRDF.exception(e2);
        }
        finally {
            this.tStreamRow.clear();
            this.tquad.clear();
            this.tgraph.clear();
            this.tsubject.clear();
            this.tpredicate.clear();
            this.tobject.clear();
        }
    }

    @Override
    public void base(String base) {
    }

    @Override
    public void prefix(String prefix, String iri) {
        try {
            this.pmap.add(prefix, iri);
        }
        catch (RiotException ex) {
            Log.warn((Object)this, (String)"Prefix mapping error", (Throwable)((Object)ex));
        }
        RDF_PrefixDecl tprefix = new RDF_PrefixDecl(prefix, iri);
        this.tStreamRow.setPrefixDecl(tprefix);
        try {
            this.tStreamRow.write(this.protocol);
        }
        catch (TException e2) {
            TRDF.exception(e2);
        }
        this.tStreamRow.clear();
    }

    @Override
    public void version(String version2) {
    }

    @Override
    public void close() {
        this.finish();
    }

    @Override
    public void finish() {
        TRDF.flush(this.protocol);
    }
}

