/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import jakarta.mail.Header;
import java.util.Enumeration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.james.util.Size;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnforceHeaderLimitationsMessageHook
implements JamesMessageHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnforceHeaderLimitationsMessageHook.class);
    private static final int DEFAULT_MAX_LINES = 500;
    private static final int DEFAULT_MAX_SIZE = 65536;
    private int maxLines;
    private long maxSize;

    @Override
    public HookResult onMessage(SMTPSession session, Mail mail) {
        try {
            int actualLines = 0;
            int actualSize = 0;
            Enumeration headers = mail.getMessage().getAllHeaders();
            while (headers.hasMoreElements()) {
                Header header = (Header)headers.nextElement();
                actualSize += header.getName().length() + header.getValue().length() + 4;
                if (++actualLines > this.maxLines) {
                    LOGGER.warn("Email rejected: too many header lines");
                    return HookResult.builder().hookReturnCode(HookReturnCode.denySoft()).smtpReturnCode("552").smtpDescription("Header Lines are too many").build();
                }
                if ((long)actualSize <= this.maxSize) continue;
                LOGGER.warn("Email rejected: header size too large");
                return HookResult.builder().hookReturnCode(HookReturnCode.denySoft()).smtpReturnCode("552").smtpDescription("Header size is too large").build();
            }
            return HookResult.DECLINED;
        }
        catch (Exception e) {
            LOGGER.warn("Error while checking header size", (Throwable)e);
            return HookResult.DENY;
        }
    }

    public void init(Configuration config) throws ConfigurationException {
        this.maxLines = config.getInt("maxLines") <= 0 ? 500 : config.getInt("maxLines", 500);
        long size = Size.parse((String)config.getString("maxSize")).asBytes();
        this.maxSize = size > 0L ? size : 65536L;
    }
}

