/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ml;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class LLM
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, LLM> {
    @Nullable
    private final String modelId;
    @Nonnull
    private final Map<String, JsonData> parameters;
    public static final JsonpDeserializer<LLM> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LLM::setupLLMDeserializer);

    private LLM(Builder builder) {
        this.modelId = builder.modelId;
        this.parameters = ApiTypeHelper.unmodifiable(builder.parameters);
    }

    public static LLM of(Function<Builder, ObjectBuilder<LLM>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String modelId() {
        return this.modelId;
    }

    @Nonnull
    public final Map<String, JsonData> parameters() {
        return this.parameters;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.modelId != null) {
            generator.writeKey("model_id");
            generator.write(this.modelId);
        }
        if (ApiTypeHelper.isDefined(this.parameters)) {
            generator.writeKey("parameters");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.parameters.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupLLMDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::parameters, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "parameters");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.modelId);
        result = 31 * result + Objects.hashCode(this.parameters);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LLM other = (LLM)o;
        return Objects.equals(this.modelId, other.modelId) && Objects.equals(this.parameters, other.parameters);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, LLM> {
        @Nullable
        private String modelId;
        @Nullable
        private Map<String, JsonData> parameters;

        public Builder() {
        }

        private Builder(LLM o) {
            this.modelId = o.modelId;
            this.parameters = Builder._mapCopy(o.parameters);
        }

        private Builder(Builder o) {
            this.modelId = o.modelId;
            this.parameters = Builder._mapCopy(o.parameters);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder modelId(@Nullable String value) {
            this.modelId = value;
            return this;
        }

        @Nonnull
        public final Builder parameters(Map<String, JsonData> map) {
            this.parameters = Builder._mapPutAll(this.parameters, map);
            return this;
        }

        @Nonnull
        public final Builder parameters(String key, JsonData value) {
            this.parameters = Builder._mapPut(this.parameters, key, value);
            return this;
        }

        @Override
        @Nonnull
        public LLM build() {
            this._checkSingleUse();
            return new LLM(this);
        }
    }
}

