/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.metadata;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import jakarta.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BucketName;
import org.apache.james.core.Username;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.vault.metadata.StorageInformation;
import reactor.core.publisher.Mono;

public class StorageInformationDAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement addStatement;
    private final PreparedStatement removeStatement;
    private final PreparedStatement readStatement;
    private final BlobId.Factory blobIdFactory;

    @Inject
    StorageInformationDAO(CqlSession session, BlobId.Factory blobIdFactory) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.addStatement = this.prepareAdd(session);
        this.removeStatement = this.prepareRemove(session);
        this.readStatement = this.prepareRead(session);
        this.blobIdFactory = blobIdFactory;
    }

    private PreparedStatement prepareRead(CqlSession session) {
        return session.prepare(((Select)((Select)QueryBuilder.selectFrom((String)"storageInformation").columns(new String[]{"bucketName", "blobId"}).whereColumn("owner").isEqualTo((Term)QueryBuilder.bindMarker((String)"owner"))).whereColumn("messageId").isEqualTo((Term)QueryBuilder.bindMarker((String)"messageId"))).build());
    }

    private PreparedStatement prepareRemove(CqlSession session) {
        return session.prepare(((Delete)((Delete)QueryBuilder.deleteFrom((String)"storageInformation").whereColumn("owner").isEqualTo((Term)QueryBuilder.bindMarker((String)"owner"))).whereColumn("messageId").isEqualTo((Term)QueryBuilder.bindMarker((String)"messageId"))).build());
    }

    private PreparedStatement prepareAdd(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"storageInformation").value("owner", (Term)QueryBuilder.bindMarker((String)"owner")).value("messageId", (Term)QueryBuilder.bindMarker((String)"messageId")).value("bucketName", (Term)QueryBuilder.bindMarker((String)"bucketName")).value("blobId", (Term)QueryBuilder.bindMarker((String)"blobId")).build());
    }

    Mono<Void> referenceStorageInformation(Username username, MessageId messageId, StorageInformation storageInformation) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)((BoundStatement)((BoundStatement)this.addStatement.bind(new Object[0]).setString("owner", username.asString())).setString("messageId", messageId.serialize())).setString("bucketName", storageInformation.getBucketName().asString())).setString("blobId", storageInformation.getBlobId().asString()));
    }

    Mono<Void> deleteStorageInformation(Username username, MessageId messageId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.removeStatement.bind(new Object[0]).setString("owner", username.asString())).setString("messageId", messageId.serialize()));
    }

    Mono<StorageInformation> retrieveStorageInformation(Username username, MessageId messageId) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)((BoundStatement)this.readStatement.bind(new Object[0]).setString("owner", username.asString())).setString("messageId", messageId.serialize())).map(row -> StorageInformation.builder().bucketName(BucketName.of((String)row.getString("bucketName"))).blobId(this.blobIdFactory.parse(row.getString("blobId"))));
    }
}

