/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mailet.filter;

import com.github.fge.lambdas.Throwing;
import com.github.fge.lambdas.functions.ThrowingFunction;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import jakarta.mail.Message;
import jakarta.mail.internet.InternetAddress;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.james.javax.AddressHelper;
import org.apache.james.jmap.api.filtering.Rule;
import org.apache.james.mime4j.util.MimeUtil;
import org.apache.james.util.StreamUtils;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface HeaderExtractor
extends ThrowingFunction<Mail, Stream<String>> {
    public static final Logger LOGGER = LoggerFactory.getLogger(HeaderExtractor.class);
    public static final HeaderExtractor SUBJECT_EXTRACTOR = mail -> StreamUtils.ofNullables((Object[])new String[]{mail.getMessage().getSubject()});
    public static final HeaderExtractor CC_EXTRACTOR = HeaderExtractor.recipientExtractor(Message.RecipientType.CC);
    public static final HeaderExtractor TO_EXTRACTOR = HeaderExtractor.recipientExtractor(Message.RecipientType.TO);
    public static final HeaderExtractor RECIPIENT_EXTRACTOR = HeaderExtractor.and(TO_EXTRACTOR, CC_EXTRACTOR);
    public static final HeaderExtractor FROM_EXTRACTOR = HeaderExtractor.addressExtractor((ThrowingFunction<Mail, String[]>)((ThrowingFunction)mail -> mail.getMessage().getHeader("From")), "From");
    public static final Map<Rule.Condition.Field, HeaderExtractor> HEADER_EXTRACTOR_REGISTRY = ImmutableMap.builder().put((Object)Rule.Condition.FixedField.SUBJECT, (Object)SUBJECT_EXTRACTOR).put((Object)Rule.Condition.FixedField.RECIPIENT, (Object)RECIPIENT_EXTRACTOR).put((Object)Rule.Condition.FixedField.FROM, (Object)FROM_EXTRACTOR).put((Object)Rule.Condition.FixedField.CC, (Object)CC_EXTRACTOR).put((Object)Rule.Condition.FixedField.TO, (Object)TO_EXTRACTOR).build();
    public static final boolean STRICT_PARSING = true;

    public static HeaderExtractor and(HeaderExtractor headerExtractor1, HeaderExtractor headerExtractor2) {
        return mail -> StreamUtils.flatten((Stream[])new Stream[]{(Stream)headerExtractor1.apply(mail), (Stream)headerExtractor2.apply(mail)});
    }

    public static HeaderExtractor recipientExtractor(Message.RecipientType type) {
        String headerName = type.toString();
        ThrowingFunction addressGetter = mail -> mail.getMessage().getHeader(headerName);
        return HeaderExtractor.addressExtractor((ThrowingFunction<Mail, String[]>)addressGetter, headerName);
    }

    public static HeaderExtractor addressExtractor(ThrowingFunction<Mail, String[]> addressGetter, String fallbackHeaderName) {
        return mail -> {
            try {
                return HeaderExtractor.toAddressContents((String[])addressGetter.apply(mail));
            }
            catch (Exception e) {
                LOGGER.info("Failed parsing header. Falling back to unparsed header value matching", (Throwable)e);
                return Stream.of(mail.getMessage().getHeader(fallbackHeaderName)).map(MimeUtil::unscrambleHeaderValue);
            }
        };
    }

    public static Stream<String> toAddressContents(String[] headers) {
        return StreamUtils.ofNullable((Object[])headers).map(Throwing.function(string2 -> InternetAddress.parseHeader((String)string2, (boolean)false))).flatMap(AddressHelper::asStringStream);
    }

    public static Optional<HeaderExtractor> asHeaderExtractor(Rule.Condition.Field field) {
        return Optional.ofNullable(HEADER_EXTRACTOR_REGISTRY.get(field)).or(() -> {
            Preconditions.checkArgument((boolean)(field instanceof Rule.Condition.CustomHeaderField));
            Rule.Condition.CustomHeaderField customHeaderField = (Rule.Condition.CustomHeaderField)field;
            return Optional.of(mail -> StreamUtils.ofNullables((Object[])mail.getMessage().getHeader(customHeaderField.headerName())));
        });
    }
}

