/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.base;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import io.vavr.API;
import io.vavr.Predicates;
import jakarta.mail.Flags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.james.events.Event;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventListener;
import org.apache.james.events.Registration;
import org.apache.james.events.RegistrationKey;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.processor.base.UidMsnConverter;
import org.apache.james.mailbox.FlagsBuilder;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.NullableMessageSequenceNumber;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.events.MailboxIdRegistrationKey;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class SelectedMailboxImpl
implements SelectedMailbox,
EventListener.ReactiveEventListener {
    private static final Void VOID = null;
    private static final Flags.Flag UNINTERESTING_FLAGS = Flags.Flag.RECENT;
    private final AtomicReference<Registration> registration = new AtomicReference();
    private final MailboxManager mailboxManager;
    private final MessageManager messageManager;
    private final MailboxId mailboxId;
    private final EventBus eventBus;
    private final MailboxSession mailboxSession;
    private final UidMsnConverter uidMsnConverter;
    private final Set<MessageUid> recentUids = new TreeSet<MessageUid>();
    private final Set<MessageUid> flagUpdateUids = new TreeSet<MessageUid>();
    private final Set<MessageUid> expungedUids = new TreeSet<MessageUid>();
    private final StampedLock applicableFlagsLock = new StampedLock();
    private final AtomicReference<EventListener.ReactiveEventListener> idleEventListener = new AtomicReference();
    private final AtomicBoolean recentUidRemoved = new AtomicBoolean(false);
    private final AtomicBoolean isDeletedByOtherSession = new AtomicBoolean(false);
    private final AtomicBoolean sizeChanged = new AtomicBoolean(false);
    private final AtomicBoolean silentFlagChanges = new AtomicBoolean(false);
    private ApplicableFlags applicableFlags = ApplicableFlags.from(new Flags());

    public SelectedMailboxImpl(MailboxManager mailboxManager, EventBus eventBus, MailboxSession session, MessageManager messageManager) {
        this.eventBus = eventBus;
        this.mailboxManager = mailboxManager;
        this.messageManager = messageManager;
        this.mailboxSession = session;
        this.uidMsnConverter = new UidMsnConverter();
        this.mailboxId = messageManager.getId();
    }

    public Mono<Void> finishInit() throws MailboxException {
        this.setSilentFlagChanges(true);
        return Mono.from((Publisher)this.eventBus.register((EventListener.ReactiveEventListener)this, (RegistrationKey)new MailboxIdRegistrationKey(this.mailboxId))).doOnNext(this.registration::set).then(this.messageManager.getApplicableFlagsReactive(this.mailboxSession).doOnNext(flags -> {
            long stamp = this.applicableFlagsLock.writeLock();
            this.applicableFlags = this.applicableFlags.updateWithNewFlags((Flags)flags);
            this.applicableFlagsLock.unlockWrite(stamp);
        })).then(Flux.from((Publisher)this.messageManager.search(SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.all()}), this.mailboxSession)).collect(ImmutableList.toImmutableList()).doOnNext(this.uidMsnConverter::addAll)).then();
    }

    @Override
    public void registerIdle(EventListener.ReactiveEventListener idle) {
        this.idleEventListener.set(idle);
    }

    @Override
    public void unregisterIdle() {
        this.idleEventListener.set(null);
    }

    @Override
    public boolean isIdling() {
        return this.idleEventListener.get() != null;
    }

    @Override
    public Optional<MessageUid> getFirstUid() {
        return this.uidMsnConverter.getFirstUid();
    }

    @Override
    public Optional<MessageUid> getLastUid() {
        return this.uidMsnConverter.getLastUid();
    }

    @Override
    public List<MessageUid> allUids() {
        return this.uidMsnConverter.allUids();
    }

    @Override
    public Mono<Void> deselect() {
        return Mono.from((Publisher)Optional.ofNullable(this.registration.get()).map(Registration::unregister).orElse((Publisher)Mono.empty())).then(Mono.fromRunnable(this::clearInternalStructures).subscribeOn(Schedulers.boundedElastic())).then();
    }

    private synchronized void clearInternalStructures() {
        this.uidMsnConverter.clear();
        this.flagUpdateUids.clear();
        this.expungedUids.clear();
        this.recentUids.clear();
    }

    @Override
    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    @Override
    public synchronized boolean removeRecent(MessageUid uid) {
        boolean result = this.recentUids.remove(uid);
        if (result) {
            this.recentUidRemoved.set(true);
        }
        return result;
    }

    @Override
    public synchronized boolean addRecent(MessageUid uid) {
        return this.recentUids.add(uid);
    }

    @Override
    public synchronized Collection<MessageUid> getRecent() {
        this.checkExpungedRecents();
        return new ArrayList<MessageUid>(this.recentUids);
    }

    @Override
    public synchronized int recentCount() {
        this.checkExpungedRecents();
        return this.recentUids.size();
    }

    @Override
    public Mono<MailboxPath> getPathReactive() {
        return Mono.from((Publisher)this.mailboxManager.getMailboxReactive(this.mailboxId, this.mailboxSession)).map((Function)Throwing.function(MessageManager::getMailboxPath));
    }

    @Override
    public MailboxId getMailboxId() {
        return this.mailboxId;
    }

    private void checkExpungedRecents() {
        for (MessageUid uid : this.expungedUids) {
            this.removeRecent(uid);
        }
    }

    @Override
    public synchronized boolean isRecent(MessageUid uid) {
        return this.recentUids.contains(uid);
    }

    @Override
    public boolean isRecentUidRemoved() {
        return this.recentUidRemoved.get();
    }

    @Override
    public void resetRecentUidRemoved() {
        this.recentUidRemoved.set(false);
    }

    @Override
    public synchronized void resetEvents() {
        this.sizeChanged.set(false);
        this.flagUpdateUids.clear();
        this.isDeletedByOtherSession.set(false);
        long stamp = this.applicableFlagsLock.writeLock();
        this.applicableFlags = this.applicableFlags.ackUpdates();
        this.applicableFlagsLock.unlockWrite(stamp);
    }

    @Override
    public NullableMessageSequenceNumber remove(MessageUid uid) {
        return this.uidMsnConverter.getAndRemove(uid);
    }

    private boolean interestingFlags(UpdatedFlags updated) {
        Flags.Flag flag;
        Iterator it = updated.modifiedSystemFlags().iterator();
        boolean result = it.hasNext() ? !(flag = (Flags.Flag)it.next()).equals(UNINTERESTING_FLAGS) : false;
        if (!result) {
            Iterator userIt = updated.userFlagIterator();
            result = userIt.hasNext();
        }
        return result;
    }

    @Override
    public synchronized void resetExpungedUids() {
        this.expungedUids.clear();
    }

    public final void setSilentFlagChanges(boolean silentFlagChanges) {
        this.silentFlagChanges.set(silentFlagChanges);
    }

    @Override
    public final boolean isSizeChanged() {
        return this.sizeChanged.get();
    }

    @Override
    public final boolean isDeletedByOtherSession() {
        return this.isDeletedByOtherSession.get();
    }

    @Override
    public synchronized Collection<MessageUid> flagUpdateUids() {
        return ImmutableSortedSet.copyOf(this.flagUpdateUids);
    }

    @Override
    public synchronized Collection<MessageUid> expungedUids() {
        return ImmutableSortedSet.copyOf(this.expungedUids);
    }

    @Override
    public Flags getApplicableFlags() {
        return this.applicableFlags.flags();
    }

    @Override
    public boolean hasNewApplicableFlags() {
        return this.applicableFlags.updated();
    }

    @Override
    public void resetNewApplicableFlags() {
        long stamp = this.applicableFlagsLock.writeLock();
        this.applicableFlags = this.applicableFlags.ackUpdates();
        this.applicableFlagsLock.unlockWrite(stamp);
    }

    public Publisher<Void> reactiveEvent(Event event) {
        return Mono.fromRunnable(() -> this.synchronizedEvent(event)).subscribeOn(Schedulers.boundedElastic()).then(Mono.fromCallable(this.idleEventListener::get).flatMap(listener -> Mono.from((Publisher)listener.reactiveEvent(event))));
    }

    private synchronized void synchronizedEvent(Event event) {
        if (event instanceof MailboxEvents.MailboxEvent) {
            MailboxEvents.MailboxEvent mailboxEvent = (MailboxEvents.MailboxEvent)event;
            this.mailboxEvent(mailboxEvent);
        }
    }

    private void mailboxEvent(MailboxEvents.MailboxEvent mailboxEvent) {
        if (mailboxEvent.getMailboxId().equals((Object)this.getMailboxId())) {
            API.Match((Object)mailboxEvent).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(MailboxEvents.Added.class)), this::handleAddition), API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(MailboxEvents.FlagsUpdated.class)), this::handleFlagsUpdates), API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(MailboxEvents.Expunged.class)), this::handleMailboxExpunge), API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(MailboxEvents.MailboxDeletion.class)), this::handleMailboxDeletion), API.Case((API.Match.Pattern0)API.$(), (Object)VOID)});
        }
    }

    private Void handleMailboxDeletion(MailboxEvents.MailboxDeletion mailboxDeletion) {
        if (this.isFromOtherSession((MailboxEvents.MailboxEvent)mailboxDeletion)) {
            this.isDeletedByOtherSession.set(true);
        }
        return VOID;
    }

    private boolean isFromOtherSession(MailboxEvents.MailboxEvent mailboxDeletion) {
        return mailboxDeletion.getSessionId() != this.mailboxSession.getSessionId();
    }

    private Void handleMailboxExpunge(MailboxEvents.MessageEvent messageEvent) {
        this.expungedUids.addAll(messageEvent.getUids());
        return VOID;
    }

    private Void handleFlagsUpdates(MailboxEvents.FlagsUpdated updated) {
        List uFlags = updated.getUpdatedFlags();
        if (this.isFromOtherSession((MailboxEvents.MailboxEvent)updated) || !this.silentFlagChanges.get()) {
            for (UpdatedFlags u : uFlags) {
                if (!this.interestingFlags(u)) continue;
                this.flagUpdateUids.add(u.getUid());
            }
        }
        List uflags = updated.getUpdatedFlags();
        for (UpdatedFlags u : uflags) {
            if (!u.modifiedSystemFlags().contains(Flags.Flag.RECENT)) continue;
            this.recentUids.add(u.getUid());
        }
        long stamp = this.applicableFlagsLock.writeLock();
        this.applicableFlags = SelectedMailboxImpl.updateApplicableFlags(this.applicableFlags, updated);
        this.applicableFlagsLock.unlock(stamp);
        return VOID;
    }

    private Void handleAddition(MailboxEvents.Added added) {
        this.sizeChanged.set(true);
        this.uidMsnConverter.addAll(added.getUids());
        this.recentUids.addAll(added.getUids());
        return VOID;
    }

    @VisibleForTesting
    static ApplicableFlags updateApplicableFlags(ApplicableFlags applicableFlags, MailboxEvents.FlagsUpdated flagsUpdated) {
        Flags updatedFlags = SelectedMailboxImpl.mergeAllNewFlags(flagsUpdated);
        return applicableFlags.updateWithNewFlags(updatedFlags);
    }

    private static Flags mergeAllNewFlags(MailboxEvents.FlagsUpdated flagsUpdated) {
        List flags = flagsUpdated.getUpdatedFlags();
        FlagsBuilder builder = FlagsBuilder.builder();
        flags.stream().map(UpdatedFlags::getNewFlags).forEach(xva$0 -> builder.add(new Flags[]{xva$0}));
        return builder.build();
    }

    @Override
    public NullableMessageSequenceNumber msn(MessageUid uid) {
        return this.uidMsnConverter.getMsn(uid);
    }

    @Override
    public Optional<MessageUid> uid(int msn) {
        if (msn == -1) {
            return Optional.empty();
        }
        return this.uidMsnConverter.getUid(msn);
    }

    @Override
    public long existsCount() {
        return this.uidMsnConverter.getNumMessage();
    }

    @VisibleForTesting
    static class ApplicableFlags {
        private final Flags flags;
        private final boolean updated;

        static ApplicableFlags from(Flags flags) {
            boolean updated = false;
            return new ApplicableFlags(flags, updated);
        }

        private ApplicableFlags(Flags flags, boolean updated) {
            this.flags = flags;
            this.updated = updated;
        }

        public ApplicableFlags ackUpdates() {
            return new ApplicableFlags(this.flags, false);
        }

        public Flags flags() {
            return new Flags(this.flags);
        }

        public boolean updated() {
            return this.updated;
        }

        public ApplicableFlags updateWithNewFlags(Flags newFlags) {
            Flags updatedFlags = this.flags();
            int size = updatedFlags.getUserFlags().length;
            updatedFlags.add(newFlags);
            updatedFlags.remove(Flags.Flag.RECENT);
            boolean applicableFlagsChanged = size < updatedFlags.getUserFlags().length;
            return new ApplicableFlags(updatedFlags, applicableFlagsChanged);
        }
    }
}

