/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.http;

import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.james.core.Username;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.AuthenticationChallenge;
import org.apache.james.jmap.http.AuthenticationScheme;
import org.apache.james.jmap.http.AuthenticationStrategy;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.http.UserCredential$;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.util.ReactorUtils;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.netty.http.server.HttpServerRequest;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001db\u0001\u0002\u0006\f\u0001YA\u0001b\t\u0001\u0003\u0006\u0004%\t\u0001\n\u0005\t[\u0001\u0011\t\u0011)A\u0005K!Aa\u0006\u0001BC\u0002\u0013\u0005q\u0006\u0003\u00057\u0001\t\u0005\t\u0015!\u00031\u0011\u00159\u0004\u0001\"\u00019\u0011\u0015)\u0005\u0001\"\u0011G\u0011\u0015y\u0006\u0001\"\u0011a\u0011\u0015!\u0007\u0001\"\u0003f\u0011\u001d\t\u0019\u0001\u0001C\u0005\u0003\u000b\u00111DQ1tS\u000e\fU\u000f\u001e5f]RL7-\u0019;j_:\u001cFO]1uK\u001eL(B\u0001\u0007\u000e\u0003\u0011AG\u000f\u001e9\u000b\u00059y\u0011\u0001\u00026nCBT!\u0001E\t\u0002\u000b)\fW.Z:\u000b\u0005I\u0019\u0012AB1qC\u000eDWMC\u0001\u0015\u0003\ry'oZ\u0002\u0001'\r\u0001qc\b\t\u00031ui\u0011!\u0007\u0006\u00035m\tA\u0001\\1oO*\tA$\u0001\u0003kCZ\f\u0017B\u0001\u0010\u001a\u0005\u0019y%M[3diB\u0011\u0001%I\u0007\u0002\u0017%\u0011!e\u0003\u0002\u0017\u0003V$\b.\u001a8uS\u000e\fG/[8o'R\u0014\u0018\r^3hs\u0006yQo]3sgJ+\u0007o\\:ji>\u0014\u00180F\u0001&!\t13&D\u0001(\u0015\tA\u0013&A\u0002ba&T!AK\b\u0002\tU\u001cXM]\u0005\u0003Y\u001d\u0012q\"V:feN\u0014V\r]8tSR|'/_\u0001\u0011kN,'o\u001d*fa>\u001c\u0018\u000e^8ss\u0002\na\"\\1jY\n|\u00070T1oC\u001e,'/F\u00011!\t\tD'D\u00013\u0015\t\u0019t\"A\u0004nC&d'm\u001c=\n\u0005U\u0012$AD'bS2\u0014w\u000e_'b]\u0006<WM]\u0001\u0010[\u0006LGNY8y\u001b\u0006t\u0017mZ3sA\u00051A(\u001b8jiz\"2!\u000f\u001e<!\t\u0001\u0003\u0001C\u0003$\u000b\u0001\u0007Q\u0005C\u0003/\u000b\u0001\u0007\u0001\u0007\u000b\u0002\u0006{A\u0011ahQ\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0007S:TWm\u0019;\u000b\u0003\t\u000bqA[1lCJ$\u0018-\u0003\u0002E\u007f\t1\u0011J\u001c6fGR\fAc\u0019:fCR,W*Y5mE>D8+Z:tS>tGCA$U!\rAu*U\u0007\u0002\u0013*\u0011!jS\u0001\naV\u0014G.[:iKJT!\u0001T'\u0002\t\r|'/\u001a\u0006\u0002\u001d\u00069!/Z1di>\u0014\u0018B\u0001)J\u0005\u0011iuN\\8\u0011\u0005E\u0012\u0016BA*3\u00059i\u0015-\u001b7c_b\u001cVm]:j_:DQ!\u0016\u0004A\u0002Y\u000b1\u0002\u001b;uaJ+\u0017/^3tiB\u0011q+X\u0007\u00021*\u0011\u0011LW\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u00051Y&B\u0001/N\u0003\u0015qW\r\u001e;z\u0013\tq\u0006LA\tIiR\u00048+\u001a:wKJ\u0014V-];fgR\facY8se\u0016\u001c\bo\u001c8eS:<7\t[1mY\u0016tw-\u001a\u000b\u0002CB\u0011\u0001EY\u0005\u0003G.\u0011q#Q;uQ\u0016tG/[2bi&|gn\u00115bY2,gnZ3\u0002\u0017A,(\r\\5tQ:+\u0007\u0010^\u000b\u0003MJ,\u0012a\u001a\t\u0006Q.l7P`\u0007\u0002S*\t!.A\u0003tG\u0006d\u0017-\u0003\u0002mS\nIa)\u001e8di&|gN\r\t\u0004Q:\u0004\u0018BA8j\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011O\u001d\u0007\u0001\t\u0015\u0019\bB1\u0001u\u0005\u0005!\u0016CA;y!\tAg/\u0003\u0002xS\n9aj\u001c;iS:<\u0007C\u00015z\u0013\tQ\u0018NA\u0002B]f\u00042\u0001\u0013?q\u0013\ti\u0018JA\bTs:\u001c\u0007N]8o_V\u001c8+\u001b8l!\tAw0C\u0002\u0002\u0002%\u0014A!\u00168ji\u0006Ar-\u001a;BkRDWM\u001c;jG\u0006$X\rZ+tKJt\u0017-\\3\u0015\t\u0005\u001d\u0011Q\u0004\t\u0007\u0003\u0013\ty!a\u0005\u000e\u0005\u0005-!b\u0001&\u0002\u000e)\u0011!nS\u0005\u0005\u0003#\tYAA\u0003T\u001b>tw\u000e\u0005\u0003\u0002\u0016\u0005eQBAA\f\u0015\tau\"\u0003\u0003\u0002\u001c\u0005]!\u0001C+tKJt\u0017-\\3\t\u000f\u0005}\u0011\u00021\u0001\u0002\"\u0005qQo]3s\u0007J,G-\u001a8uS\u0006d\u0007c\u0001\u0011\u0002$%\u0019\u0011QE\u0006\u0003\u001dU\u001bXM]\"sK\u0012,g\u000e^5bY\u0002")
public class BasicAuthenticationStrategy
implements AuthenticationStrategy {
    private final UsersRepository usersRepository;
    private final MailboxManager mailboxManager;

    public String authHeaders(HttpServerRequest httpRequest) {
        return super.authHeaders(httpRequest);
    }

    public UsersRepository usersRepository() {
        return this.usersRepository;
    }

    public MailboxManager mailboxManager() {
        return this.mailboxManager;
    }

    public Mono<MailboxSession> createMailboxSession(HttpServerRequest httpRequest) {
        return SMono$.MODULE$.fromCallable(() -> this.authHeaders(httpRequest)).map((Function1 & Serializable)token -> UserCredential$.MODULE$.parseUserCredentials((String)token)).handle(this.publishNext()).flatMap((Function1 & Serializable)userCredential -> this.getAuthenticatedUsername((UserCredential)userCredential)).map((Function1 & Serializable)loggedInUser -> this.mailboxManager().authenticate(loggedInUser).withoutDelegation()).asJava();
    }

    public AuthenticationChallenge correspondingChallenge() {
        return AuthenticationChallenge.of((AuthenticationScheme)AuthenticationScheme.of((String)"Basic"), (java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"realm"), (Object)"simple")}))).asJava());
    }

    private <T> Function2<Option<T>, SynchronousSink<T>, BoxedUnit> publishNext() {
        return (Function2 & Serializable)(maybeT, sink) -> {
            maybeT.foreach((Function1 & Serializable)t -> {
                sink.next(t);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        };
    }

    private SMono<Username> getAuthenticatedUsername(UserCredential userCredential) {
        return SMono$.MODULE$.fromCallable(() -> (Username)this.usersRepository().test(userCredential.username(), userCredential.password()).orElseThrow(() -> new UnauthorizedException("Wrong credentials provided"))).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER);
    }

    @Inject
    public BasicAuthenticationStrategy(UsersRepository usersRepository, MailboxManager mailboxManager) {
        this.usersRepository = usersRepository;
        this.mailboxManager = mailboxManager;
    }
}

