/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import jakarta.mail.Flags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.ThreadId;

public class SearchQuery {
    private static final String DATE_HEADER_NAME = "Date";
    public static final ImmutableList<Sort> DEFAULT_SORTS = ImmutableList.of(new Sort(Sort.SortClause.Uid, Sort.Order.NATURAL));
    private final ImmutableList<Criterion> criteria;
    private final ImmutableList<Sort> sorts;
    private final ImmutableSet<MessageUid> recentMessageUids;

    public static Criterion sizeLessThan(long value) {
        return new SizeCriterion(new NumericOperator(value, NumericComparator.LESS_THAN));
    }

    public static Criterion sizeGreaterThan(long value) {
        return new SizeCriterion(new NumericOperator(value, NumericComparator.GREATER_THAN));
    }

    public static Criterion sizeEquals(long value) {
        return new SizeCriterion(new NumericOperator(value, NumericComparator.EQUALS));
    }

    public static Criterion modSeqLessThan(long value) {
        return new ModSeqCriterion(new NumericOperator(value, NumericComparator.LESS_THAN));
    }

    public static Criterion modSeqGreaterThan(long value) {
        return new ModSeqCriterion(new NumericOperator(value, NumericComparator.GREATER_THAN));
    }

    public static Criterion modSeqEquals(long value) {
        return new ModSeqCriterion(new NumericOperator(value, NumericComparator.EQUALS));
    }

    public static Criterion hasMessageId(MessageId messageId) {
        return new MessageIdCriterion(messageId);
    }

    public static Criterion internalDateAfter(Date date, DateResolution dateResolution) {
        return new InternalDateCriterion(new DateOperator(DateComparator.AFTER, date, dateResolution));
    }

    public static Criterion internalDateOn(Date date, DateResolution dateResolution) {
        return new InternalDateCriterion(new DateOperator(DateComparator.ON, date, dateResolution));
    }

    public static Criterion internalDateBefore(Date date, DateResolution dateResolution) {
        return new InternalDateCriterion(new DateOperator(DateComparator.BEFORE, date, dateResolution));
    }

    public static Criterion saveDateAfter(Date date, DateResolution dateResolution) {
        return new SaveDateCriterion(new DateOperator(DateComparator.AFTER, date, dateResolution));
    }

    public static Criterion saveDateOn(Date date, DateResolution dateResolution) {
        return new SaveDateCriterion(new DateOperator(DateComparator.ON, date, dateResolution));
    }

    public static Criterion saveDateBefore(Date date, DateResolution dateResolution) {
        return new SaveDateCriterion(new DateOperator(DateComparator.BEFORE, date, dateResolution));
    }

    public static Criterion saveDateSupported() {
        return AllCriterion.all();
    }

    public static Criterion sentDateAfter(Date date, DateResolution dateResolution) {
        return SearchQuery.headerDateAfter(DATE_HEADER_NAME, date, dateResolution);
    }

    public static Criterion sentDateOn(Date date, DateResolution dateResolution) {
        return SearchQuery.headerDateOn(DATE_HEADER_NAME, date, dateResolution);
    }

    public static Criterion sentDateBefore(Date date, DateResolution dateResolution) {
        return SearchQuery.headerDateBefore(DATE_HEADER_NAME, date, dateResolution);
    }

    public static Criterion headerDateAfter(String headerName, Date date, DateResolution dateResolution) {
        return new HeaderCriterion(headerName, new DateOperator(DateComparator.AFTER, date, dateResolution));
    }

    public static Criterion headerDateOn(String headerName, Date date, DateResolution dateResolution) {
        return new HeaderCriterion(headerName, new DateOperator(DateComparator.ON, date, dateResolution));
    }

    public static Criterion headerDateBefore(String headerName, Date date, DateResolution dateResolution) {
        return new HeaderCriterion(headerName, new DateOperator(DateComparator.BEFORE, date, dateResolution));
    }

    public static Criterion address(AddressType type, String address) {
        return new HeaderCriterion(type.name(), new AddressOperator(address));
    }

    public static Criterion headerContains(String headerName, String value) {
        if (value == null || value.length() == 0) {
            return SearchQuery.headerExists(headerName);
        }
        return new HeaderCriterion(headerName, new ContainsOperator(value));
    }

    public static Criterion headerExists(String headerName) {
        return new HeaderCriterion(headerName, ExistsOperator.exists());
    }

    public static Criterion mailContains(String value) {
        return new TextCriterion(value, Scope.FULL);
    }

    public static Criterion bodyContains(String value) {
        return new TextCriterion(value, Scope.BODY);
    }

    public static Criterion attachmentContains(String value) {
        return new TextCriterion(value, Scope.ATTACHMENTS);
    }

    public static Criterion uid(UidRange ... range) {
        return new UidCriterion(range);
    }

    public static Criterion or(Criterion one, Criterion two) {
        ArrayList<Criterion> criteria = new ArrayList<Criterion>();
        criteria.add(one);
        criteria.add(two);
        return new ConjunctionCriterion(Conjunction.OR, criteria);
    }

    public static Criterion or(List<Criterion> criteria) {
        return new ConjunctionCriterion(Conjunction.OR, criteria);
    }

    public static Criterion and(Criterion one, Criterion two) {
        ArrayList<Criterion> criteria = new ArrayList<Criterion>();
        criteria.add(one);
        criteria.add(two);
        return new ConjunctionCriterion(Conjunction.AND, criteria);
    }

    public static Criterion and(List<Criterion> criteria) {
        return new ConjunctionCriterion(Conjunction.AND, criteria);
    }

    public static Criterion not(Criterion criterion) {
        ArrayList<Criterion> criteria = new ArrayList<Criterion>();
        criteria.add(criterion);
        return new ConjunctionCriterion(Conjunction.NOR, criteria);
    }

    public static Criterion not(List<Criterion> criteria) {
        return new ConjunctionCriterion(Conjunction.NOR, criteria);
    }

    public static Criterion flagSet(Flags.Flag flag, boolean isSet) {
        Criterion result = isSet ? SearchQuery.flagIsSet(flag) : SearchQuery.flagIsUnSet(flag);
        return result;
    }

    public static Criterion hasAttachment(boolean value) {
        if (value) {
            return new AttachmentCriterion(BooleanOperator.set());
        }
        return new AttachmentCriterion(BooleanOperator.unset());
    }

    public static Criterion attachmentFileName(String fileName) {
        return new TextCriterion(fileName, Scope.ATTACHMENT_FILE_NAME);
    }

    public static Criterion hasAttachment() {
        return SearchQuery.hasAttachment(true);
    }

    public static Criterion hasNoAttachment() {
        return SearchQuery.hasAttachment(false);
    }

    public static Criterion flagIsSet(Flags.Flag flag) {
        return new FlagCriterion(flag, BooleanOperator.set());
    }

    public static Criterion flagIsUnSet(Flags.Flag flag) {
        return new FlagCriterion(flag, BooleanOperator.unset());
    }

    public static Criterion flag(Flags.Flag flag, boolean isSet) {
        return new FlagCriterion(flag, new BooleanOperator(isSet));
    }

    public static Criterion flagSet(String flag, boolean isSet) {
        Criterion result = isSet ? SearchQuery.flagIsSet(flag) : SearchQuery.flagIsUnSet(flag);
        return result;
    }

    public static Criterion flagIsSet(String flag) {
        return new CustomFlagCriterion(flag, BooleanOperator.set());
    }

    public static Criterion flagIsUnSet(String flag) {
        return new CustomFlagCriterion(flag, BooleanOperator.unset());
    }

    public static Criterion all() {
        return AllCriterion.all();
    }

    public static Criterion mimeMessageID(String messageId) {
        return new MimeMessageIDCriterion(messageId);
    }

    public static Criterion subject(String subject) {
        return new SubjectCriterion(subject);
    }

    public static Criterion threadId(ThreadId threadId) {
        return new ThreadIdCriterion(threadId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SearchQuery of(Criterion ... criterias) {
        return new Builder().andCriteria(criterias).build();
    }

    public static SearchQuery matchAll() {
        return new Builder().build();
    }

    public static SearchQuery allSortedWith(Sort ... sorts) {
        return new Builder().sorts(sorts).build();
    }

    private SearchQuery(ImmutableList<Criterion> criteria, ImmutableList<Sort> sorts, ImmutableSet<MessageUid> recentMessageUids) {
        this.criteria = criteria;
        this.sorts = sorts;
        this.recentMessageUids = recentMessageUids;
    }

    public List<Criterion> getCriteria() {
        return this.criteria;
    }

    public List<Sort> getSorts() {
        return this.sorts;
    }

    public Set<MessageUid> getRecentMessageUids() {
        return this.recentMessageUids;
    }

    public String toString() {
        return "Search:" + this.criteria.toString();
    }

    public final int hashCode() {
        return com.google.common.base.Objects.hashCode(this.criteria, this.sorts, this.recentMessageUids);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof SearchQuery) {
            SearchQuery that = (SearchQuery)obj;
            return com.google.common.base.Objects.equal(this.criteria, that.criteria) && com.google.common.base.Objects.equal(this.sorts, that.sorts) && com.google.common.base.Objects.equal(this.recentMessageUids, that.recentMessageUids);
        }
        return false;
    }

    public static class SizeCriterion
    extends Criterion {
        private final NumericOperator operator;

        private SizeCriterion(NumericOperator operator) {
            this.operator = operator;
        }

        public NumericOperator getOperator() {
            return this.operator;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode(this.operator);
        }

        public boolean equals(Object obj) {
            if (obj instanceof SizeCriterion) {
                SizeCriterion that = (SizeCriterion)obj;
                return com.google.common.base.Objects.equal(this.operator, that.operator);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("operator", this.operator).toString();
        }
    }

    public static class NumericOperator
    implements Operator {
        private final long value;
        private final NumericComparator type;

        private NumericOperator(long value, NumericComparator type) {
            this.value = value;
            this.type = type;
        }

        public NumericComparator getType() {
            return this.type;
        }

        public long getValue() {
            return this.value;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode(new Object[]{this.value, this.type});
        }

        public boolean equals(Object obj) {
            if (obj instanceof NumericOperator) {
                NumericOperator that = (NumericOperator)obj;
                return com.google.common.base.Objects.equal(this.value, that.value) && com.google.common.base.Objects.equal((Object)this.type, (Object)that.type);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("value", this.value).add("type", (Object)this.type).toString();
        }
    }

    public static enum NumericComparator {
        EQUALS,
        LESS_THAN,
        GREATER_THAN;

    }

    public static class ModSeqCriterion
    extends Criterion {
        private final NumericOperator operator;

        private ModSeqCriterion(NumericOperator operator) {
            this.operator = operator;
        }

        public NumericOperator getOperator() {
            return this.operator;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode(this.operator);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ModSeqCriterion) {
                ModSeqCriterion that = (ModSeqCriterion)obj;
                return com.google.common.base.Objects.equal(this.operator, that.operator);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("operator", this.operator).toString();
        }
    }

    public static class MessageIdCriterion
    extends Criterion {
        private final MessageId messageId;

        public MessageIdCriterion(MessageId messageId) {
            this.messageId = messageId;
        }

        public MessageId getMessageId() {
            return this.messageId;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode(this.messageId);
        }

        public boolean equals(Object obj) {
            if (obj instanceof MessageIdCriterion) {
                MessageIdCriterion that = (MessageIdCriterion)obj;
                return com.google.common.base.Objects.equal(this.messageId, that.messageId);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("messageId", this.messageId).toString();
        }
    }

    public static class InternalDateCriterion
    extends Criterion {
        private final DateOperator operator;

        public InternalDateCriterion(DateOperator operator) {
            this.operator = operator;
        }

        public DateOperator getOperator() {
            return this.operator;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode(this.operator);
        }

        public boolean equals(Object obj) {
            if (obj instanceof InternalDateCriterion) {
                InternalDateCriterion that = (InternalDateCriterion)obj;
                return com.google.common.base.Objects.equal(this.operator, that.operator);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("operator", this.operator).toString();
        }
    }

    public static class DateOperator
    implements HeaderOperator {
        public static final int BEFORE = 1;
        public static final int AFTER = 2;
        public static final int ON = 3;
        private final DateComparator type;
        private final Date date;
        private final DateResolution dateResolution;

        public DateOperator(DateComparator type, Date date, DateResolution dateResolution) {
            Preconditions.checkNotNull(date);
            Preconditions.checkNotNull(dateResolution);
            this.type = type;
            this.date = date;
            this.dateResolution = dateResolution;
        }

        public Date getDate() {
            return this.date;
        }

        public DateResolution getDateResultion() {
            return this.dateResolution;
        }

        public DateComparator getType() {
            return this.type;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode(new Object[]{this.dateResolution, this.type});
        }

        public boolean equals(Object obj) {
            if (obj instanceof DateOperator) {
                DateOperator that = (DateOperator)obj;
                return com.google.common.base.Objects.equal((Object)this.dateResolution, (Object)that.dateResolution) && com.google.common.base.Objects.equal((Object)this.type, (Object)that.type);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("date", this.date).add("dateResolution", (Object)this.dateResolution).add("type", (Object)this.type).toString();
        }
    }

    public static enum DateComparator {
        BEFORE,
        AFTER,
        ON;

    }

    public static enum DateResolution {
        Second,
        Minute,
        Hour,
        Day,
        Month,
        Year;

    }

    public static class SaveDateCriterion
    extends Criterion {
        private final DateOperator operator;

        public SaveDateCriterion(DateOperator operator) {
            this.operator = operator;
        }

        public DateOperator getOperator() {
            return this.operator;
        }

        public final int hashCode() {
            return com.google.common.base.Objects.hashCode(this.operator);
        }

        public final boolean equals(Object obj) {
            if (obj instanceof SaveDateCriterion) {
                SaveDateCriterion that = (SaveDateCriterion)obj;
                return com.google.common.base.Objects.equal(this.operator, that.operator);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("operator", this.operator).toString();
        }
    }

    public static class AllCriterion
    extends Criterion {
        private static final AllCriterion ALL = new AllCriterion();

        private static Criterion all() {
            return ALL;
        }

        public boolean equals(Object obj) {
            return obj instanceof AllCriterion;
        }

        public int hashCode() {
            return 1729;
        }

        public String toString() {
            return "AllCriterion";
        }
    }

    public static abstract class Criterion {
    }

    public static class HeaderCriterion
    extends Criterion {
        private final HeaderOperator operator;
        private final String headerName;

        private HeaderCriterion(String headerName, HeaderOperator operator) {
            this.operator = operator;
            this.headerName = headerName;
        }

        public String getHeaderName() {
            return this.headerName;
        }

        public HeaderOperator getOperator() {
            return this.operator;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode(this.headerName, this.operator);
        }

        public boolean equals(Object obj) {
            if (obj instanceof HeaderCriterion) {
                HeaderCriterion that = (HeaderCriterion)obj;
                return com.google.common.base.Objects.equal(this.operator, that.operator) && com.google.common.base.Objects.equal(this.headerName, that.headerName);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("operator", this.operator).add("headerName", this.headerName).toString();
        }
    }

    public static interface HeaderOperator
    extends Operator {
    }

    public static enum AddressType {
        From,
        To,
        Cc,
        Bcc;

    }

    public static class AddressOperator
    implements HeaderOperator {
        private final String address;

        public AddressOperator(String address) {
            this.address = address;
        }

        public String getAddress() {
            return this.address;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode(this.address);
        }

        public boolean equals(Object obj) {
            if (obj instanceof AddressOperator) {
                AddressOperator that = (AddressOperator)obj;
                return com.google.common.base.Objects.equal(this.address, that.address);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("address", this.address).toString();
        }
    }

    public static class ContainsOperator
    implements HeaderOperator {
        private final String value;

        public ContainsOperator(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode(this.value);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ContainsOperator) {
                ContainsOperator that = (ContainsOperator)obj;
                return com.google.common.base.Objects.equal(this.value, that.value);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("value", this.value).toString();
        }
    }

    public static class ExistsOperator
    implements HeaderOperator {
        private static final ExistsOperator EXISTS = new ExistsOperator();

        public static ExistsOperator exists() {
            return EXISTS;
        }

        public boolean equals(Object obj) {
            return obj instanceof ExistsOperator;
        }

        public int hashCode() {
            return 42;
        }

        public String toString() {
            return "ExistsCriterion";
        }
    }

    public static class TextCriterion
    extends Criterion {
        private final Scope type;
        private final ContainsOperator operator;

        private TextCriterion(String value, Scope type) {
            this.operator = new ContainsOperator(value);
            this.type = type;
        }

        public Scope getType() {
            return this.type;
        }

        public ContainsOperator getOperator() {
            return this.operator;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode(this.operator);
        }

        public boolean equals(Object obj) {
            if (obj instanceof TextCriterion) {
                TextCriterion that = (TextCriterion)obj;
                return com.google.common.base.Objects.equal(this.operator, that.operator);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("operator", this.operator).toString();
        }
    }

    public static enum Scope {
        BODY,
        FULL,
        ATTACHMENTS,
        ATTACHMENT_FILE_NAME;

    }

    public static class UidCriterion
    extends Criterion {
        private final UidInOperator operator;

        public UidCriterion(UidRange[] ranges) {
            this.operator = new UidInOperator(ranges);
        }

        public UidInOperator getOperator() {
            return this.operator;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode(this.operator);
        }

        public boolean equals(Object obj) {
            if (obj instanceof UidCriterion) {
                UidCriterion that = (UidCriterion)obj;
                return com.google.common.base.Objects.equal(this.operator, that.operator);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("operator", this.operator).toString();
        }
    }

    public static class UidRange {
        private final MessageUid lowValue;
        private final MessageUid highValue;

        public UidRange(MessageUid value) {
            this.lowValue = value;
            this.highValue = value;
        }

        public UidRange(MessageUid lowValue, MessageUid highValue) {
            this.lowValue = lowValue;
            this.highValue = highValue;
        }

        public MessageUid getHighValue() {
            return this.highValue;
        }

        public MessageUid getLowValue() {
            return this.lowValue;
        }

        public boolean isIn(MessageUid value) {
            return this.lowValue.compareTo(value) <= 0 && this.highValue.compareTo(value) >= 0;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode(this.lowValue, this.highValue);
        }

        public boolean equals(Object obj) {
            if (obj instanceof UidRange) {
                UidRange that = (UidRange)obj;
                return com.google.common.base.Objects.equal(this.lowValue, that.lowValue) && com.google.common.base.Objects.equal(this.highValue, that.highValue);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("lowValue", this.lowValue).add("highValue", this.highValue).toString();
        }
    }

    public static class ConjunctionCriterion
    extends Criterion {
        private final Conjunction type;
        private final List<Criterion> criteria;

        public ConjunctionCriterion(Conjunction type, List<Criterion> criteria) {
            this.type = type;
            this.criteria = criteria;
        }

        public List<Criterion> getCriteria() {
            return this.criteria;
        }

        public Conjunction getType() {
            return this.type;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode(this.criteria);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ConjunctionCriterion) {
                ConjunctionCriterion that = (ConjunctionCriterion)obj;
                return com.google.common.base.Objects.equal(this.criteria, that.criteria);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("criteria", this.criteria).add("type", (Object)this.type).toString();
        }
    }

    public static enum Conjunction {
        AND,
        OR,
        NOR;

    }

    public static class AttachmentCriterion
    extends Criterion {
        private final BooleanOperator operator;

        private AttachmentCriterion(BooleanOperator operator) {
            this.operator = operator;
        }

        public BooleanOperator getOperator() {
            return this.operator;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode(this.operator);
        }

        public boolean equals(Object obj) {
            if (obj instanceof AttachmentCriterion) {
                AttachmentCriterion that = (AttachmentCriterion)obj;
                return com.google.common.base.Objects.equal(this.operator, that.operator);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("operator", this.operator).toString();
        }
    }

    public static class BooleanOperator
    implements Operator {
        private static final BooleanOperator SET = new BooleanOperator(true);
        private static final BooleanOperator UNSET = new BooleanOperator(false);
        private final boolean set;

        public static BooleanOperator set() {
            return SET;
        }

        public static BooleanOperator unset() {
            return UNSET;
        }

        private BooleanOperator(boolean set) {
            this.set = set;
        }

        public boolean isSet() {
            return this.set;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode(this.set);
        }

        public boolean equals(Object obj) {
            if (obj instanceof BooleanOperator) {
                BooleanOperator that = (BooleanOperator)obj;
                return com.google.common.base.Objects.equal(this.set, that.set);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("set", this.set).toString();
        }
    }

    public static class FlagCriterion
    extends Criterion {
        private final Flags.Flag flag;
        private final BooleanOperator operator;

        private FlagCriterion(Flags.Flag flag, BooleanOperator operator) {
            this.flag = flag;
            this.operator = operator;
        }

        public Flags.Flag getFlag() {
            return this.flag;
        }

        public BooleanOperator getOperator() {
            return this.operator;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode(this.flag, this.operator);
        }

        public boolean equals(Object obj) {
            if (obj instanceof FlagCriterion) {
                FlagCriterion that = (FlagCriterion)obj;
                return com.google.common.base.Objects.equal(this.operator, that.operator) && com.google.common.base.Objects.equal(this.flag, that.flag);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("operator", this.operator).add("flag", this.flag).toString();
        }
    }

    public static class CustomFlagCriterion
    extends Criterion {
        private final String flag;
        private final BooleanOperator operator;

        private CustomFlagCriterion(String flag, BooleanOperator operator) {
            this.flag = flag;
            this.operator = operator;
        }

        public String getFlag() {
            return this.flag;
        }

        public BooleanOperator getOperator() {
            return this.operator;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode(this.flag, this.operator);
        }

        public boolean equals(Object obj) {
            if (obj instanceof CustomFlagCriterion) {
                CustomFlagCriterion that = (CustomFlagCriterion)obj;
                return com.google.common.base.Objects.equal(this.operator, that.operator) && com.google.common.base.Objects.equal(this.flag, that.flag);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("operator", this.operator).add("flag", this.flag).toString();
        }
    }

    public static class MimeMessageIDCriterion
    extends Criterion {
        private final String messageID;

        public MimeMessageIDCriterion(String messageID) {
            this.messageID = messageID;
        }

        public String getMessageID() {
            return this.messageID;
        }

        public HeaderCriterion asHeaderCriterion() {
            return new HeaderCriterion("Message-ID", new ContainsOperator(this.messageID));
        }

        public final boolean equals(Object o) {
            if (o instanceof MimeMessageIDCriterion) {
                MimeMessageIDCriterion that = (MimeMessageIDCriterion)o;
                return Objects.equals(this.messageID, that.messageID);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.messageID);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("messageID", this.messageID).toString();
        }
    }

    public static class SubjectCriterion
    extends Criterion {
        private final String subject;

        public SubjectCriterion(String subject) {
            this.subject = subject;
        }

        public String getSubject() {
            return this.subject;
        }

        public HeaderCriterion asHeaderCriterion() {
            return new HeaderCriterion("Subject", new ContainsOperator(this.subject));
        }

        public final boolean equals(Object o) {
            if (o instanceof SubjectCriterion) {
                SubjectCriterion that = (SubjectCriterion)o;
                return Objects.equals(this.subject, that.subject);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.subject);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("subject", this.subject).toString();
        }
    }

    public static class ThreadIdCriterion
    extends Criterion {
        private final ThreadId threadId;

        public ThreadIdCriterion(ThreadId threadId) {
            this.threadId = threadId;
        }

        public ThreadId getThreadId() {
            return this.threadId;
        }

        public final boolean equals(Object o) {
            if (o instanceof ThreadIdCriterion) {
                ThreadIdCriterion that = (ThreadIdCriterion)o;
                return com.google.common.base.Objects.equal(this.threadId, that.threadId);
            }
            return false;
        }

        public final int hashCode() {
            return com.google.common.base.Objects.hashCode(this.threadId);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("threadId", this.threadId).toString();
        }
    }

    public static class Builder {
        private final ImmutableList.Builder<Criterion> criterias = ImmutableList.builder();
        private final ImmutableSet.Builder<MessageUid> recentMessageUids;
        private Optional<ImmutableList<Sort>> sorts = Optional.empty();

        public Builder() {
            this.recentMessageUids = ImmutableSet.builder();
        }

        public Builder andCriteria(Criterion ... criteria) {
            return this.andCriteria(Arrays.asList(criteria));
        }

        public Builder andCriteria(Collection<Criterion> criteria) {
            this.criterias.addAll(criteria);
            return this;
        }

        public Builder andCriterion(Criterion criterion) {
            ConjunctionCriterion conjunctionCriterion;
            if (criterion instanceof ConjunctionCriterion && (conjunctionCriterion = (ConjunctionCriterion)criterion).getType() == Conjunction.AND) {
                this.criterias.addAll(conjunctionCriterion.getCriteria());
                return this;
            }
            this.criterias.add((Object)criterion);
            return this;
        }

        public Builder sorts(Sort ... sorts) {
            return this.sorts(Arrays.asList(sorts));
        }

        public Builder sorts(List<Sort> sorts) {
            if (sorts == null || sorts.isEmpty()) {
                throw new IllegalArgumentException("There must be at least one Sort");
            }
            this.sorts = Optional.of(ImmutableList.copyOf(sorts));
            return this;
        }

        public Builder addRecentMessageUids(Collection<MessageUid> uids) {
            this.recentMessageUids.addAll(uids);
            return this;
        }

        public SearchQuery build() {
            return new SearchQuery((ImmutableList<Criterion>)this.criterias.build(), this.sorts.orElse(DEFAULT_SORTS), (ImmutableSet<MessageUid>)this.recentMessageUids.build());
        }
    }

    public static class Sort {
        private final Order order;
        private final SortClause sortClause;

        public Sort(SortClause sortClause, Order order) {
            this.order = order;
            this.sortClause = sortClause;
        }

        public Sort(SortClause sortClause) {
            this(sortClause, Order.NATURAL);
        }

        public boolean isReverse() {
            return this.order == Order.REVERSE;
        }

        public SortClause getSortClause() {
            return this.sortClause;
        }

        public boolean equals(Object o) {
            if (o instanceof Sort) {
                Sort that = (Sort)o;
                return com.google.common.base.Objects.equal((Object)this.sortClause, (Object)that.sortClause) && com.google.common.base.Objects.equal((Object)this.order, (Object)that.order);
            }
            return false;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode(new Object[]{this.sortClause, this.order});
        }

        public static enum Order {
            REVERSE,
            NATURAL;

        }

        public static enum SortClause {
            Arrival,
            MailboxCc,
            MailboxFrom,
            MailboxTo,
            BaseSubject,
            Size,
            SentDate,
            Uid,
            Id;

        }
    }

    public static class UidInOperator
    implements Operator {
        private final UidRange[] ranges;

        public UidInOperator(UidRange[] ranges) {
            this.ranges = ranges;
        }

        public UidRange[] getRange() {
            return this.ranges;
        }

        public boolean isAll() {
            return this.ranges.length == 0 || this.ranges.length == 1 && this.ranges[0].getLowValue() == MessageUid.MIN_VALUE && this.ranges[0].getHighValue() == MessageUid.MAX_VALUE;
        }

        public int hashCode() {
            return Arrays.hashCode(this.ranges);
        }

        public boolean equals(Object obj) {
            if (obj instanceof UidInOperator) {
                UidInOperator other = (UidInOperator)obj;
                return Arrays.equals(this.ranges, other.ranges);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("ranges", Arrays.toString(this.ranges)).toString();
        }
    }

    public static interface Operator {
    }
}

