/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GetAuthorizationEntryResponseControl
extends Control
implements DecodeableControl {
    @NotNull
    public static final String GET_AUTHORIZATION_ENTRY_RESPONSE_OID = "1.3.6.1.4.1.30221.2.5.6";
    private static final byte TYPE_IS_AUTHENTICATED = -128;
    private static final byte TYPE_IDENTITIES_MATCH = -127;
    private static final byte TYPE_AUTHN_ENTRY = -94;
    private static final byte TYPE_AUTHZ_ENTRY = -93;
    private static final byte TYPE_AUTHID = -128;
    private static final byte TYPE_AUTHDN = -127;
    private static final byte TYPE_ATTRIBUTES = -94;
    @NotNull
    private static final String JSON_FIELD_AUTHENTICATION_ENTRY = "authentication-entry";
    @NotNull
    private static final String JSON_FIELD_AUTHENTICATION_ID = "authentication-id";
    @NotNull
    private static final String JSON_FIELD_AUTHORIZATION_ENTRY = "authorization-entry";
    @NotNull
    private static final String JSON_FIELD_AUTHORIZATION_ID = "authorization-id";
    @NotNull
    private static final String JSON_FIELD_ENTRY_DN = "_dn";
    @NotNull
    private static final String JSON_FIELD_IDENTITIES_MATCH = "identities-match";
    @NotNull
    private static final String JSON_FIELD_IS_AUTHENTICATED = "is-authenticated";
    private static final long serialVersionUID = -5443107150740697226L;
    private final boolean identitiesMatch;
    private final boolean isAuthenticated;
    @Nullable
    private final ReadOnlyEntry authNEntry;
    @Nullable
    private final ReadOnlyEntry authZEntry;
    @Nullable
    private final String authNID;
    @Nullable
    private final String authZID;

    GetAuthorizationEntryResponseControl() {
        this.isAuthenticated = false;
        this.identitiesMatch = true;
        this.authNEntry = null;
        this.authNID = null;
        this.authZEntry = null;
        this.authZID = null;
    }

    public GetAuthorizationEntryResponseControl(boolean isAuthenticated, boolean identitiesMatch, @Nullable String authNID, @Nullable ReadOnlyEntry authNEntry, @Nullable String authZID, @Nullable ReadOnlyEntry authZEntry) {
        super(GET_AUTHORIZATION_ENTRY_RESPONSE_OID, false, GetAuthorizationEntryResponseControl.encodeValue(isAuthenticated, identitiesMatch, authNID, authNEntry, authZID, authZEntry));
        this.isAuthenticated = isAuthenticated;
        this.identitiesMatch = identitiesMatch;
        this.authNID = authNID;
        this.authNEntry = authNEntry;
        this.authZID = authZID;
        this.authZEntry = authZEntry;
    }

    public GetAuthorizationEntryResponseControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_AUTHORIZATION_ENTRY_RESPONSE_NO_VALUE.get());
        }
        try {
            boolean isAuth = false;
            boolean idsMatch = false;
            String nID = null;
            String zID = null;
            ReadOnlyEntry nEntry = null;
            ReadOnlyEntry zEntry = null;
            ASN1Element valElement = ASN1Element.decode(value.getValue());
            block8: for (ASN1Element e : ASN1Sequence.decodeAsSequence(valElement).elements()) {
                switch (e.getType()) {
                    case -128: {
                        isAuth = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block8;
                    }
                    case -127: {
                        idsMatch = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block8;
                    }
                    case -94: {
                        Object[] nObjects = GetAuthorizationEntryResponseControl.decodeAuthEntry(e);
                        nID = (String)nObjects[0];
                        nEntry = (ReadOnlyEntry)nObjects[1];
                        continue block8;
                    }
                    case -93: {
                        Object[] zObjects = GetAuthorizationEntryResponseControl.decodeAuthEntry(e);
                        zID = (String)zObjects[0];
                        zEntry = (ReadOnlyEntry)zObjects[1];
                        continue block8;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_AUTHORIZATION_ENTRY_RESPONSE_INVALID_VALUE_TYPE.get(StaticUtils.toHex(e.getType())));
                    }
                }
            }
            this.isAuthenticated = isAuth;
            this.identitiesMatch = idsMatch;
            this.authNID = nID;
            this.authNEntry = nEntry;
            this.authZID = zID;
            this.authZEntry = zEntry;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_AUTHORIZATION_ENTRY_RESPONSE_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    @NotNull
    public GetAuthorizationEntryResponseControl decodeControl(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        return new GetAuthorizationEntryResponseControl(oid, isCritical, value);
    }

    @Nullable
    public static GetAuthorizationEntryResponseControl get(@NotNull BindResult result) throws LDAPException {
        Control c = result.getResponseControl(GET_AUTHORIZATION_ENTRY_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof GetAuthorizationEntryResponseControl) {
            return (GetAuthorizationEntryResponseControl)c;
        }
        return new GetAuthorizationEntryResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    @NotNull
    private static ASN1OctetString encodeValue(boolean isAuthenticated, boolean identitiesMatch, @Nullable String authNID, @Nullable ReadOnlyEntry authNEntry, @Nullable String authZID, @Nullable ReadOnlyEntry authZEntry) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(4);
        elements.add(new ASN1Boolean(-128, isAuthenticated));
        elements.add(new ASN1Boolean(-127, identitiesMatch));
        if (authNEntry != null) {
            elements.add(GetAuthorizationEntryResponseControl.encodeAuthEntry((byte)-94, authNID, authNEntry));
        }
        if (authZEntry != null) {
            elements.add(GetAuthorizationEntryResponseControl.encodeAuthEntry((byte)-93, authZID, authZEntry));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @NotNull
    private static ASN1Sequence encodeAuthEntry(byte type, @Nullable String authID, @NotNull ReadOnlyEntry authEntry) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(3);
        if (authID != null) {
            elements.add(new ASN1OctetString(-128, authID));
        }
        elements.add(new ASN1OctetString(-127, authEntry.getDN()));
        Collection<Attribute> attributes = authEntry.getAttributes();
        ArrayList<ASN1Sequence> attrElements = new ArrayList<ASN1Sequence>(attributes.size());
        for (Attribute a : attributes) {
            attrElements.add(a.encode());
        }
        elements.add(new ASN1Sequence(-94, attrElements));
        return new ASN1Sequence(type, elements);
    }

    @NotNull
    private static Object[] decodeAuthEntry(@NotNull ASN1Element element) throws ASN1Exception, LDAPException {
        String authID = null;
        String authDN = null;
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(20);
        block5: for (ASN1Element e : ASN1Sequence.decodeAsSequence(element).elements()) {
            switch (e.getType()) {
                case -128: {
                    authID = ASN1OctetString.decodeAsOctetString(e).stringValue();
                    continue block5;
                }
                case -127: {
                    authDN = ASN1OctetString.decodeAsOctetString(e).stringValue();
                    continue block5;
                }
                case -94: {
                    for (ASN1Element ae : ASN1Sequence.decodeAsSequence(e).elements()) {
                        attrs.add(Attribute.decode(ASN1Sequence.decodeAsSequence(ae)));
                    }
                    continue block5;
                }
                default: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_AUTHORIZATION_ENTRY_RESPONSE_INVALID_ENTRY_TYPE.get(StaticUtils.toHex(e.getType())));
                }
            }
        }
        return new Object[]{authID, new ReadOnlyEntry(authDN, attrs)};
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public boolean identitiesMatch() {
        return this.identitiesMatch;
    }

    @Nullable
    public String getAuthNID() {
        if (this.authNID == null && this.identitiesMatch) {
            return this.authZID;
        }
        return this.authNID;
    }

    @Nullable
    public ReadOnlyEntry getAuthNEntry() {
        if (this.authNEntry == null && this.identitiesMatch) {
            return this.authZEntry;
        }
        return this.authNEntry;
    }

    @Nullable
    public String getAuthZID() {
        if (this.authZID == null && this.identitiesMatch) {
            return this.authNID;
        }
        return this.authZID;
    }

    @Nullable
    public ReadOnlyEntry getAuthZEntry() {
        if (this.authZEntry == null && this.identitiesMatch) {
            return this.authNEntry;
        }
        return this.authZEntry;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_GET_AUTHORIZATION_ENTRY_RESPONSE.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        LinkedHashMap<String, JSONValue> valueFields = new LinkedHashMap<String, JSONValue>();
        valueFields.put(JSON_FIELD_IS_AUTHENTICATED, new JSONBoolean(this.isAuthenticated));
        valueFields.put(JSON_FIELD_IDENTITIES_MATCH, new JSONBoolean(this.identitiesMatch));
        if (this.authNID != null) {
            valueFields.put(JSON_FIELD_AUTHENTICATION_ID, new JSONString(this.authNID));
        }
        if (this.authNEntry != null) {
            valueFields.put(JSON_FIELD_AUTHENTICATION_ENTRY, GetAuthorizationEntryResponseControl.encodeEntryJSON(this.authNEntry));
        }
        if (this.authZEntry != null && !this.identitiesMatch) {
            if (this.authZID != null) {
                valueFields.put(JSON_FIELD_AUTHORIZATION_ID, new JSONString(this.authZID));
            }
            valueFields.put(JSON_FIELD_AUTHORIZATION_ENTRY, GetAuthorizationEntryResponseControl.encodeEntryJSON(this.authZEntry));
        }
        return new JSONObject(new JSONField("oid", GET_AUTHORIZATION_ENTRY_RESPONSE_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_GET_AUTHORIZATION_ENTRY_RESPONSE.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(valueFields)));
    }

    @NotNull
    private static JSONObject encodeEntryJSON(@NotNull ReadOnlyEntry entry) {
        LinkedHashMap<String, JSONValue> entryFields = new LinkedHashMap<String, JSONValue>();
        entryFields.put(JSON_FIELD_ENTRY_DN, new JSONString(entry.getDN()));
        for (Attribute a : entry.getAttributes()) {
            ArrayList<JSONString> attributeValues = new ArrayList<JSONString>(a.size());
            for (String v : a.getValues()) {
                attributeValues.add(new JSONString(v));
            }
            entryFields.put(a.getName(), new JSONArray(attributeValues));
        }
        return new JSONObject(entryFields);
    }

    @NotNull
    public static GetAuthorizationEntryResponseControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new GetAuthorizationEntryResponseControl(jsonControl.getOID(), jsonControl.getCriticality(), rawValue);
        }
        JSONObject valueObject = jsonControl.getValueObject();
        Boolean isAuthenticated = valueObject.getFieldAsBoolean(JSON_FIELD_IS_AUTHENTICATED);
        if (isAuthenticated == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_AUTHORIZATION_ENTRY_RESPONSE_JSON_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_IS_AUTHENTICATED));
        }
        Boolean identitiesMatch = valueObject.getFieldAsBoolean(JSON_FIELD_IDENTITIES_MATCH);
        if (identitiesMatch == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_AUTHORIZATION_ENTRY_RESPONSE_JSON_MISSING_FIELD.get(controlObject.toSingleLineString(), JSON_FIELD_IDENTITIES_MATCH));
        }
        String authenticationID = valueObject.getFieldAsString(JSON_FIELD_AUTHENTICATION_ID);
        ReadOnlyEntry authenticationEntry = GetAuthorizationEntryResponseControl.decodeEntryJSON(controlObject, valueObject, JSON_FIELD_AUTHENTICATION_ENTRY);
        String authorizationID = valueObject.getFieldAsString(JSON_FIELD_AUTHORIZATION_ID);
        ReadOnlyEntry authorizationEntry = GetAuthorizationEntryResponseControl.decodeEntryJSON(controlObject, valueObject, JSON_FIELD_AUTHORIZATION_ENTRY);
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_IS_AUTHENTICATED, JSON_FIELD_IDENTITIES_MATCH, JSON_FIELD_AUTHENTICATION_ID, JSON_FIELD_AUTHENTICATION_ENTRY, JSON_FIELD_AUTHORIZATION_ID, JSON_FIELD_AUTHORIZATION_ENTRY)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_AUTHORIZATION_ENTRY_RESPONSE_JSON_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new GetAuthorizationEntryResponseControl(isAuthenticated, identitiesMatch, authenticationID, authenticationEntry, authorizationID, authorizationEntry);
    }

    @Nullable
    private static ReadOnlyEntry decodeEntryJSON(@NotNull JSONObject controlObject, @NotNull JSONObject valueObject, @NotNull String entryField) throws LDAPException {
        JSONObject entryObject = valueObject.getFieldAsObject(entryField);
        if (entryObject == null) {
            return null;
        }
        String dn = null;
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(entryObject.getFields().size());
        for (Map.Entry<String, JSONValue> fieldEntry : entryObject.getFields().entrySet()) {
            String fieldName = fieldEntry.getKey();
            JSONValue fieldValue = fieldEntry.getValue();
            if (fieldName.equals(JSON_FIELD_ENTRY_DN)) {
                if (fieldValue instanceof JSONString) {
                    dn = ((JSONString)fieldValue).stringValue();
                    continue;
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_AUTHORIZATION_ENTRY_RESPONSE_JSON_DN_NOT_STRING.get(controlObject.toSingleLineString(), JSON_FIELD_ENTRY_DN, entryField));
            }
            if (fieldValue instanceof JSONArray) {
                List<JSONValue> jsonValues = ((JSONArray)fieldValue).getValues();
                ArrayList<String> stringValues = new ArrayList<String>(jsonValues.size());
                for (JSONValue v : jsonValues) {
                    if (v instanceof JSONString) {
                        stringValues.add(((JSONString)v).stringValue());
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_AUTHORIZATION_ENTRY_RESPONSE_JSON_VALUE_NOT_STRING.get(controlObject.toSingleLineString(), entryField, fieldName));
                }
                attributes.add(new Attribute(fieldName, stringValues));
                continue;
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_AUTHORIZATION_ENTRY_RESPONSE_JSON_ATTR_VALUE_NOT_ARRAY.get(controlObject.toSingleLineString(), entryField, fieldName));
        }
        if (dn == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_AUTHORIZATION_ENTRY_REQUEST_JSON_ENTRY_MISSING_DN.get(controlObject.toSingleLineString(), entryField, JSON_FIELD_ENTRY_DN));
        }
        return new ReadOnlyEntry(dn, attributes);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("GetAuthorizationEntryResponseControl(identitiesMatch=");
        buffer.append(this.identitiesMatch);
        if (this.authNID != null) {
            buffer.append(", authNID='");
            buffer.append(this.authNID);
            buffer.append('\'');
        }
        if (this.authNEntry != null) {
            buffer.append(", authNEntry=");
            this.authNEntry.toString(buffer);
        }
        if (this.authZID != null) {
            buffer.append(", authZID='");
            buffer.append(this.authZID);
            buffer.append('\'');
        }
        if (this.authZEntry != null) {
            buffer.append(", authZEntry=");
            this.authZEntry.toString(buffer);
        }
        buffer.append(')');
    }
}

