/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.ColumnDefinition;
import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.internal.core.type.DataTypeHelper;
import com.datastax.oss.protocol.internal.response.result.ColumnSpec;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Serializable;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultColumnDefinition
implements ColumnDefinition,
Serializable {
    private static final long serialVersionUID = 1L;
    private final CqlIdentifier keyspace;
    private final CqlIdentifier table;
    private final CqlIdentifier name;
    private final DataType type;

    public DefaultColumnDefinition(@NonNull ColumnSpec spec, @NonNull AttachmentPoint attachmentPoint) {
        this.keyspace = CqlIdentifier.fromInternal(spec.ksName);
        this.table = CqlIdentifier.fromInternal(spec.tableName);
        this.name = CqlIdentifier.fromInternal(spec.name);
        this.type = DataTypeHelper.fromProtocolSpec(spec.type, attachmentPoint);
    }

    @Override
    @NonNull
    public CqlIdentifier getKeyspace() {
        return this.keyspace;
    }

    @Override
    @NonNull
    public CqlIdentifier getTable() {
        return this.table;
    }

    @Override
    @NonNull
    public CqlIdentifier getName() {
        return this.name;
    }

    @Override
    @NonNull
    public DataType getType() {
        return this.type;
    }

    @Override
    public boolean isDetached() {
        return this.type.isDetached();
    }

    @Override
    public void attach(@NonNull AttachmentPoint attachmentPoint) {
        this.type.attach(attachmentPoint);
    }

    public String toString() {
        return this.keyspace.asCql(true) + "." + this.table.asCql(true) + "." + this.name.asCql(true) + " " + this.type;
    }
}

