/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.blob.deduplication;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.scala.publisher.SMono$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00055d\u0001\u0002\t\u0012\u0001yA\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!A!\t\u0001B\u0001B\u0003%1\tC\u0003K\u0001\u0011\u00051\nC\u0003W\u0001\u0011\u0005s\u000bC\u0003W\u0001\u0011\u0005s\u000f\u0003\u0004W\u0001\u0011\u0005\u00131\u0001\u0005\b\u0003C\u0001A\u0011IA\u0012\u0011\u001d\ti\u0003\u0001C!\u0003_Aq!!\u000e\u0001\t\u0003\n9\u0004C\u0004\u0002@\u0001!\t%!\u0011\t\u000f\u0005\r\u0003\u0001\"\u0011\u0002F!9\u0011\u0011\u000b\u0001\u0005B\u0005M\u0003bBA1\u0001\u0011\u0005\u00131\r\u0005\b\u0003O\u0002A\u0011IA5\u0005Q\u0001\u0016m]:UQJ|Wo\u001a5CY>\u00147\u000b^8sK*\u0011!cE\u0001\u000eI\u0016$W\u000f\u001d7jG\u0006$\u0018n\u001c8\u000b\u0005Q)\u0012\u0001\u00022m_\nT!AF\f\u0002\rM,'O^3s\u0015\tA\u0012$A\u0003kC6,7O\u0003\u0002\u001b7\u00051\u0011\r]1dQ\u0016T\u0011\u0001H\u0001\u0004_J<7\u0001A\n\u0004\u0001}9\u0003C\u0001\u0011&\u001b\u0005\t#B\u0001\u0012$\u0003\u0011a\u0017M\\4\u000b\u0003\u0011\nAA[1wC&\u0011a%\t\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005!bS\"A\u0015\u000b\u0005)Z\u0013aA1qS*\u0011AcF\u0005\u0003[%\u0012\u0011B\u00117pEN#xN]3\u0002\u0019\tdwNY*u_J,G)Q(\u0011\u0005!\u0002\u0014BA\u0019*\u00051\u0011En\u001c2Ti>\u0014X\rR!P\u0003E!WMZ1vYR\u0014UoY6fi:\u000bW.\u001a\t\u0003QQJ!!N\u0015\u0003\u0015\t+8m[3u\u001d\u0006lW\r\u000b\u0003\u0003o}\u0002\u0005C\u0001\u001d>\u001b\u0005I$B\u0001\u001e<\u0003\u0019IgN[3di*\tA(A\u0003kCZ\f\u00070\u0003\u0002?s\t)a*Y7fI\u0006)a/\u00197vK\u0006\n\u0011)A\u0007eK\u001a\fW\u000f\u001c;Ck\u000e\\W\r^\u0001\u000eE2|'-\u00133GC\u000e$xN]=\u0011\u0005\u0011;eB\u0001\u0015F\u0013\t1\u0015&\u0001\u0004CY>\u0014\u0017\nZ\u0005\u0003\u0011&\u0013qAR1di>\u0014\u0018P\u0003\u0002GS\u00051A(\u001b8jiz\"B\u0001\u0014(P#B\u0011Q\nA\u0007\u0002#!)a\u0006\u0002a\u0001_!)!\u0007\u0002a\u0001g!\"qjN A\u0011\u0015\u0011E\u00011\u0001DQ\t!1\u000b\u0005\u00029)&\u0011Q+\u000f\u0002\u0007\u0013:TWm\u0019;\u0002\tM\fg/\u001a\u000b\u00051\u0006\u001cg\u000eE\u0002Z9zk\u0011A\u0017\u0006\u00037n\tqB]3bGRLg/Z:ue\u0016\fWn]\u0005\u0003;j\u0013\u0011\u0002U;cY&\u001c\b.\u001a:\u0011\u0005!z\u0016B\u00011*\u0005\u0019\u0011En\u001c2JI\")!-\u0002a\u0001g\u0005Q!-^2lKRt\u0015-\\3\t\u000b\u0011,\u0001\u0019A3\u0002\t\u0011\fG/\u0019\t\u0004M&\\W\"A4\u000b\u0003!\fQa]2bY\u0006L!A[4\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u0019d\u0017BA7h\u0005\u0011\u0011\u0015\u0010^3\t\u000b=,\u0001\u0019\u00019\u0002\u001bM$xN]1hKB{G.[2z!\t\tHO\u0004\u0002)e&\u00111/K\u0001\n\u00052|'m\u0015;pe\u0016L!!\u001e<\u0003\u001bM#xN]1hKB{G.[2z\u0015\t\u0019\u0018\u0006F\u0003Yqf\f\t\u0001C\u0003c\r\u0001\u00071\u0007C\u0003e\r\u0001\u0007!\u0010\u0005\u0002|}6\tAP\u0003\u0002~G\u0005\u0011\u0011n\\\u0005\u0003\u007fr\u00141\"\u00138qkR\u001cFO]3b[\")qN\u0002a\u0001aR9\u0001,!\u0002\u0002\b\u0005}\u0001\"\u00022\b\u0001\u0004\u0019\u0004B\u00023\b\u0001\u0004\tI\u0001\u0005\u0003\u0002\f\u0005mQBAA\u0007\u0015\ri\u0018q\u0002\u0006\u0005\u0003#\t\u0019\"\u0001\u0004d_6lwN\u001c\u0006\u0005\u0003+\t9\"\u0001\u0004h_><G.\u001a\u0006\u0003\u00033\t1aY8n\u0013\u0011\ti\"!\u0004\u0003\u0015\tKH/Z*pkJ\u001cW\rC\u0003p\u000f\u0001\u0007\u0001/A\u0005sK\u0006$')\u001f;fgR1\u0011QEA\u0014\u0003S\u00012!\u0017/f\u0011\u0015\u0011\u0007\u00021\u00014\u0011\u0019\tY\u0003\u0003a\u0001=\u00061!\r\\8c\u0013\u0012\fAA]3bIR)!0!\r\u00024!)!-\u0003a\u0001g!1\u00111F\u0005A\u0002y\u000bAB]3bIJ+\u0017m\u0019;jm\u0016$b!!\u000f\u0002<\u0005u\u0002cA-]u\")!M\u0003a\u0001g!1\u00111\u0006\u0006A\u0002y\u000bAcZ3u\t\u00164\u0017-\u001e7u\u0005V\u001c7.\u001a;OC6,G#A\u001a\u0002\u0019\u0011,G.\u001a;f\u0005V\u001c7.\u001a;\u0015\t\u0005\u001d\u0013q\n\t\u00053r\u000bI\u0005E\u0002!\u0003\u0017J1!!\u0014\"\u0005\u00111v.\u001b3\t\u000b\td\u0001\u0019A\u001a\u0002\r\u0011,G.\u001a;f)\u0019\t)&!\u0018\u0002`A!\u0011\fXA,!\r\u0001\u0013\u0011L\u0005\u0004\u00037\n#a\u0002\"p_2,\u0017M\u001c\u0005\u0006E6\u0001\ra\r\u0005\u0007\u0003Wi\u0001\u0019\u00010\u0002\u00171L7\u000f\u001e\"vG.,Go\u001d\u000b\u0003\u0003K\u00022!\u0017/4\u0003%a\u0017n\u001d;CY>\u00147\u000fF\u0002Y\u0003WBQAY\bA\u0002M\u0002")
public class PassThroughBlobStore
implements BlobStore {
    private final BlobStoreDAO blobStoreDAO;
    @Named(value="defaultBucket")
    private final BucketName defaultBucketName;
    private final BlobId.Factory blobIdFactory;

    public Publisher<BlobId> save(BucketName x$1, String x$2, BlobStore.StoragePolicy x$3) {
        return super.save(x$1, x$2, x$3);
    }

    public Publisher<byte[]> readBytes(BucketName x$1, BlobId x$2, BlobStore.StoragePolicy x$3) {
        return super.readBytes(x$1, x$2, x$3);
    }

    public InputStream read(BucketName x$1, BlobId x$2, BlobStore.StoragePolicy x$3) {
        return super.read(x$1, x$2, x$3);
    }

    public Publisher<InputStream> readReactive(BucketName x$1, BlobId x$2, BlobStore.StoragePolicy x$3) {
        return super.readReactive(x$1, x$2, x$3);
    }

    public Publisher<BlobId> save(BucketName bucketName, byte[] data, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        BlobId blobId = this.blobIdFactory.randomId();
        return SMono$.MODULE$.apply(this.blobStoreDAO.save(bucketName, blobId, data)).then(SMono$.MODULE$.just((Object)blobId));
    }

    public Publisher<BlobId> save(BucketName bucketName, InputStream data, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        BlobId blobId = this.blobIdFactory.randomId();
        return SMono$.MODULE$.apply(this.blobStoreDAO.save(bucketName, blobId, data)).then(SMono$.MODULE$.just((Object)blobId));
    }

    public Publisher<BlobId> save(BucketName bucketName, ByteSource data, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        BlobId blobId = this.blobIdFactory.randomId();
        return SMono$.MODULE$.apply(this.blobStoreDAO.save(bucketName, blobId, data)).then(SMono$.MODULE$.just((Object)blobId));
    }

    public Publisher<byte[]> readBytes(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        return this.blobStoreDAO.readBytes(bucketName, blobId);
    }

    public InputStream read(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        return this.blobStoreDAO.read(bucketName, blobId);
    }

    public Publisher<InputStream> readReactive(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        return this.blobStoreDAO.readReactive(bucketName, blobId);
    }

    public BucketName getDefaultBucketName() {
        return this.defaultBucketName;
    }

    public Publisher<Void> deleteBucket(BucketName bucketName) {
        return this.blobStoreDAO.deleteBucket(bucketName);
    }

    public Publisher<Boolean> delete(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)blobId);
        return SMono$.MODULE$.fromPublisher(this.blobStoreDAO.delete(bucketName, blobId)).then(SMono$.MODULE$.just((Object)BoxesRunTime.boxToBoolean((boolean)true)));
    }

    public Publisher<BucketName> listBuckets() {
        return Flux.concat((Publisher[])new Publisher[]{this.blobStoreDAO.listBuckets(), Flux.just((Object)this.defaultBucketName)}).distinct();
    }

    public Publisher<BlobId> listBlobs(BucketName bucketName) {
        return this.blobStoreDAO.listBlobs(bucketName);
    }

    @Inject
    public PassThroughBlobStore(BlobStoreDAO blobStoreDAO, @Named(value="defaultBucket") BucketName defaultBucketName, BlobId.Factory blobIdFactory) {
        this.blobStoreDAO = blobStoreDAO;
        this.defaultBucketName = defaultBucketName;
        this.blobIdFactory = blobIdFactory;
    }
}

