/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.cassandra;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import reactor.core.publisher.Mono;

public class CassandraMailRepositoryCountDAO {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement increment;
    private final PreparedStatement decrement;
    private final PreparedStatement select;

    @Inject
    public CassandraMailRepositoryCountDAO(Session session) {
        this.executor = new CassandraAsyncExecutor(session);
        this.increment = this.prepareIncrement(session);
        this.decrement = this.prepareDecrement(session);
        this.select = this.prepareSelect(session);
    }

    private PreparedStatement prepareDecrement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.update((String)"mailRepositoryCount").with(QueryBuilder.decr((String)"count")).where(QueryBuilder.eq((String)"name", (Object)QueryBuilder.bindMarker((String)"name"))));
    }

    private PreparedStatement prepareIncrement(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.update((String)"mailRepositoryCount").with(QueryBuilder.incr((String)"count")).where(QueryBuilder.eq((String)"name", (Object)QueryBuilder.bindMarker((String)"name"))));
    }

    private PreparedStatement prepareSelect(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"count"}).from("mailRepositoryCount").where(QueryBuilder.eq((String)"name", (Object)QueryBuilder.bindMarker((String)"name"))));
    }

    public Mono<Void> increment(MailRepositoryUrl url) {
        return this.executor.executeVoid((Statement)this.increment.bind().setString("name", url.asString()));
    }

    public Mono<Void> decrement(MailRepositoryUrl url) {
        return this.executor.executeVoid((Statement)this.decrement.bind().setString("name", url.asString()));
    }

    public Mono<Long> getCount(MailRepositoryUrl url) {
        return this.executor.executeSingleRowOptional((Statement)this.select.bind().setString("name", url.asString())).map(this::toCount);
    }

    private Long toCount(Optional<Row> rowOptional) {
        return rowOptional.map(row -> row.getLong("count")).orElse(0L);
    }
}

