/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.subtle.EllipticCurves;
import com.google.crypto.tink.subtle.Hkdf;
import com.google.crypto.tink.subtle.ImmutableByteArray;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;

public final class EciesHkdfSenderKem {
    private ECPublicKey recipientPublicKey;

    public EciesHkdfSenderKem(ECPublicKey recipientPublicKey) {
        this.recipientPublicKey = recipientPublicKey;
    }

    public KemKey generateKey(String hmacAlgo, byte[] hkdfSalt, byte[] hkdfInfo, int keySizeInBytes, EllipticCurves.PointFormatType pointFormat) throws GeneralSecurityException {
        KeyPair ephemeralKeyPair = EllipticCurves.generateKeyPair(this.recipientPublicKey.getParams());
        ECPublicKey ephemeralPublicKey = (ECPublicKey)ephemeralKeyPair.getPublic();
        ECPrivateKey ephemeralPrivateKey = (ECPrivateKey)ephemeralKeyPair.getPrivate();
        byte[] sharedSecret = EllipticCurves.computeSharedSecret(ephemeralPrivateKey, this.recipientPublicKey);
        byte[] kemBytes = EllipticCurves.pointEncode(ephemeralPublicKey.getParams().getCurve(), pointFormat, ephemeralPublicKey.getW());
        byte[] symmetricKey = Hkdf.computeEciesHkdfSymmetricKey(kemBytes, sharedSecret, hmacAlgo, hkdfSalt, hkdfInfo, keySizeInBytes);
        return new KemKey(kemBytes, symmetricKey);
    }

    public static final class KemKey {
        private final ImmutableByteArray kemBytes;
        private final ImmutableByteArray symmetricKey;

        public KemKey(byte[] kemBytes, byte[] symmetricKey) {
            this.kemBytes = ImmutableByteArray.of(kemBytes);
            this.symmetricKey = ImmutableByteArray.of(symmetricKey);
        }

        public byte[] getKemBytes() {
            if (this.kemBytes == null) {
                return null;
            }
            return this.kemBytes.getBytes();
        }

        public byte[] getSymmetricKey() {
            if (this.symmetricKey == null) {
                return null;
            }
            return this.symmetricKey.getBytes();
        }
    }
}

