/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.OutputStream;
import java.io.PrintStream;

@InternalUseOnly
@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public abstract class LDAPResultWriter {
    @NotNull
    private volatile PrintStream printStream;

    protected LDAPResultWriter(@NotNull OutputStream outputStream) {
        this.printStream = LDAPResultWriter.getPrintStream(outputStream);
    }

    public final void updateOutputStream(@NotNull OutputStream outputStream) {
        this.printStream = LDAPResultWriter.getPrintStream(outputStream);
    }

    @NotNull
    private static PrintStream getPrintStream(@NotNull OutputStream outputStream) {
        if (outputStream instanceof PrintStream) {
            return (PrintStream)outputStream;
        }
        return new PrintStream(outputStream);
    }

    protected void println() {
        this.printStream.println();
    }

    protected void print(@NotNull String string) {
        this.printStream.print(string);
    }

    protected void println(@NotNull String string) {
        this.printStream.println(string);
    }

    @NotNull
    protected final PrintStream getPrintStream() {
        return this.printStream;
    }

    public final void flush() {
        this.printStream.flush();
    }

    public abstract void writeComment(@NotNull String var1);

    public abstract void writeHeader();

    public abstract void writeSearchResultEntry(@NotNull SearchResultEntry var1);

    public abstract void writeSearchResultReference(@NotNull SearchResultReference var1);

    public abstract void writeResult(@NotNull LDAPResult var1);

    public abstract void writeUnsolicitedNotification(@NotNull LDAPConnection var1, @NotNull ExtendedResult var2);
}

