/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mime4j.io.BufferedLineReaderInputStream;
import org.apache.james.mime4j.io.InputStreams;
import org.apache.james.mime4j.io.MimeBoundaryInputStream;
import org.apache.james.mime4j.util.ByteArrayBuffer;
import org.apache.james.mime4j.util.ContentUtil;
import org.junit.Assert;
import org.junit.Test;

public class MimeBoundaryInputStreamTest {
    private static BufferedLineReaderInputStream create(String s, int bufSize) {
        return new BufferedLineReaderInputStream(InputStreams.createAscii((CharSequence)s), bufSize);
    }

    private static BufferedLineReaderInputStream create(byte[] b, int bufSize) {
        return new BufferedLineReaderInputStream(InputStreams.create((byte[])b), bufSize);
    }

    @Test
    public void testBasicReading() throws IOException {
        String text = "Line 1\r\nLine 2\r\n--boundary\r\nLine 3\r\nLine 4\r\n--boundary--";
        BufferedLineReaderInputStream buffer = MimeBoundaryInputStreamTest.create(text, 4096);
        MimeBoundaryInputStream mime1 = new MimeBoundaryInputStream(buffer, "boundary");
        Assert.assertEquals((Object)"Line 1\r\nLine 2", (Object)this.read((InputStream)mime1, 5));
        Assert.assertFalse((boolean)mime1.isLastPart());
        MimeBoundaryInputStream mime2 = new MimeBoundaryInputStream(buffer, "boundary");
        Assert.assertEquals((Object)"Line 3\r\nLine 4", (Object)this.read((InputStream)mime2, 5));
        Assert.assertTrue((boolean)mime2.isLastPart());
    }

    @Test
    public void testLenientLineDelimiterReading() throws IOException {
        String text = "Line 1\r\nLine 2\n--boundary\nLine 3\r\nLine 4\n--boundary--\n";
        BufferedLineReaderInputStream buffer = MimeBoundaryInputStreamTest.create(text, 4096);
        MimeBoundaryInputStream mime1 = new MimeBoundaryInputStream(buffer, "boundary");
        Assert.assertEquals((Object)"Line 1\r\nLine 2", (Object)this.read((InputStream)mime1, 5));
        Assert.assertFalse((boolean)mime1.isLastPart());
        MimeBoundaryInputStream mime2 = new MimeBoundaryInputStream(buffer, "boundary");
        Assert.assertEquals((Object)"Line 3\r\nLine 4", (Object)this.read((InputStream)mime2, 5));
        Assert.assertTrue((boolean)mime2.isLastPart());
    }

    @Test
    public void testBasicReadingSmallBuffer1() throws IOException {
        String text = "yadayadayadayadayadayadayadayadayadayadayadayadayadayadayadayada\r\n--boundary\r\nblahblahblahblahblahblahblahblahblahblahblahblahblahblahblahblahblahblah\r\n--boundary--";
        BufferedLineReaderInputStream buffer = MimeBoundaryInputStreamTest.create(text, 20);
        MimeBoundaryInputStream mime1 = new MimeBoundaryInputStream(buffer, "boundary");
        Assert.assertEquals((Object)"yadayadayadayadayadayadayadayadayadayadayadayadayadayadayadayada", (Object)this.read((InputStream)mime1, 10));
        Assert.assertFalse((boolean)mime1.isLastPart());
        MimeBoundaryInputStream mime2 = new MimeBoundaryInputStream(buffer, "boundary");
        Assert.assertEquals((Object)"blahblahblahblahblahblahblahblahblahblahblahblahblahblahblahblahblahblah", (Object)this.read((InputStream)mime2, 10));
        Assert.assertTrue((boolean)mime2.isLastPart());
    }

    @Test
    public void testBasicReadingSmallBuffer2() throws IOException {
        String text = "yadayadayadayadayadayadayadayadayadayadayadayadayadayadayadayada\r\n--boundary\r\nblahblahblahblahblahblahblahblahblahblahblahblahblahblahblahblahblahblah\r\n--boundary--";
        BufferedLineReaderInputStream buffer = MimeBoundaryInputStreamTest.create(text, 20);
        MimeBoundaryInputStream mime1 = new MimeBoundaryInputStream(buffer, "boundary");
        Assert.assertEquals((Object)"yadayadayadayadayadayadayadayadayadayadayadayadayadayadayadayada", (Object)this.read((InputStream)mime1, 25));
        Assert.assertFalse((boolean)mime1.isLastPart());
        MimeBoundaryInputStream mime2 = new MimeBoundaryInputStream(buffer, "boundary");
        Assert.assertEquals((Object)"blahblahblahblahblahblahblahblahblahblahblahblahblahblahblahblahblahblah", (Object)this.read((InputStream)mime2, 25));
        Assert.assertTrue((boolean)mime2.isLastPart());
    }

    @Test
    public void testBasicReadingByOneByte() throws IOException {
        String text = "Line 1\r\nLine 2\r\n--boundary\r\nLine 3\r\nLine 4\r\n--boundary--";
        BufferedLineReaderInputStream buffer = MimeBoundaryInputStreamTest.create(text, 4096);
        MimeBoundaryInputStream mime1 = new MimeBoundaryInputStream(buffer, "boundary");
        Assert.assertEquals((Object)"Line 1\r\nLine 2", (Object)this.readByOneByte((InputStream)mime1));
        Assert.assertFalse((boolean)mime1.isLastPart());
        MimeBoundaryInputStream mime2 = new MimeBoundaryInputStream(buffer, "boundary");
        Assert.assertEquals((Object)"Line 3\r\nLine 4", (Object)this.readByOneByte((InputStream)mime2));
        Assert.assertTrue((boolean)mime2.isLastPart());
    }

    @Test
    public void testCRLFPrecedingBoundary() throws IOException {
        String text = "Line 1\r\nLine 2\r\n--boundary\r\nLine 3\r\nLine 4\r\n\r\n--boundary\r\n";
        BufferedLineReaderInputStream buffer = MimeBoundaryInputStreamTest.create(text, 4096);
        MimeBoundaryInputStream mime1 = new MimeBoundaryInputStream(buffer, "boundary");
        Assert.assertEquals((Object)"Line 1\r\nLine 2", (Object)this.read((InputStream)mime1, 5));
        Assert.assertFalse((boolean)mime1.isLastPart());
        MimeBoundaryInputStream mime2 = new MimeBoundaryInputStream(buffer, "boundary");
        Assert.assertEquals((Object)"Line 3\r\nLine 4\r\n", (Object)this.read((InputStream)mime2, 5));
        Assert.assertFalse((boolean)mime2.isLastPart());
    }

    private String readByOneByte(InputStream is) throws IOException {
        int b;
        StringBuilder sb = new StringBuilder();
        while ((b = is.read()) != -1) {
            sb.append((char)b);
        }
        return sb.toString();
    }

    private String read(InputStream is, int bufsize) throws IOException {
        int l;
        StringBuilder sb = new StringBuilder();
        byte[] tmp = new byte[bufsize];
        while ((l = is.read(tmp)) != -1) {
            for (int i = 0; i < l; ++i) {
                sb.append((char)tmp[i]);
            }
        }
        return sb.toString();
    }

    @Test
    public void testImmediateBoundary() throws IOException {
        String text1 = "--boundary\r\n";
        BufferedLineReaderInputStream buffer1 = MimeBoundaryInputStreamTest.create(text1, 4096);
        MimeBoundaryInputStream stream1 = new MimeBoundaryInputStream(buffer1, "boundary");
        Assert.assertEquals((long)-1L, (long)stream1.read());
        stream1.close();
        String text2 = "\r\n--boundary\r\n";
        BufferedLineReaderInputStream buffer2 = MimeBoundaryInputStreamTest.create(text2, 4096);
        MimeBoundaryInputStream stream2 = new MimeBoundaryInputStream(buffer2, "boundary");
        Assert.assertEquals((long)-1L, (long)stream2.read());
        stream2.close();
    }

    @Test
    public void testHasMoreParts() throws IOException {
        String text = "--boundary--\r\n";
        BufferedLineReaderInputStream buffer = MimeBoundaryInputStreamTest.create(text, 4096);
        MimeBoundaryInputStream stream = new MimeBoundaryInputStream(buffer, "boundary");
        Assert.assertEquals((long)-1L, (long)stream.read());
        Assert.assertTrue((boolean)stream.isLastPart());
        stream.close();
    }

    @Test
    public void testPrefixIsBoundary() throws IOException {
        String text1 = "Line 1\r\n\r\n--boundary\r\n";
        BufferedLineReaderInputStream buffer1 = MimeBoundaryInputStreamTest.create(text1, 4096);
        MimeBoundaryInputStream stream1 = new MimeBoundaryInputStream(buffer1, "boundary");
        Assert.assertEquals((Object)"Line 1\r\n", (Object)this.read((InputStream)stream1, 100));
        stream1.close();
        String text2 = "--boundary\r\n";
        BufferedLineReaderInputStream buffer2 = MimeBoundaryInputStreamTest.create(text2, 4096);
        MimeBoundaryInputStream stream2 = new MimeBoundaryInputStream(buffer2, "boundary");
        Assert.assertEquals((long)-1L, (long)stream2.read());
        stream2.close();
    }

    @Test
    public void testBasicReadLine() throws Exception {
        String[] teststrs = new String[5];
        teststrs[0] = "Hello\r\n";
        teststrs[1] = "This string should be much longer than the size of the input buffer which is only 20 bytes for this test\r\n";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 15; ++i) {
            sb.append("123456789 ");
        }
        sb.append("and stuff like that\r\n");
        teststrs[2] = sb.toString();
        teststrs[3] = "\r\n";
        teststrs[4] = "And goodbye\r\n";
        String term = "\r\n--1234\r\n";
        ByteArrayBuffer buf = new ByteArrayBuffer(128);
        for (String teststr : teststrs) {
            byte[] b = ContentUtil.toAsciiByteArray((String)teststr);
            buf.append(b, 0, b.length);
        }
        byte[] tb = ContentUtil.toAsciiByteArray((String)term);
        buf.append(tb, 0, tb.length);
        byte[] raw = buf.toByteArray();
        BufferedLineReaderInputStream inbuffer = MimeBoundaryInputStreamTest.create(raw, 20);
        MimeBoundaryInputStream instream = new MimeBoundaryInputStream(inbuffer, "1234");
        ByteArrayBuffer linebuf = new ByteArrayBuffer(8);
        for (String teststr : teststrs) {
            linebuf.clear();
            instream.readLine(linebuf);
            String s = ContentUtil.toAsciiString((ByteArrayBuffer)linebuf);
            Assert.assertEquals((Object)teststr, (Object)s);
        }
        Assert.assertEquals((long)-1L, (long)instream.readLine(linebuf));
        Assert.assertEquals((long)-1L, (long)instream.readLine(linebuf));
        instream.close();
    }

    @Test
    public void testReadEmptyLine() throws Exception {
        String teststr = "01234567890123456789\n\n\r\n\r\r\n\n\n\n\n\n--1234\r\n";
        byte[] raw = ContentUtil.toAsciiByteArray((String)teststr);
        BufferedLineReaderInputStream inbuffer = MimeBoundaryInputStreamTest.create(raw, 20);
        MimeBoundaryInputStream instream = new MimeBoundaryInputStream(inbuffer, "1234");
        ByteArrayBuffer linebuf = new ByteArrayBuffer(8);
        linebuf.clear();
        instream.readLine(linebuf);
        String s = ContentUtil.toAsciiString((ByteArrayBuffer)linebuf);
        Assert.assertEquals((Object)"01234567890123456789\n", (Object)s);
        linebuf.clear();
        instream.readLine(linebuf);
        s = ContentUtil.toAsciiString((ByteArrayBuffer)linebuf);
        Assert.assertEquals((Object)"\n", (Object)s);
        linebuf.clear();
        instream.readLine(linebuf);
        s = ContentUtil.toAsciiString((ByteArrayBuffer)linebuf);
        Assert.assertEquals((Object)"\r\n", (Object)s);
        linebuf.clear();
        instream.readLine(linebuf);
        s = ContentUtil.toAsciiString((ByteArrayBuffer)linebuf);
        Assert.assertEquals((Object)"\r\r\n", (Object)s);
        linebuf.clear();
        instream.readLine(linebuf);
        s = ContentUtil.toAsciiString((ByteArrayBuffer)linebuf);
        Assert.assertEquals((Object)"\n", (Object)s);
        linebuf.clear();
        instream.readLine(linebuf);
        s = ContentUtil.toAsciiString((ByteArrayBuffer)linebuf);
        Assert.assertEquals((Object)"\n", (Object)s);
        linebuf.clear();
        instream.readLine(linebuf);
        s = ContentUtil.toAsciiString((ByteArrayBuffer)linebuf);
        Assert.assertEquals((Object)"\n", (Object)s);
        linebuf.clear();
        instream.readLine(linebuf);
        s = ContentUtil.toAsciiString((ByteArrayBuffer)linebuf);
        Assert.assertEquals((Object)"\n", (Object)s);
        Assert.assertEquals((long)-1L, (long)instream.readLine(linebuf));
        Assert.assertEquals((long)-1L, (long)instream.readLine(linebuf));
        instream.close();
    }
}

