/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.samples.transform;

import java.io.OutputStream;
import java.util.Date;
import java.util.Random;
import org.apache.james.mime4j.Charsets;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.message.BodyFactory;
import org.apache.james.mime4j.message.BodyPart;
import org.apache.james.mime4j.message.BodyPartBuilder;
import org.apache.james.mime4j.message.DefaultMessageWriter;
import org.apache.james.mime4j.message.MultipartBuilder;
import org.apache.james.mime4j.storage.StorageBodyFactory;
import org.apache.james.mime4j.storage.StorageProvider;
import org.apache.james.mime4j.storage.TempFileStorageProvider;

public class TransformMessage {
    private static final String HOSTNAME = "localhost";

    public static void main(String[] args) throws Exception {
        TempFileStorageProvider storageProvider = new TempFileStorageProvider();
        StorageBodyFactory bodyFactory = new StorageBodyFactory((StorageProvider)storageProvider, DecodeMonitor.SILENT);
        Message template = Message.Builder.of().setBody(MultipartBuilder.create((String)"mixed").addBodyPart((Entity)BodyPartBuilder.create().use((BodyFactory)bodyFactory).setBody("This is the first part of the template..", Charsets.UTF_8).setContentTransferEncoding("quoted-printable").build()).addBodyPart((Entity)BodyPartBuilder.create().use((BodyFactory)bodyFactory).setBody(TransformMessage.createRandomBinary(200), "application/octet-stream").setContentTransferEncoding("base64").build()).addBodyPart((Entity)BodyPartBuilder.create().use((BodyFactory)bodyFactory).setBody(TransformMessage.createRandomBinary(300), "application/octet-stream").setContentTransferEncoding("base64").build()).build()).setSubject("Template message").build();
        Message.Builder messageBuilder = Message.Builder.of((Message)template);
        Multipart multipart = (Multipart)messageBuilder.getBody();
        int count = multipart.getCount();
        for (int i = 0; i < count; ++i) {
            String text = "Text inserted after part " + (i + 1);
            BodyPart bodyPart = BodyPartBuilder.create().use((BodyFactory)bodyFactory).setBody(text, Charsets.UTF_8).setContentTransferEncoding("quoted-printable").build();
            multipart.addBodyPart((Entity)bodyPart, 2 * i + 1);
        }
        Entity removed = multipart.removeBodyPart(4);
        removed.dispose();
        messageBuilder.generateMessageId(HOSTNAME);
        messageBuilder.setSubject("Transformed message");
        messageBuilder.setDate(new Date());
        messageBuilder.setFrom("John Doe <jdoe@machine.example>");
        Message transformed = messageBuilder.build();
        DefaultMessageWriter writer = new DefaultMessageWriter();
        System.out.println("\n\nTransformed message:\n--------------------\n");
        writer.writeMessage(transformed, (OutputStream)System.out);
        transformed.dispose();
        System.out.println("\n\nOriginal template:\n------------------\n");
        writer.writeMessage(template, (OutputStream)System.out);
        template.dispose();
    }

    private static byte[] createRandomBinary(int numberOfBytes) {
        byte[] data = new byte[numberOfBytes];
        new Random().nextBytes(data);
        return data;
    }
}

