/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.stream;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.james.mime4j.ExampleMail;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.EntityState;
import org.apache.james.mime4j.stream.MimeTokenStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MimeTokenStreamBodyDescriptorTest {
    MimeTokenStream parser;

    @Before
    public void setUp() throws Exception {
        this.parser = new MimeTokenStream();
        this.parser.parse((InputStream)new ByteArrayInputStream(ExampleMail.MIME_MULTIPART_ALTERNATIVE_BYTES));
    }

    @Test
    public void testShouldReturnValidDescriptorForPreamble() throws Exception {
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_START_HEADER), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_FIELD), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_FIELD), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_FIELD), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_FIELD), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_FIELD), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_END_HEADER), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_START_MULTIPART), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_PREAMBLE), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        BodyDescriptor descriptor = this.parser.getBodyDescriptor();
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"1729", (Object)descriptor.getBoundary());
        Assert.assertEquals((Object)"multipart/alternative", (Object)descriptor.getMimeType());
    }

    @Test
    public void testShouldReturnValidDescriptorForEpilogue() throws Exception {
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_START_HEADER), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_FIELD), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_FIELD), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_FIELD), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_FIELD), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_FIELD), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_END_HEADER), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_START_MULTIPART), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_PREAMBLE), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_START_BODYPART), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_START_HEADER), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_FIELD), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_END_HEADER), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_BODY), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_END_BODYPART), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_START_BODYPART), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_START_HEADER), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_FIELD), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_END_HEADER), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_BODY), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_END_BODYPART), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_START_BODYPART), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_START_HEADER), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_FIELD), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_END_HEADER), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_BODY), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_END_BODYPART), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)EntityState.T_EPILOGUE), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
        BodyDescriptor descriptor = this.parser.getBodyDescriptor();
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((Object)"1729", (Object)descriptor.getBoundary());
        Assert.assertEquals((Object)"multipart/alternative", (Object)descriptor.getMimeType());
    }
}

