/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PatternTreeMap;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeTTLCache;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionPathUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.io.CompactionTsFileReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionType;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.db.utils.datastructure.PatternTreeMapFactory;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.MetadataIndexNode;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.apache.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.tsfile.read.TsFileDeviceIterator;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class MultiTsFileDeviceIterator
implements AutoCloseable {
    private final List<TsFileResource> tsFileResourcesSortedByDesc;
    private List<TsFileResource> tsFileResourcesSortedByAsc;
    private Map<TsFileResource, TsFileSequenceReader> readerMap = new HashMap<TsFileResource, TsFileSequenceReader>();
    private final Map<TsFileResource, TsFileDeviceIterator> deviceIteratorMap = new HashMap<TsFileResource, TsFileDeviceIterator>();
    private final Map<TsFileResource, PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer>> modificationCache = new HashMap<TsFileResource, PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer>>();
    private Pair<IDeviceID, Boolean> currentDevice = null;
    private long ttlForCurrentDevice;
    private long timeLowerBoundForCurrentDevice;

    public MultiTsFileDeviceIterator(List<TsFileResource> tsFileResources) throws IOException {
        this.tsFileResourcesSortedByDesc = new ArrayList<TsFileResource>(tsFileResources);
        this.tsFileResourcesSortedByAsc = new ArrayList<TsFileResource>(tsFileResources);
        Collections.sort(this.tsFileResourcesSortedByAsc, TsFileResource::compareFileName);
        Collections.sort(this.tsFileResourcesSortedByDesc, TsFileResource::compareFileCreationOrderByDesc);
        try {
            for (TsFileResource tsFileResource : this.tsFileResourcesSortedByDesc) {
                CompactionTsFileReader reader = new CompactionTsFileReader(tsFileResource.getTsFilePath(), CompactionType.INNER_SEQ_COMPACTION);
                this.readerMap.put(tsFileResource, reader);
                this.deviceIteratorMap.put(tsFileResource, reader.getAllDevicesIteratorWithIsAligned());
            }
        }
        catch (Exception e) {
            for (TsFileSequenceReader reader : this.readerMap.values()) {
                reader.close();
            }
            throw e;
        }
    }

    public MultiTsFileDeviceIterator(List<TsFileResource> seqResources, List<TsFileResource> unseqResources) throws IOException {
        this.tsFileResourcesSortedByDesc = new ArrayList<TsFileResource>(seqResources);
        this.tsFileResourcesSortedByDesc.addAll(unseqResources);
        Collections.sort(this.tsFileResourcesSortedByDesc, TsFileResource::compareFileCreationOrderByDesc);
        for (TsFileResource tsFileResource : this.tsFileResourcesSortedByDesc) {
            TsFileSequenceReader reader = FileReaderManager.getInstance().get(tsFileResource.getTsFilePath(), tsFileResource.getTsFileID(), true);
            this.readerMap.put(tsFileResource, reader);
            this.deviceIteratorMap.put(tsFileResource, reader.getAllDevicesIteratorWithIsAligned());
        }
    }

    public MultiTsFileDeviceIterator(List<TsFileResource> seqResources, List<TsFileResource> unseqResources, Map<TsFileResource, TsFileSequenceReader> readerMap) throws IOException {
        this.tsFileResourcesSortedByDesc = new ArrayList<TsFileResource>(seqResources);
        this.tsFileResourcesSortedByDesc.addAll(unseqResources);
        Collections.sort(this.tsFileResourcesSortedByDesc, TsFileResource::compareFileCreationOrderByDesc);
        this.readerMap = readerMap;
        CompactionType type = null;
        type = !seqResources.isEmpty() && !unseqResources.isEmpty() ? CompactionType.CROSS_COMPACTION : (seqResources.isEmpty() ? CompactionType.INNER_UNSEQ_COMPACTION : CompactionType.INNER_SEQ_COMPACTION);
        for (TsFileResource tsFileResource : this.tsFileResourcesSortedByDesc) {
            CompactionTsFileReader reader = new CompactionTsFileReader(tsFileResource.getTsFilePath(), type);
            readerMap.put(tsFileResource, reader);
            this.deviceIteratorMap.put(tsFileResource, reader.getAllDevicesIteratorWithIsAligned());
        }
    }

    public boolean hasNextDevice() {
        TsFileDeviceIterator iterator;
        boolean hasNext = false;
        Iterator<TsFileDeviceIterator> iterator2 = this.deviceIteratorMap.values().iterator();
        while (iterator2.hasNext() && !(hasNext = (iterator = iterator2.next()).hasNext() || iterator.current() != null && !((IDeviceID)iterator.current().left).equals(this.currentDevice.left))) {
        }
        return hasNext;
    }

    public Pair<IDeviceID, Boolean> nextDevice() throws IllegalPathException {
        LinkedList<TsFileResource> toBeRemovedResources = new LinkedList<TsFileResource>();
        Pair minDevice = null;
        for (TsFileResource resource : this.tsFileResourcesSortedByDesc) {
            if (!this.deviceIteratorMap.containsKey(resource)) continue;
            TsFileDeviceIterator deviceIterator = this.deviceIteratorMap.get(resource);
            if (deviceIterator.current() == null || ((IDeviceID)deviceIterator.current().left).equals(this.currentDevice.left)) {
                if (deviceIterator.hasNext()) {
                    deviceIterator.next();
                } else {
                    toBeRemovedResources.add(resource);
                    continue;
                }
            }
            if (minDevice != null && ((IDeviceID)minDevice.left).compareTo((Object)((IDeviceID)deviceIterator.current().left)) <= 0) continue;
            minDevice = deviceIterator.current();
        }
        this.currentDevice = minDevice;
        for (TsFileResource resource : toBeRemovedResources) {
            this.deviceIteratorMap.remove(resource);
        }
        this.ttlForCurrentDevice = DataNodeTTLCache.getInstance().getTTL(((PlainDeviceID)this.currentDevice.getLeft()).toStringID());
        this.timeLowerBoundForCurrentDevice = this.ttlForCurrentDevice == Long.MAX_VALUE ? Long.MIN_VALUE : CommonDateTimeUtils.currentTime() - this.ttlForCurrentDevice;
        return this.currentDevice;
    }

    public long getTTLForCurrentDevice() {
        return this.ttlForCurrentDevice;
    }

    public long getTimeLowerBoundForCurrentDevice() {
        return this.timeLowerBoundForCurrentDevice;
    }

    public Map<String, MeasurementSchema> getAllSchemasOfCurrentDevice() throws IOException {
        ConcurrentHashMap<String, MeasurementSchema> schemaMap = new ConcurrentHashMap<String, MeasurementSchema>();
        for (TsFileResource resource : this.tsFileResourcesSortedByDesc) {
            if (!this.deviceIteratorMap.containsKey(resource) || !this.deviceIteratorMap.get(resource).current().equals(this.currentDevice)) continue;
            TsFileSequenceReader reader = this.readerMap.get(resource);
            ArrayList timeseriesMetadataList = new ArrayList();
            reader.getDeviceTimeseriesMetadata(timeseriesMetadataList, this.deviceIteratorMap.get(resource).getFirstMeasurementNodeOfCurrentDevice(), schemaMap.keySet(), true);
            for (TimeseriesMetadata timeseriesMetadata : timeseriesMetadataList) {
                if (schemaMap.containsKey(timeseriesMetadata.getMeasurementId()) || timeseriesMetadata.getChunkMetadataList().isEmpty()) continue;
                schemaMap.put(timeseriesMetadata.getMeasurementId(), reader.getMeasurementSchema(timeseriesMetadata.getChunkMetadataList()));
            }
        }
        return schemaMap;
    }

    public Map<String, Map<TsFileResource, Pair<Long, Long>>> getTimeseriesMetadataOffsetOfCurrentDevice() throws IOException {
        HashMap<String, Map<TsFileResource, Pair<Long, Long>>> timeseriesMetadataOffsetMap = new HashMap<String, Map<TsFileResource, Pair<Long, Long>>>();
        HashMap<String, TSDataType> measurementDataTypeMap = new HashMap<String, TSDataType>();
        for (TsFileResource resource : this.tsFileResourcesSortedByDesc) {
            if (!this.deviceIteratorMap.containsKey(resource) || !this.deviceIteratorMap.get(resource).current().equals(this.currentDevice)) continue;
            TsFileSequenceReader reader = this.readerMap.get(resource);
            for (Map.Entry<String, Pair<TimeseriesMetadata, Pair<Long, Long>>> entrySet : ((CompactionTsFileReader)reader).getTimeseriesMetadataAndOffsetByDevice(this.deviceIteratorMap.get(resource).getFirstMeasurementNodeOfCurrentDevice(), Collections.emptySet(), false).entrySet()) {
                TSDataType dataTypeOfCurrentTimeseriesMetadata;
                String measurementId = entrySet.getKey();
                TSDataType correctDataTypeOfCurrentMeasurement = measurementDataTypeMap.putIfAbsent(measurementId, dataTypeOfCurrentTimeseriesMetadata = ((TimeseriesMetadata)entrySet.getValue().left).getTsDataType());
                if (correctDataTypeOfCurrentMeasurement != null && correctDataTypeOfCurrentMeasurement != dataTypeOfCurrentTimeseriesMetadata) continue;
                timeseriesMetadataOffsetMap.putIfAbsent(measurementId, new HashMap());
                ((Map)timeseriesMetadataOffsetMap.get(measurementId)).put(resource, (Pair)entrySet.getValue().right);
            }
        }
        return timeseriesMetadataOffsetMap;
    }

    public Map<String, Pair<MeasurementSchema, Map<TsFileResource, Pair<Long, Long>>>> getTimeseriesSchemaAndMetadataOffsetOfCurrentDevice() throws IOException {
        LinkedHashMap<String, Pair<MeasurementSchema, Map<TsFileResource, Pair<Long, Long>>>> timeseriesMetadataOffsetMap = new LinkedHashMap<String, Pair<MeasurementSchema, Map<TsFileResource, Pair<Long, Long>>>>();
        for (TsFileResource resource : this.tsFileResourcesSortedByDesc) {
            if (!this.deviceIteratorMap.containsKey(resource) || !this.deviceIteratorMap.get(resource).current().equals(this.currentDevice)) continue;
            TsFileSequenceReader reader = this.readerMap.get(resource);
            for (Map.Entry entrySet : reader.getTimeseriesMetadataOffsetByDevice(this.deviceIteratorMap.get(resource).getFirstMeasurementNodeOfCurrentDevice(), timeseriesMetadataOffsetMap.keySet(), true).entrySet()) {
                String measurementId = (String)entrySet.getKey();
                if (!timeseriesMetadataOffsetMap.containsKey(measurementId)) {
                    MeasurementSchema schema = reader.getMeasurementSchema((List)((Pair)entrySet.getValue()).left);
                    timeseriesMetadataOffsetMap.put(measurementId, (Pair<MeasurementSchema, Map<TsFileResource, Pair<Long, Long>>>)new Pair((Object)schema, new HashMap()));
                }
                ((Map)((Pair)timeseriesMetadataOffsetMap.get((Object)measurementId)).right).put(resource, (Pair)((Pair)entrySet.getValue()).right);
            }
        }
        return timeseriesMetadataOffsetMap;
    }

    public MultiTsFileNonAlignedMeasurementMetadataListIterator iterateNotAlignedSeriesAndChunkMetadataListOfCurrentDevice() throws IOException {
        return new MultiTsFileNonAlignedMeasurementMetadataListIterator();
    }

    public LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>> getReaderAndChunkMetadataForCurrentAlignedSeries() throws IOException, IllegalPathException {
        if (this.currentDevice == null || !((Boolean)this.currentDevice.right).booleanValue()) {
            return new LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>>();
        }
        LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>> readerAndChunkMetadataList = new LinkedList<Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>>();
        for (TsFileResource tsFileResource : this.tsFileResourcesSortedByAsc) {
            TsFileDeviceIterator iterator;
            if (!this.deviceIteratorMap.containsKey(tsFileResource) || !this.currentDevice.equals((Object)(iterator = this.deviceIteratorMap.get(tsFileResource)).current())) continue;
            MetadataIndexNode firstMeasurementNodeOfCurrentDevice = iterator.getFirstMeasurementNodeOfCurrentDevice();
            TsFileSequenceReader reader = this.readerMap.get(tsFileResource);
            List alignedChunkMetadataList = reader.getAlignedChunkMetadataByMetadataIndexNode((IDeviceID)this.currentDevice.left, firstMeasurementNodeOfCurrentDevice);
            this.applyModificationForAlignedChunkMetadataList(tsFileResource, alignedChunkMetadataList);
            readerAndChunkMetadataList.add((Pair<TsFileSequenceReader, List<AlignedChunkMetadata>>)new Pair((Object)reader, (Object)alignedChunkMetadataList));
        }
        return readerAndChunkMetadataList;
    }

    private void applyModificationForAlignedChunkMetadataList(TsFileResource tsFileResource, List<AlignedChunkMetadata> alignedChunkMetadataList) throws IllegalPathException {
        if (alignedChunkMetadataList.isEmpty()) {
            return;
        }
        IDeviceID device = (IDeviceID)this.currentDevice.getLeft();
        Deletion ttlDeletion = null;
        Optional<Long> startTime = tsFileResource.getStartTime(device);
        if (startTime.isPresent() && startTime.get() < this.timeLowerBoundForCurrentDevice) {
            ttlDeletion = new Deletion(CompactionPathUtils.getPath(device, "*"), Long.MAX_VALUE, Long.MIN_VALUE, this.timeLowerBoundForCurrentDevice);
        }
        PatternTreeMap modifications = this.modificationCache.computeIfAbsent(tsFileResource, CompactionUtils::buildModEntryPatternTreeMap);
        AlignedChunkMetadata alignedChunkMetadata = alignedChunkMetadataList.get(0);
        List valueChunkMetadataList = alignedChunkMetadata.getValueChunkMetadataList();
        ArrayList<List<Modification>> modificationForCurDevice = new ArrayList<List<Modification>>();
        for (IChunkMetadata valueChunkMetadata : valueChunkMetadataList) {
            if (valueChunkMetadata == null) {
                modificationForCurDevice.add(Collections.emptyList());
                continue;
            }
            List<Modification> modificationList = CompactionUtils.getMatchedModifications((PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer>)modifications, device, valueChunkMetadata.getMeasurementUid(), ttlDeletion);
            modificationForCurDevice.add(modificationList.isEmpty() ? Collections.emptyList() : modificationList);
        }
        ModificationUtils.modifyAlignedChunkMetaData(alignedChunkMetadataList, modificationForCurDevice);
    }

    @Override
    public void close() throws IOException {
        for (TsFileSequenceReader reader : this.readerMap.values()) {
            reader.close();
        }
    }

    public class MultiTsFileNonAlignedMeasurementMetadataListIterator {
        private final LinkedList<String> seriesInThisIteration = new LinkedList();
        private final Map<TsFileSequenceReader, Map<String, List<ChunkMetadata>>> chunkMetadataCacheMap = new HashMap<TsFileSequenceReader, Map<String, List<ChunkMetadata>>>();
        private final Map<TsFileResource, Iterator<Map<String, List<ChunkMetadata>>>> chunkMetadataIteratorMap = new HashMap<TsFileResource, Iterator<Map<String, List<ChunkMetadata>>>>();
        private String currentCompactingSeries = null;
        private LinkedList<Pair<TsFileSequenceReader, List<ChunkMetadata>>> chunkMetadataMetadataListOfCurrentCompactingSeries;

        private MultiTsFileNonAlignedMeasurementMetadataListIterator() throws IOException {
            IDeviceID device = (IDeviceID)MultiTsFileDeviceIterator.this.currentDevice.getLeft();
            for (TsFileResource resource : MultiTsFileDeviceIterator.this.tsFileResourcesSortedByAsc) {
                TsFileDeviceIterator deviceIterator = (TsFileDeviceIterator)MultiTsFileDeviceIterator.this.deviceIteratorMap.get(resource);
                TsFileSequenceReader reader = (TsFileSequenceReader)MultiTsFileDeviceIterator.this.readerMap.get(resource);
                if (deviceIterator == null || !device.equals(deviceIterator.current().getLeft())) {
                    this.chunkMetadataIteratorMap.put(resource, new Iterator<Map<String, List<ChunkMetadata>>>(){

                        @Override
                        public boolean hasNext() {
                            return false;
                        }

                        @Override
                        public Map<String, List<ChunkMetadata>> next() {
                            return Collections.emptyMap();
                        }
                    });
                } else {
                    this.chunkMetadataIteratorMap.put(resource, reader.getMeasurementChunkMetadataListMapIterator(deviceIterator.getFirstMeasurementNodeOfCurrentDevice()));
                }
                this.chunkMetadataCacheMap.put(reader, new TreeMap());
            }
        }

        private boolean collectSeries() {
            String lastSeries = null;
            ArrayList<String> collectedSeries = new ArrayList<String>();
            for (TsFileResource resource : MultiTsFileDeviceIterator.this.tsFileResourcesSortedByAsc) {
                Map<String, List<ChunkMetadata>> batchMeasurementChunkMetadataList = this.getBatchMeasurementChunkMetadataListFromCache(resource);
                if (batchMeasurementChunkMetadataList.isEmpty()) continue;
                String maxSeriesOfCurrentBatch = Collections.max(batchMeasurementChunkMetadataList.keySet());
                if (lastSeries == null) {
                    lastSeries = maxSeriesOfCurrentBatch;
                } else if (maxSeriesOfCurrentBatch.compareTo(lastSeries) < 0) {
                    lastSeries = maxSeriesOfCurrentBatch;
                }
                collectedSeries.addAll(batchMeasurementChunkMetadataList.keySet());
            }
            if (collectedSeries.isEmpty()) {
                return false;
            }
            if (!this.hasRemainingSeries()) {
                lastSeries = (String)Collections.max(collectedSeries);
            }
            String finalLastSeries = lastSeries;
            this.seriesInThisIteration.addAll(collectedSeries.stream().filter(series -> series.compareTo(finalLastSeries) <= 0).sorted().distinct().collect(Collectors.toList()));
            return true;
        }

        private Map<String, List<ChunkMetadata>> getBatchMeasurementChunkMetadataListFromCache(TsFileResource resource) {
            TsFileSequenceReader reader = (TsFileSequenceReader)MultiTsFileDeviceIterator.this.readerMap.get(resource);
            Map<String, List<ChunkMetadata>> cachedBatchMeasurementChunkMetadataListMap = this.chunkMetadataCacheMap.get(reader);
            if (!cachedBatchMeasurementChunkMetadataListMap.isEmpty()) {
                return cachedBatchMeasurementChunkMetadataListMap;
            }
            Iterator<Map<String, List<ChunkMetadata>>> batchMeasurementChunkMetadataListIterator = this.chunkMetadataIteratorMap.get(resource);
            if (!batchMeasurementChunkMetadataListIterator.hasNext()) {
                return cachedBatchMeasurementChunkMetadataListMap;
            }
            Map<String, List<ChunkMetadata>> newBatchMeasurementChunkMetadataListMap = batchMeasurementChunkMetadataListIterator.next();
            newBatchMeasurementChunkMetadataListMap.remove("");
            this.chunkMetadataCacheMap.put(reader, newBatchMeasurementChunkMetadataListMap);
            return newBatchMeasurementChunkMetadataListMap;
        }

        private boolean hasRemainingSeries() {
            boolean remaining = false;
            for (Iterator<Map<String, List<ChunkMetadata>>> iterator : this.chunkMetadataIteratorMap.values()) {
                remaining = remaining || iterator.hasNext();
            }
            return remaining;
        }

        public boolean hasNextSeries() {
            return !this.seriesInThisIteration.isEmpty() || this.collectSeries();
        }

        public String nextSeries() throws IllegalPathException {
            if (!this.hasNextSeries()) {
                return null;
            }
            this.chunkMetadataMetadataListOfCurrentCompactingSeries = this.calculateMetadataListForCurrentSeries();
            return this.currentCompactingSeries;
        }

        public LinkedList<Pair<TsFileSequenceReader, List<ChunkMetadata>>> getMetadataListForCurrentSeries() {
            return this.chunkMetadataMetadataListOfCurrentCompactingSeries;
        }

        private LinkedList<Pair<TsFileSequenceReader, List<ChunkMetadata>>> calculateMetadataListForCurrentSeries() throws IllegalPathException {
            if (this.seriesInThisIteration.isEmpty()) {
                return new LinkedList<Pair<TsFileSequenceReader, List<ChunkMetadata>>>();
            }
            IDeviceID device = (IDeviceID)MultiTsFileDeviceIterator.this.currentDevice.getLeft();
            this.currentCompactingSeries = this.seriesInThisIteration.removeFirst();
            LinkedList<Pair<TsFileSequenceReader, List<ChunkMetadata>>> readerAndChunkMetadataForThisSeries = new LinkedList<Pair<TsFileSequenceReader, List<ChunkMetadata>>>();
            PartialPath path = CompactionPathUtils.getPath(device, this.currentCompactingSeries);
            for (TsFileResource resource : MultiTsFileDeviceIterator.this.tsFileResourcesSortedByAsc) {
                TsFileSequenceReader reader = (TsFileSequenceReader)MultiTsFileDeviceIterator.this.readerMap.get(resource);
                Map<String, List<ChunkMetadata>> chunkMetadataListMap = this.chunkMetadataCacheMap.get(reader);
                Deletion ttlDeletion = null;
                Optional<Long> startTime = resource.getStartTime(device);
                if (startTime.isPresent() && startTime.get() < MultiTsFileDeviceIterator.this.timeLowerBoundForCurrentDevice) {
                    ttlDeletion = new Deletion(CompactionPathUtils.getPath(device, "*"), Long.MAX_VALUE, Long.MIN_VALUE, MultiTsFileDeviceIterator.this.timeLowerBoundForCurrentDevice);
                }
                if (!chunkMetadataListMap.containsKey(this.currentCompactingSeries)) continue;
                List<ChunkMetadata> chunkMetadataListInThisResource = chunkMetadataListMap.get(this.currentCompactingSeries);
                chunkMetadataListMap.remove(this.currentCompactingSeries);
                PatternTreeMap modificationsInThisResource = MultiTsFileDeviceIterator.this.modificationCache.computeIfAbsent(resource, CompactionUtils::buildModEntryPatternTreeMap);
                List<Modification> modificationForCurrentSeries = CompactionUtils.getMatchedModifications((PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer>)modificationsInThisResource, device, this.currentCompactingSeries, ttlDeletion);
                if (!modificationForCurrentSeries.isEmpty()) {
                    ModificationUtils.modifyChunkMetaData(chunkMetadataListInThisResource, modificationForCurrentSeries);
                }
                readerAndChunkMetadataForThisSeries.add((Pair<TsFileSequenceReader, List<ChunkMetadata>>)new Pair((Object)reader, chunkMetadataListInThisResource));
            }
            return readerAndChunkMetadataForThisSeries;
        }
    }
}

