/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PatternTreeMap;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionPathUtils;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.iotdb.db.utils.datastructure.PatternTreeMapFactory;
import org.apache.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.utils.Pair;

public class ModificationUtils {
    private ModificationUtils() {
    }

    public static void modifyChunkMetaData(List<? extends IChunkMetadata> chunkMetaData, List<Modification> modifications) {
        for (IChunkMetadata iChunkMetadata : chunkMetaData) {
            for (Modification modification : modifications) {
                if (modification.getFileOffset() <= iChunkMetadata.getOffsetOfChunkHeader()) continue;
                ModificationUtils.doModifyChunkMetaData(modification, iChunkMetadata);
            }
        }
        chunkMetaData.removeIf(metaData -> {
            if (metaData.getDeleteIntervalList() != null) {
                for (TimeRange range : metaData.getDeleteIntervalList()) {
                    if (range.contains(metaData.getStartTime(), metaData.getEndTime())) {
                        return true;
                    }
                    if (!range.overlaps(new TimeRange(metaData.getStartTime(), metaData.getEndTime()))) continue;
                    metaData.setModified(true);
                }
            }
            return false;
        });
    }

    public static void modifyAlignedChunkMetaData(List<AlignedChunkMetadata> chunkMetaData, List<List<Modification>> modifications) {
        for (AlignedChunkMetadata metaData : chunkMetaData) {
            List valueChunkMetadataList = metaData.getValueChunkMetadataList();
            for (int i = 0; i < valueChunkMetadataList.size(); ++i) {
                IChunkMetadata v = (IChunkMetadata)valueChunkMetadataList.get(i);
                if (v == null) continue;
                List<Modification> modificationList = modifications.get(i);
                for (Modification modification : modificationList) {
                    if (modification.getFileOffset() <= v.getOffsetOfChunkHeader()) continue;
                    ModificationUtils.doModifyChunkMetaData(modification, v);
                }
            }
        }
        chunkMetaData.removeIf(alignedChunkMetadata -> {
            boolean removed = true;
            boolean modified = false;
            List valueChunkMetadataList = alignedChunkMetadata.getValueChunkMetadataList();
            for (int i = 0; i < valueChunkMetadataList.size(); ++i) {
                IChunkMetadata valueChunkMetadata = (IChunkMetadata)valueChunkMetadataList.get(i);
                if (valueChunkMetadata == null) continue;
                boolean currentRemoved = false;
                if (valueChunkMetadata.getDeleteIntervalList() != null) {
                    for (TimeRange range : valueChunkMetadata.getDeleteIntervalList()) {
                        if (range.contains(valueChunkMetadata.getStartTime(), valueChunkMetadata.getEndTime())) {
                            valueChunkMetadataList.set(i, null);
                            currentRemoved = true;
                            break;
                        }
                        if (!range.overlaps(new TimeRange(valueChunkMetadata.getStartTime(), valueChunkMetadata.getEndTime()))) continue;
                        valueChunkMetadata.setModified(true);
                        modified = true;
                    }
                }
                if (currentRemoved) continue;
                removed = false;
            }
            alignedChunkMetadata.setModified(modified);
            return removed;
        });
    }

    public static boolean isPointDeleted(long timestamp, List<TimeRange> deletionList, int[] deleteCursor) {
        return ModificationUtils.isPointDeleted(timestamp, deletionList, deleteCursor, Ordering.ASC);
    }

    public static boolean isPointDeleted(long timestamp, List<TimeRange> deletionList, int[] deleteCursor, Ordering ordering) {
        if (deleteCursor.length != 1) {
            throw new IllegalArgumentException("deleteCursor should be an array whose size is 1");
        }
        if (ordering.isAscending()) {
            while (deletionList != null && deleteCursor[0] < deletionList.size()) {
                if (deletionList.get(deleteCursor[0]).contains(timestamp)) {
                    return true;
                }
                if (deletionList.get(deleteCursor[0]).getMax() < timestamp) {
                    deleteCursor[0] = deleteCursor[0] + 1;
                    continue;
                }
                return false;
            }
        } else {
            while (deletionList != null && !deletionList.isEmpty() && deleteCursor[0] >= 0) {
                if (deletionList.get(deleteCursor[0]).contains(timestamp)) {
                    return true;
                }
                if (deletionList.get(deleteCursor[0]).getMin() >= timestamp) {
                    deleteCursor[0] = deleteCursor[0] - 1;
                    continue;
                }
                return false;
            }
        }
        return false;
    }

    public static boolean isPointDeletedWithoutOrderedRange(long timestamp, List<TimeRange> timeRangeList) {
        for (TimeRange range : timeRangeList) {
            if (!range.contains(timestamp)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPointDeleted(long timestamp, List<TimeRange> deletionList) {
        int[] deleteCursor = new int[]{0};
        return ModificationUtils.isPointDeleted(timestamp, deletionList, deleteCursor);
    }

    public static boolean isDeviceDeletedByMods(PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer> modifications, IDeviceID device, long startTime, long endTime) throws IllegalPathException {
        List mods = modifications.getOverlapped(CompactionPathUtils.getPath(device, ""));
        return mods.stream().anyMatch(modification -> ((Deletion)modification).getTimeRange().contains(startTime, endTime));
    }

    public static boolean isTimeSeriesDeletedByMods(PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer> modifications, IDeviceID device, String timeSeriesId, long startTime, long endTime) throws IllegalPathException {
        List mods = modifications.getOverlapped(CompactionPathUtils.getPath(device, timeSeriesId));
        return mods.stream().anyMatch(modification -> ((Deletion)modification).getTimeRange().contains(startTime, endTime));
    }

    private static void doModifyChunkMetaData(Modification modification, IChunkMetadata metaData) {
        if (modification instanceof Deletion) {
            Deletion deletion = (Deletion)modification;
            metaData.insertIntoSortedDeletions(deletion.getTimeRange());
        }
    }

    public static List<List<TimeRange>> constructDeletionList(AlignedPath partialPath, IMemTable memTable, List<Pair<Modification, IMemTable>> modsToMemtable, long timeLowerBound) {
        ArrayList<List<TimeRange>> deletionList = new ArrayList<List<TimeRange>>();
        for (String measurement : partialPath.getMeasurementList()) {
            ArrayList<TimeRange> columnDeletionList = new ArrayList<TimeRange>();
            columnDeletionList.add(new TimeRange(Long.MIN_VALUE, timeLowerBound));
            for (Modification modification : ModificationUtils.getModificationsForMemtable(memTable, modsToMemtable)) {
                if (!(modification instanceof Deletion)) continue;
                Deletion deletion = (Deletion)modification;
                PartialPath fullPath = partialPath.concatNode(measurement);
                if (!deletion.getPath().matchFullPath(fullPath) || deletion.getEndTime() <= timeLowerBound) continue;
                long lowerBound = Math.max(deletion.getStartTime(), timeLowerBound);
                columnDeletionList.add(new TimeRange(lowerBound, deletion.getEndTime()));
            }
            deletionList.add(TimeRange.sortAndMerge(columnDeletionList));
        }
        return deletionList;
    }

    public static List<TimeRange> constructDeletionList(MeasurementPath partialPath, IMemTable memTable, List<Pair<Modification, IMemTable>> modsToMemtable, long timeLowerBound) {
        ArrayList<TimeRange> deletionList = new ArrayList<TimeRange>();
        deletionList.add(new TimeRange(Long.MIN_VALUE, timeLowerBound));
        for (Modification modification : ModificationUtils.getModificationsForMemtable(memTable, modsToMemtable)) {
            Deletion deletion;
            if (!(modification instanceof Deletion) || !(deletion = (Deletion)modification).getPath().matchFullPath((PartialPath)partialPath) || deletion.getEndTime() <= timeLowerBound) continue;
            long lowerBound = Math.max(deletion.getStartTime(), timeLowerBound);
            deletionList.add(new TimeRange(lowerBound, deletion.getEndTime()));
        }
        return TimeRange.sortAndMerge(deletionList);
    }

    private static List<Modification> getModificationsForMemtable(IMemTable memTable, List<Pair<Modification, IMemTable>> modsToMemtable) {
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        boolean foundMemtable = false;
        for (Pair<Modification, IMemTable> entry : modsToMemtable) {
            if (!foundMemtable && !((IMemTable)entry.right).equals(memTable)) continue;
            modifications.add((Modification)entry.left);
            foundMemtable = true;
        }
        return modifications;
    }

    public static boolean isDeviceDeletedByMods(PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer> currentModifications, ITimeIndex currentTimeIndex, IDeviceID device) throws IllegalPathException {
        return ModificationUtils.isDeviceDeletedByMods(currentModifications, device, Objects.isNull(currentTimeIndex) ? Long.MIN_VALUE : currentTimeIndex.getStartTime(device).orElse(Long.MIN_VALUE), Objects.isNull(currentTimeIndex) ? Long.MAX_VALUE : currentTimeIndex.getEndTime(device).orElse(Long.MAX_VALUE));
    }
}

