import { EditorTheme } from "@kie-tools-core/editor/dist/api";
import { OperatingSystem } from "@kie-tools-core/operating-system";
import { editor } from "@kie-tools-core/monaco-editor";
export interface MonacoEditorApi {
    show: (container: HTMLDivElement, theme?: EditorTheme) => editor.IStandaloneCodeEditor;
    undo: () => void;
    redo: () => void;
    getContent: () => string;
    setTheme: (theme: EditorTheme) => void;
    forceRedraw: () => void;
    dispose: () => void;
}
export declare enum MonacoEditorOperation {
    UNDO = 0,
    REDO = 1,
    EDIT = 2
}
export interface MonacoEditorInstance {
    instance: editor.IStandaloneCodeEditor;
}
export declare class MonacoEditorController implements MonacoEditorApi {
    private readonly onContentChange;
    private readonly language;
    private readonly operatingSystem;
    private readonly isReadOnly;
    private readonly setValidationErrors;
    private readonly model;
    editor: editor.IStandaloneCodeEditor | undefined;
    constructor(content: string, onContentChange: (content: string, operation: MonacoEditorOperation) => void, language: string, operatingSystem: OperatingSystem | undefined, isReadOnly: boolean, setValidationErrors: (errors: editor.IMarker[]) => void);
    redo(): void;
    undo(): void;
    getValidationMarkers: () => editor.IMarker[];
    setTheme(theme: EditorTheme): void;
    show(container: HTMLDivElement, theme: EditorTheme): editor.IStandaloneCodeEditor;
    getContent(): string;
    forceRedraw(): void;
    private getMonacoThemeByEditorTheme;
    dispose(): void;
}
//# sourceMappingURL=MonacoEditorController.d.ts.map