import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback, useMemo, useState } from "react";
import { ContentField, DescriptionField, ExpressionLanguageField, NameField, TypeRefField } from "../Fields";
import { FormGroup, FormSection } from "@patternfly/react-core/dist/js/components/Form";
import { useDmnEditor } from "../../DmnEditorContext";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { PropertiesPanelHeader } from "../PropertiesPanelHeader";
import { useBoxedExpressionUpdater } from "./useBoxedExpressionUpdater";
import { ClipboardCopy } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { ConstraintsFromTypeConstraintAttribute } from "../../dataTypes/Constraints";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../../store/StoreContext";
import { useExternalModels } from "../../includedModels/DmnEditorDependenciesContext";
export function DecisionTableInputHeaderCell(props) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u;
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const selectedObjectId = useDmnEditorStore((s) => s.boxedExpressionEditor.selectedObjectId);
    const { externalModelsByNamespace } = useExternalModels();
    const { dmnEditorRootElementRef } = useDmnEditor();
    const selectedObjectInfos = useMemo(() => { var _a; return (_a = props.boxedExpressionIndex) === null || _a === void 0 ? void 0 : _a.get(selectedObjectId !== null && selectedObjectId !== void 0 ? selectedObjectId : ""); }, [props.boxedExpressionIndex, selectedObjectId]);
    const updater = useBoxedExpressionUpdater((_a = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _a !== void 0 ? _a : []);
    const cell = useMemo(() => selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell, [selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell]);
    const inputExpression = useMemo(() => cell.inputExpression, [cell.inputExpression]);
    const inputValues = useMemo(() => cell.inputValues, [cell.inputValues]);
    const inputExpressionItemDefinition = useMemo(() => {
        var _a, _b, _c;
        const { allDataTypesById, allTopLevelItemDefinitionUniqueNames } = dmnEditorStoreApi
            .getState()
            .computed(dmnEditorStoreApi.getState())
            .getDataTypes(externalModelsByNamespace);
        return (_c = allDataTypesById.get((_b = allTopLevelItemDefinitionUniqueNames.get((_a = inputExpression === null || inputExpression === void 0 ? void 0 : inputExpression["@_typeRef"]) !== null && _a !== void 0 ? _a : "")) !== null && _b !== void 0 ? _b : "")) === null || _c === void 0 ? void 0 : _c.itemDefinition;
    }, [dmnEditorStoreApi, externalModelsByNamespace, inputExpression]);
    const [isInputExpressionExpanded, setInputExpressionExpanded] = useState(true);
    const [isInputValuesExpanded, setInputValuesExpanded] = useState(false);
    const getAllUniqueNames = useCallback((s) => new Map(), []);
    return (_jsxs(_Fragment, { children: [_jsx(FormGroup, { label: "ID", children: _jsx(ClipboardCopy, { isReadOnly: true, hoverTip: "Copy", clickTip: "Copied", children: selectedObjectId }) }), _jsx(DescriptionField, { isReadOnly: props.isReadOnly, expressionPath: (_b = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _b !== void 0 ? _b : [], initialValue: (_d = (_c = cell === null || cell === void 0 ? void 0 : cell.description) === null || _c === void 0 ? void 0 : _c.__$$text) !== null && _d !== void 0 ? _d : "", onChange: (newDescription) => updater((dmnObject) => {
                    var _a;
                    (_a = dmnObject.description) !== null && _a !== void 0 ? _a : (dmnObject.description = { __$$text: "" });
                    dmnObject.description.__$$text = newDescription;
                }) }), _jsxs(FormSection, { children: [_jsx(PropertiesPanelHeader, { expands: true, fixed: false, isSectionExpanded: isInputExpressionExpanded, toogleSectionExpanded: () => setInputExpressionExpanded((prev) => !prev), title: "Input Expression" }), isInputExpressionExpanded && (_jsxs(_Fragment, { children: [_jsx(NameField, { id: inputExpression["@_id"], isReadOnly: props.isReadOnly, name: (_f = (_e = inputExpression === null || inputExpression === void 0 ? void 0 : inputExpression.text) === null || _e === void 0 ? void 0 : _e.__$$text) !== null && _f !== void 0 ? _f : "", getAllUniqueNames: getAllUniqueNames, onChange: (newName) => updater((dmnObject) => {
                                    var _a, _b;
                                    var _c;
                                    (_a = dmnObject.inputExpression) !== null && _a !== void 0 ? _a : (dmnObject.inputExpression = { "@_id": generateUuid() });
                                    (_b = (_c = dmnObject.inputExpression).text) !== null && _b !== void 0 ? _b : (_c.text = { __$$text: "" });
                                    dmnObject.inputExpression.text.__$$text = newName;
                                }) }), _jsx(TypeRefField, { isReadOnly: props.isReadOnly, dmnEditorRootElementRef: dmnEditorRootElementRef, typeRef: inputExpression === null || inputExpression === void 0 ? void 0 : inputExpression["@_typeRef"], onChange: (newTypeRef) => updater((dmnObject) => {
                                    var _a, _b;
                                    (_a = dmnObject.inputExpression) !== null && _a !== void 0 ? _a : (dmnObject.inputExpression = { "@_id": generateUuid() });
                                    dmnObject.inputExpression["@_typeRef"] = newTypeRef;
                                    (_b = dmnObject.inputValues) !== null && _b !== void 0 ? _b : (dmnObject.inputValues = { "@_id": generateUuid(), text: { __$$text: "" } });
                                    dmnObject.inputValues["@_typeRef"] = newTypeRef;
                                }) }), inputExpressionItemDefinition && (_jsx(FormGroup, { label: "Constraint", children: _jsx(ConstraintsFromTypeConstraintAttribute, { isReadOnly: true, itemDefinition: inputExpressionItemDefinition, editItemDefinition: () => { }, renderOnPropertiesPanel: true, defaultsToAllowedValues: true }) })), _jsx(ExpressionLanguageField, { isReadOnly: props.isReadOnly, initialValue: (_g = inputExpression === null || inputExpression === void 0 ? void 0 : inputExpression["@_expressionLanguage"]) !== null && _g !== void 0 ? _g : "", expressionPath: (_h = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _h !== void 0 ? _h : [], onChange: (newExpressionLanguage) => updater((dmnObject) => {
                                    var _a;
                                    (_a = dmnObject.inputExpression) !== null && _a !== void 0 ? _a : (dmnObject.inputExpression = { "@_id": generateUuid() });
                                    dmnObject.inputExpression["@_expressionLanguage"] = newExpressionLanguage;
                                }) }), _jsx(DescriptionField, { isReadOnly: props.isReadOnly, initialValue: (_k = (_j = inputExpression === null || inputExpression === void 0 ? void 0 : inputExpression.description) === null || _j === void 0 ? void 0 : _j.__$$text) !== null && _k !== void 0 ? _k : "", expressionPath: (_l = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _l !== void 0 ? _l : [], onChange: (newDescription) => updater((dmnObject) => {
                                    var _a, _b;
                                    var _c;
                                    (_a = dmnObject.inputExpression) !== null && _a !== void 0 ? _a : (dmnObject.inputExpression = { "@_id": generateUuid() });
                                    (_b = (_c = dmnObject.inputExpression).description) !== null && _b !== void 0 ? _b : (_c.description = { __$$text: "" });
                                    dmnObject.inputExpression.description.__$$text = newDescription;
                                }) })] }))] }), _jsxs(FormSection, { children: [_jsx(PropertiesPanelHeader, { expands: true, fixed: false, isSectionExpanded: isInputValuesExpanded, toogleSectionExpanded: () => setInputValuesExpanded((prev) => !prev), title: "Input Values" }), isInputValuesExpanded && (_jsxs(_Fragment, { children: [_jsx(ExpressionLanguageField, { isReadOnly: props.isReadOnly, initialValue: (_m = inputValues === null || inputValues === void 0 ? void 0 : inputValues["@_expressionLanguage"]) !== null && _m !== void 0 ? _m : "", expressionPath: (_o = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _o !== void 0 ? _o : [], onChange: (newExpressionLanguage) => updater((dmnObject) => {
                                    var _a;
                                    (_a = dmnObject.inputValues) !== null && _a !== void 0 ? _a : (dmnObject.inputValues = { "@_id": generateUuid(), text: { __$$text: "" } });
                                    dmnObject.inputValues["@_expressionLanguage"] = newExpressionLanguage;
                                }) }), _jsx(ContentField, { isReadOnly: props.isReadOnly, initialValue: (_q = (_p = inputValues === null || inputValues === void 0 ? void 0 : inputValues.text) === null || _p === void 0 ? void 0 : _p.__$$text) !== null && _q !== void 0 ? _q : "", expressionPath: (_r = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _r !== void 0 ? _r : [], onChange: (newText) => updater((dmnObject) => {
                                    var _a, _b;
                                    var _c;
                                    (_a = dmnObject.inputValues) !== null && _a !== void 0 ? _a : (dmnObject.inputValues = { "@_id": generateUuid(), text: { __$$text: "" } });
                                    (_b = (_c = dmnObject.inputValues).text) !== null && _b !== void 0 ? _b : (_c.text = { __$$text: "" });
                                    dmnObject.inputValues.text.__$$text = newText;
                                }) }), _jsx(DescriptionField, { isReadOnly: props.isReadOnly, initialValue: (_t = (_s = inputValues === null || inputValues === void 0 ? void 0 : inputValues.description) === null || _s === void 0 ? void 0 : _s.__$$text) !== null && _t !== void 0 ? _t : "", expressionPath: (_u = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _u !== void 0 ? _u : [], onChange: (newDescription) => updater((dmnObject) => {
                                    var _a, _b;
                                    var _c;
                                    (_a = dmnObject.inputValues) !== null && _a !== void 0 ? _a : (dmnObject.inputValues = { "@_id": generateUuid(), text: { __$$text: "" } });
                                    (_b = (_c = dmnObject.inputValues).description) !== null && _b !== void 0 ? _b : (_c.description = { __$$text: "" });
                                    dmnObject.inputValues.description.__$$text = newDescription;
                                }) })] }))] })] }));
}
//# sourceMappingURL=DecisionTableInputHeaderCell.js.map