import { addOrGetDrd } from "./addOrGetDrd";
export function repositionEdgeWaypoint({ definitions, drdIndex, edgeIndex, waypointIndex, waypoint, }) {
    var _a, _b;
    const { diagramElements } = addOrGetDrd({ definitions, drdIndex });
    const diagramElement = diagramElements[edgeIndex];
    if (diagramElement.__$$element !== "dmndi:DMNEdge") {
        throw new Error("DMN MUTATION: Can't remove a waypoint from an element that is not a DMNEdge.");
    }
    if (waypointIndex > ((_b = (_a = diagramElement["di:waypoint"]) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0) - 1) {
        throw new Error(`DMN MUTATION: Can't reposition waypoint with index '${waypointIndex}' from DMNEdge '${diagramElement["@_id"]}' because it doesn't exist.`);
    }
    diagramElement["di:waypoint"][waypointIndex] = waypoint;
}
//# sourceMappingURL=repositionEdgeWaypoint.js.map