import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { buildXmlHref } from "@kie-tools/dmn-marshaller/dist/xml/xmlHrefs";
import { AutoPositionedEdgeMarker } from "../diagram/edges/AutoPositionedEdgeMarker";
import { EDGE_TYPES } from "../diagram/edges/EdgeTypes";
import { getDmnBoundsCenterPoint } from "../diagram/maths/DmnMaths";
import { NODE_TYPES } from "../diagram/nodes/NodeTypes";
import { switchExpression } from "@kie-tools-core/switch-expression-ts";
import { NodeNature, nodeNatures } from "./NodeNature";
import { addOrGetDrd } from "./addOrGetDrd";
import { getCentralizedDecisionServiceDividerLine } from "./updateDecisionServiceDividerLine";
import { repopulateInputDataAndDecisionsOnAllDecisionServices } from "./repopulateInputDataAndDecisionsOnDecisionService";
export function addConnectedNode({ definitions, drdIndex, sourceNode, newNode, edgeType, externalModelsByNamespace, }) {
    var _a, _b, _c, _d;
    const newDmnObjectId = generateUuid();
    const newDmnObjectHref = buildXmlHref({ id: newDmnObjectId });
    const newEdgeId = generateUuid();
    const nature = nodeNatures[newNode.type];
    if (nature === NodeNature.DRG_ELEMENT) {
        const requirements = getRequirementsFromEdge(sourceNode, newEdgeId, edgeType);
        (_a = definitions.drgElement) !== null && _a !== void 0 ? _a : (definitions.drgElement = []);
        const variableBase = {
            "@_id": generateUuid(),
            "@_typeRef": undefined,
        };
        (_b = definitions.drgElement) === null || _b === void 0 ? void 0 : _b.push(switchExpression(newNode.type, {
            [NODE_TYPES.bkm]: {
                __$$element: "businessKnowledgeModel",
                "@_name": "New BKM",
                "@_id": newDmnObjectId,
                ...requirements,
                variable: {
                    ...variableBase,
                    "@_name": "New BKM",
                },
            },
            [NODE_TYPES.decision]: {
                __$$element: "decision",
                "@_name": "New Decision",
                "@_id": newDmnObjectId,
                ...requirements,
                variable: {
                    ...variableBase,
                    "@_name": "New Decision",
                },
            },
            [NODE_TYPES.decisionService]: {
                __$$element: "decisionService",
                "@_name": "New Decision Service",
                "@_id": newDmnObjectId,
                ...requirements,
                variable: {
                    ...variableBase,
                    "@_name": "New Decision Service",
                },
            },
            [NODE_TYPES.inputData]: {
                __$$element: "inputData",
                "@_name": "New Input Data",
                "@_id": newDmnObjectId,
                ...requirements,
                variable: {
                    ...variableBase,
                    "@_name": "New Input Data",
                },
            },
            [NODE_TYPES.knowledgeSource]: {
                __$$element: "knowledgeSource",
                "@_name": "New Knowledge Source",
                "@_id": newDmnObjectId,
                ...requirements,
            },
        }));
    }
    else if (nature === NodeNature.ARTIFACT) {
        (_c = definitions.artifact) !== null && _c !== void 0 ? _c : (definitions.artifact = []);
        (_d = definitions.artifact) === null || _d === void 0 ? void 0 : _d.push(...switchExpression(newNode.type, {
            [NODE_TYPES.textAnnotation]: [
                {
                    "@_id": newDmnObjectId,
                    __$$element: "textAnnotation",
                    text: { __$$text: "New text annotation" },
                },
                {
                    "@_id": newEdgeId,
                    __$$element: "association",
                    "@_associationDirection": "Both",
                    sourceRef: { "@_href": `${sourceNode.href}` },
                    targetRef: { "@_href": `${newDmnObjectHref}` },
                },
            ],
            [NODE_TYPES.group]: [
                {
                    "@_id": newDmnObjectId,
                    __$$element: "group",
                    "@_name": "New group",
                },
            ],
        }));
    }
    else {
        throw new Error(`DMN MUTATION: Unknown node usage '${nature}'.`);
    }
    const newShapeId = generateUuid();
    const { diagramElements } = addOrGetDrd({ definitions, drdIndex });
    diagramElements === null || diagramElements === void 0 ? void 0 : diagramElements.push({
        __$$element: "dmndi:DMNShape",
        "@_id": newShapeId,
        "@_dmnElementRef": newDmnObjectId,
        "@_isCollapsed": false,
        "@_isListedInputData": false,
        "dc:Bounds": newNode.bounds,
        ...(newNode.type === NODE_TYPES.decisionService
            ? { "dmndi:DMNDecisionServiceDividerLine": getCentralizedDecisionServiceDividerLine(newNode.bounds) }
            : {}),
    });
    diagramElements === null || diagramElements === void 0 ? void 0 : diagramElements.push({
        __$$element: "dmndi:DMNEdge",
        "@_id": generateUuid() + AutoPositionedEdgeMarker.TARGET,
        "@_dmnElementRef": newEdgeId,
        "@_sourceElement": sourceNode.shapeId,
        "@_targetElement": newShapeId,
        "di:waypoint": [getDmnBoundsCenterPoint(sourceNode.bounds), getDmnBoundsCenterPoint(newNode.bounds)],
    });
    repopulateInputDataAndDecisionsOnAllDecisionServices({ definitions, externalModelsByNamespace });
    return { id: newDmnObjectId, href: newDmnObjectHref };
}
export function getRequirementsFromEdge(sourceNode, newEdgeId, edge) {
    const ir = switchExpression(sourceNode.type, {
        [NODE_TYPES.inputData]: { "@_id": newEdgeId, requiredInput: { "@_href": `${sourceNode.href}` } },
        [NODE_TYPES.decision]: { "@_id": newEdgeId, requiredDecision: { "@_href": `${sourceNode.href}` } },
        default: undefined,
    });
    const kr = switchExpression(sourceNode.type, {
        [NODE_TYPES.bkm]: { "@_id": newEdgeId, requiredKnowledge: { "@_href": `${sourceNode.href}` } },
        [NODE_TYPES.decisionService]: { "@_id": newEdgeId, requiredKnowledge: { "@_href": `${sourceNode.href}` } },
        default: undefined,
    });
    const ar = switchExpression(sourceNode.type, {
        [NODE_TYPES.inputData]: { "@_id": newEdgeId, requiredInput: { "@_href": `${sourceNode.href}` } },
        [NODE_TYPES.decision]: { "@_id": newEdgeId, requiredDecision: { "@_href": `${sourceNode.href}` } },
        [NODE_TYPES.knowledgeSource]: { "@_id": newEdgeId, requiredAuthority: { "@_href": `${sourceNode.href}` } },
        default: undefined,
    });
    const requirements = switchExpression(edge, {
        [EDGE_TYPES.informationRequirement]: ir ? { informationRequirement: [ir] } : undefined,
        [EDGE_TYPES.knowledgeRequirement]: kr ? { knowledgeRequirement: [kr] } : undefined,
        [EDGE_TYPES.authorityRequirement]: ar ? { authorityRequirement: [ar] } : undefined,
        default: undefined,
    });
    return requirements;
}
//# sourceMappingURL=addConnectedNode.js.map