import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useCallback, useEffect, useRef, useState } from "react";
import { useGlobals } from "../common/GlobalContext";
import { useChromeExtensionI18n } from "../../i18n";
export const ALERT_AUTO_CLOSE_TIMEOUT = 3000;
export function SingleEditorToolbar(props) {
    const globals = useGlobals();
    const [copyLinkSuccessAlertVisible, setCopyLinkSuccessAlertVisible] = useState(false);
    const linkToExternalEditorTextAreaRef = useRef(null);
    const copyLinkSuccessAlertRef = useRef(null);
    const { i18n } = useChromeExtensionI18n();
    const { onFullScreen, onSeeAsSource, onSeeAsDiagram, onOpenInExternalEditor } = props;
    const goFullScreen = useCallback((e) => {
        e.preventDefault();
        onFullScreen();
    }, [onFullScreen]);
    const seeAsSource = useCallback((e) => {
        e.preventDefault();
        onSeeAsSource();
    }, [onSeeAsSource]);
    const seeAsDiagram = useCallback((e) => {
        e.preventDefault();
        onSeeAsDiagram();
    }, [onSeeAsDiagram]);
    const openInExternalEditor = useCallback((e) => {
        e.preventDefault();
        onOpenInExternalEditor === null || onOpenInExternalEditor === void 0 ? void 0 : onOpenInExternalEditor();
    }, [onOpenInExternalEditor]);
    const copyLinkToExternalEditor = useCallback((e) => {
        var _a;
        e.preventDefault();
        (_a = linkToExternalEditorTextAreaRef.current) === null || _a === void 0 ? void 0 : _a.select();
        if (document.execCommand("copy")) {
            setCopyLinkSuccessAlertVisible(true);
        }
        e.target.focus();
    }, []);
    const closeCopyLinkSuccessAlert = useCallback(() => {
        setCopyLinkSuccessAlertVisible(false);
    }, []);
    useEffect(() => {
        if (closeCopyLinkSuccessAlert) {
            const autoCloseCopyLinkSuccessAlert = setTimeout(closeCopyLinkSuccessAlert, ALERT_AUTO_CLOSE_TIMEOUT);
            return () => clearInterval(autoCloseCopyLinkSuccessAlert);
        }
        return () => {
        };
    }, [closeCopyLinkSuccessAlert, copyLinkSuccessAlertVisible]);
    return (_jsxs(_Fragment, { children: [_jsxs("div", { style: { display: "flex" }, children: [_jsx("textarea", { ref: linkToExternalEditorTextAreaRef, defaultValue: props.linkToExternalEditor, style: { opacity: 0, width: 0, height: 0 } }), !props.textMode && (_jsx("button", { "data-testid": "go-fullscreen-button", className: "btn d-none d-md-inline-block kogito-button", onClick: goFullScreen, children: i18n.fullScreen })), !props.textMode && (_jsx("button", { "data-testid": "see-as-source-button", disabled: !props.textModeAvailable, className: "btn d-none d-md-inline-block kogito-button", onClick: seeAsSource, children: i18n.single.editorToolbar.seeAsSource })), props.textMode && (_jsx("button", { "data-testid": "see-as-diagram-button", className: "btn d-none d-md-inline-block kogito-button", onClick: seeAsDiagram, children: i18n.seeAsDiagram })), globals.externalEditorManager && props.onOpenInExternalEditor && (_jsx("button", { "data-testid": "open-ext-editor-button", className: "btn d-none d-md-inline-block kogito-button", onClick: openInExternalEditor, children: i18n.openIn(globals.externalEditorManager.name) })), globals.externalEditorManager && props.linkToExternalEditor && (_jsxs("div", { className: "position-relative", children: [_jsx("button", { "data-testid": "copy-link-button", className: "btn d-none d-md-inline-block kogito-button", onClick: copyLinkToExternalEditor, children: i18n.single.editorToolbar.copyLinkTo(globals.externalEditorManager.name) }), copyLinkSuccessAlertVisible && (_jsx("div", { "data-testid": "link-copied-alert", ref: copyLinkSuccessAlertRef, className: "position-absolute", style: { marginTop: "34px", right: "0" }, children: _jsx("div", { className: "dropdown-menu dropdown-menu-sw kogito-github-action-alert", children: _jsx("span", { children: i18n.single.editorToolbar.linkCopied }) }) }))] }))] }), !props.errorOpeningFile && props.readonly && !props.textMode && (_jsx("div", { style: { height: "32px", padding: "5px 15px 5px 15px", whiteSpace: "nowrap" }, className: "flash flash-info", children: _jsx("h5", { children: i18n.single.editorToolbar.readOnly }) })), props.errorOpeningFile && props.textMode && !props.readonly && (_jsx("div", { style: { height: "32px", padding: "5px 15px 5px 15px", whiteSpace: "nowrap" }, className: "flash flash-info", children: _jsxs("h5", { children: [i18n.single.editorToolbar.fixAndSeeAsDiagram, "\u00A0", props.textModeAvailable && (_jsxs(_Fragment, { children: [_jsx("a", { href: "#", onClick: seeAsDiagram, children: i18n.seeAsDiagram }), "."] }))] }) })), props.errorOpeningFile && !props.textMode && (_jsx("div", { style: { height: "32px", padding: "5px 15px 5px 15px", whiteSpace: "nowrap" }, className: "flash flash-error", children: _jsxs("h5", { children: [i18n.single.editorToolbar.errorOpeningFile, "\u00A0", props.textModeAvailable && (_jsxs(_Fragment, { children: [_jsx("a", { href: "#", onClick: seeAsSource, children: i18n.single.editorToolbar.seeAsSource }), "."] }))] }) }))] }));
}
//# sourceMappingURL=SingleEditorToolbar.js.map