import { Wrapped } from "./Wrapped";
export interface I18nDefaults<D extends ReferenceDictionary> {
    locale: string;
    dictionary: D;
}
export type I18nDictionaries<D extends ReferenceDictionary> = Map<string, TranslatedDictionary<D>>;
export type DictionaryInterpolation = (...args: Array<string | number>) => string;
export type ReferenceDictionary = {
    [k: string]: string | DictionaryInterpolation | Array<string | number | Wrapped<string>> | ReferenceDictionary;
};
export type TranslatedDictionary<D extends ReferenceDictionary> = DeepOptional<D>;
type DeepOptional<D> = {
    [K in keyof D]?: DeepOptional<D[K]>;
};
export {};
//# sourceMappingURL=Dictionary.d.ts.map