"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServerlessWorkflowCombinedEditor = void 0;
var jsx_runtime_1 = require("react/jsx-runtime");
var api_1 = require("@kie-tools-core/editor/dist/api");
var embedded_1 = require("@kie-tools-core/editor/dist/embedded");
var envelope_1 = require("@kie-tools-core/editor/dist/envelope");
var hooks_1 = require("@kie-tools-core/envelope-bus/dist/hooks");
var ServerlessWorkflowStunnerEditor_1 = require("@kie-tools/serverless-workflow-diagram-editor-envelope/dist/envelope/ServerlessWorkflowStunnerEditor");
var Drawer_1 = require("@patternfly/react-core/dist/js/components/Drawer");
var path_browserify_1 = require("path-browserify");
var react_1 = require("react");
var useSwfDiagramEditorChannelApi_1 = require("./hooks/useSwfDiagramEditorChannelApi");
var useSwfTextEditorChannelApi_1 = require("./hooks/useSwfTextEditorChannelApi");
var ColorNodes_1 = require("./helpers/ColorNodes");
require("./styles.scss");
var ENVELOPE_LOCATOR_TYPE = "swf";
var RefForwardingServerlessWorkflowCombinedEditor = function (props, forwardedRef) {
    var _a, _b, _c;
    var onStateControlCommandUpdate = props.onStateControlCommandUpdate, onNewEdit = props.onNewEdit;
    var _d = __read((0, react_1.useState)(undefined), 2), file = _d[0], setFile = _d[1];
    var _e = __read((0, react_1.useState)(), 2), embeddedTextEditorFile = _e[0], setEmbeddedTextEditorFile = _e[1];
    var _f = __read((0, react_1.useState)(), 2), embeddedDiagramEditorFile = _f[0], setEmbeddedDiagramEditorFile = _f[1];
    var editorEnvelopeCtx = (0, api_1.useKogitoEditorEnvelopeContext)();
    var _g = __read((0, hooks_1.useSharedValue)(editorEnvelopeCtx.channelApi.shared.kogitoSwfGetDiagramEditorEnvelopeContent), 1), diagramEditorEnvelopeContent = _g[0];
    var _h = __read((0, hooks_1.useSharedValue)(editorEnvelopeCtx.channelApi.shared.kogitoSwfGetTextEditorEnvelopeContent), 1), textEditorEnvelopeContent = _h[0];
    var _j = (0, embedded_1.useEditorRef)(), textEditor = _j.editor, textEditorRef = _j.editorRef;
    var _k = (0, embedded_1.useEditorRef)(), diagramEditor = _k.editor, diagramEditorRef = _k.editorRef;
    var _l = __read((0, hooks_1.useSharedValue)((_a = editorEnvelopeCtx.channelApi) === null || _a === void 0 ? void 0 : _a.shared.kogitoEditor_theme), 1), theme = _l[0];
    var _m = __read((0, hooks_1.useSharedValue)((_b = editorEnvelopeCtx.channelApi) === null || _b === void 0 ? void 0 : _b.shared.kogitoSwfPreviewOptions_get), 1), previewOptions = _m[0];
    var lastContent = (0, react_1.useRef)();
    var _o = __read((0, react_1.useState)(false), 2), isTextEditorReady = _o[0], setTextEditorReady = _o[1];
    var _p = __read((0, react_1.useState)(false), 2), isDiagramEditorReady = _p[0], setDiagramEditorReady = _p[1];
    var isVscode = (0, react_1.useMemo)(function () { return props.channelType === api_1.ChannelType.VSCODE_DESKTOP || props.channelType === api_1.ChannelType.VSCODE_WEB; }, [props.channelType]);
    var isStandalone = (0, react_1.useMemo)(function () { return props.channelType === api_1.ChannelType.STANDALONE; }, [props.channelType]);
    var targetOrigin = (0, react_1.useMemo)(function () { return (isVscode ? "vscode" : window.location.origin); }, [isVscode]);
    var applyEditorTheme = (0, react_1.useCallback)(function (theme) { return Promise.all([textEditor === null || textEditor === void 0 ? void 0 : textEditor.setTheme(theme), diagramEditor === null || diagramEditor === void 0 ? void 0 : diagramEditor.setTheme(theme)]); }, [textEditor, diagramEditor]);
    (0, react_1.useEffect)(function () {
        if (theme === undefined) {
            return;
        }
        applyEditorTheme(theme);
    }, [theme, applyEditorTheme]);
    var isCombinedEditorReady = (0, react_1.useMemo)(function () {
        if ((previewOptions === null || previewOptions === void 0 ? void 0 : previewOptions.editorMode) === "diagram") {
            return isDiagramEditorReady;
        }
        else if ((previewOptions === null || previewOptions === void 0 ? void 0 : previewOptions.editorMode) === "text") {
            return isTextEditorReady;
        }
        else {
            return isTextEditorReady && isDiagramEditorReady;
        }
    }, [isDiagramEditorReady, isTextEditorReady, previewOptions]);
    var buildEnvelopeContent = (0, react_1.useCallback)(function (content, path) {
        if (isStandalone) {
            return {
                type: api_1.EnvelopeContentType.CONTENT,
                content: content,
            };
        }
        else {
            return {
                type: api_1.EnvelopeContentType.PATH,
                path: path,
            };
        }
    }, [isStandalone]);
    var textEditorEnvelopeLocator = (0, react_1.useMemo)(function () {
        return new api_1.EditorEnvelopeLocator(targetOrigin, [
            new api_1.EnvelopeMapping({
                type: ENVELOPE_LOCATOR_TYPE,
                filePathGlob: "**/*.sw.+(json|yml|yaml)",
                resourcesPathPrefix: props.resourcesPathPrefix + "/text",
                envelopeContent: buildEnvelopeContent(textEditorEnvelopeContent !== null && textEditorEnvelopeContent !== void 0 ? textEditorEnvelopeContent : "", props.resourcesPathPrefix + "/serverless-workflow-text-editor-envelope.html"),
            }),
        ]);
    }, [props.resourcesPathPrefix, targetOrigin, textEditorEnvelopeContent, buildEnvelopeContent]);
    var diagramEditorEnvelopeLocator = (0, react_1.useMemo)(function () {
        return new api_1.EditorEnvelopeLocator(targetOrigin, [
            new api_1.EnvelopeMapping({
                type: ENVELOPE_LOCATOR_TYPE,
                filePathGlob: "**/*.sw.+(json|yml|yaml)",
                resourcesPathPrefix: props.resourcesPathPrefix + "/diagram",
                envelopeContent: buildEnvelopeContent(diagramEditorEnvelopeContent !== null && diagramEditorEnvelopeContent !== void 0 ? diagramEditorEnvelopeContent : "", props.resourcesPathPrefix + "/serverless-workflow-diagram-editor-envelope.html"),
            }),
        ]);
    }, [props.resourcesPathPrefix, targetOrigin, diagramEditorEnvelopeContent, buildEnvelopeContent]);
    var textEditorEnvelopeApi = (0, react_1.useMemo)(function () {
        return textEditor &&
            textEditor.getEnvelopeServer()
                .envelopeApi;
    }, [textEditor]);
    (0, react_1.useImperativeHandle)(forwardedRef, function () {
        return {
            setContent: function (normalizedPosixPathRelativeToTheWorkspaceRoot, content) { return __awaiter(void 0, void 0, void 0, function () {
                var match, dotExtension, extension, fileName, getFileContentsFn;
                return __generator(this, function (_a) {
                    try {
                        match = /\.sw\.(json|yml|yaml)$/.exec(normalizedPosixPathRelativeToTheWorkspaceRoot.toLowerCase());
                        dotExtension = match ? match[0] : (0, path_browserify_1.extname)(normalizedPosixPathRelativeToTheWorkspaceRoot);
                        extension = dotExtension.slice(1);
                        fileName = (0, path_browserify_1.basename)(normalizedPosixPathRelativeToTheWorkspaceRoot);
                        getFileContentsFn = function () { return __awaiter(void 0, void 0, void 0, function () { return __generator(this, function (_a) {
                            return [2, content];
                        }); }); };
                        setFile({ content: content, path: normalizedPosixPathRelativeToTheWorkspaceRoot });
                        setEmbeddedTextEditorFile({
                            normalizedPosixPathRelativeToTheWorkspaceRoot: normalizedPosixPathRelativeToTheWorkspaceRoot,
                            getFileContents: getFileContentsFn,
                            isReadOnly: props.isReadOnly,
                            fileExtension: extension,
                            fileName: fileName,
                        });
                        setEmbeddedDiagramEditorFile({
                            normalizedPosixPathRelativeToTheWorkspaceRoot: normalizedPosixPathRelativeToTheWorkspaceRoot,
                            getFileContents: getFileContentsFn,
                            isReadOnly: true,
                            fileExtension: extension,
                            fileName: fileName,
                        });
                    }
                    catch (e) {
                        console.error(e);
                        throw e;
                    }
                    return [2];
                });
            }); },
            getContent: function () { return __awaiter(void 0, void 0, void 0, function () { var _a; return __generator(this, function (_b) {
                return [2, (_a = file === null || file === void 0 ? void 0 : file.content) !== null && _a !== void 0 ? _a : ""];
            }); }); },
            getPreview: function () { return __awaiter(void 0, void 0, void 0, function () { var _a; return __generator(this, function (_b) {
                return [2, (_a = diagramEditor === null || diagramEditor === void 0 ? void 0 : diagramEditor.getPreview()) !== null && _a !== void 0 ? _a : ""];
            }); }); },
            undo: function () { return __awaiter(void 0, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0: return [4, Promise.all([textEditor === null || textEditor === void 0 ? void 0 : textEditor.undo(), diagramEditor === null || diagramEditor === void 0 ? void 0 : diagramEditor.undo()])];
                        case 1:
                            _a.sent();
                            return [2];
                    }
                });
            }); },
            redo: function () { return __awaiter(void 0, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    switch (_a.label) {
                        case 0: return [4, Promise.all([textEditor === null || textEditor === void 0 ? void 0 : textEditor.redo(), diagramEditor === null || diagramEditor === void 0 ? void 0 : diagramEditor.redo()])];
                        case 1:
                            _a.sent();
                            return [2];
                    }
                });
            }); },
            validate: function () { return __awaiter(void 0, void 0, void 0, function () { var _a; return __generator(this, function (_b) {
                return [2, (_a = textEditor === null || textEditor === void 0 ? void 0 : textEditor.validate()) !== null && _a !== void 0 ? _a : []];
            }); }); },
            setTheme: function (theme) { return __awaiter(void 0, void 0, void 0, function () { return __generator(this, function (_a) {
                return [2, applyEditorTheme(theme)];
            }); }); },
            colorNodes: function (nodeNames, color, colorConnectedEnds) {
                (0, ColorNodes_1.colorNodes)(nodeNames, color, colorConnectedEnds);
            },
            moveCursorToPosition: function (position) {
                textEditorEnvelopeApi === null || textEditorEnvelopeApi === void 0 ? void 0 : textEditorEnvelopeApi.notifications.kogitoSwfTextEditor__moveCursorToPosition.send(position);
            },
        };
    }, [diagramEditor, file, props.isReadOnly, textEditor, textEditorEnvelopeApi, applyEditorTheme]);
    (0, embedded_1.useStateControlSubscription)(textEditor, (0, react_1.useCallback)(function (_isDirty) { return __awaiter(void 0, void 0, void 0, function () {
        var content;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (!textEditor) {
                        return [2];
                    }
                    return [4, textEditor.getContent()];
                case 1:
                    content = _a.sent();
                    setFile(function (prevState) { return (__assign(__assign({}, prevState), { content: content })); });
                    return [2];
            }
        });
    }); }, [textEditor]));
    (0, embedded_1.useStateControlSubscription)(diagramEditor, (0, react_1.useCallback)(function (_isDirty) { return __awaiter(void 0, void 0, void 0, function () {
        var content;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (!diagramEditor) {
                        return [2];
                    }
                    return [4, diagramEditor.getContent()];
                case 1:
                    content = _a.sent();
                    setFile(function (prevState) { return (__assign(__assign({}, prevState), { content: content })); });
                    return [2];
            }
        });
    }); }, [diagramEditor]));
    var updateEditors = (0, react_1.useCallback)(function (f) { return __awaiter(void 0, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (!textEditor || !diagramEditor) {
                        return [2];
                    }
                    return [4, diagramEditor.setContent(f.path, f.content)];
                case 1:
                    _a.sent();
                    return [2];
            }
        });
    }); }, [diagramEditor, textEditor]);
    (0, react_1.useEffect)(function () {
        if ((file === null || file === void 0 ? void 0 : file.content) === undefined || file.content === lastContent.current) {
            return;
        }
        lastContent.current = file.content;
        updateEditors(file);
    }, [file, props, updateEditors]);
    var onTextEditorReady = (0, react_1.useCallback)(function () {
        setTextEditorReady(true);
    }, []);
    var onTextEditorSetContentError = (0, react_1.useCallback)(function () {
        console.error("Error setting content on text editor");
    }, []);
    var onDiagramEditorReady = (0, react_1.useCallback)(function () {
        setDiagramEditorReady(true);
    }, []);
    var onDiagramEditorSetContentError = (0, react_1.useCallback)(function () {
        console.error("Error setting content on diagram editor");
    }, []);
    var useSwfDiagramEditorChannelApiArgs = (0, react_1.useMemo)(function () { return ({
        channelApi: editorEnvelopeCtx.channelApi,
        locale: props.locale,
        embeddedEditorFile: embeddedDiagramEditorFile,
        onEditorReady: onDiagramEditorReady,
        swfTextEditorEnvelopeApi: textEditor === null || textEditor === void 0 ? void 0 : textEditor.getEnvelopeServer().envelopeApi,
    }); }, [editorEnvelopeCtx, embeddedDiagramEditorFile, onDiagramEditorReady, textEditor, props.locale]);
    var onTextEditorNewEdit = (0, react_1.useCallback)(function (edit) {
        onNewEdit(edit);
    }, [onNewEdit]);
    var onTextEditorStateControlCommandUpdate = (0, react_1.useCallback)(function (command) {
        switch (command) {
            case api_1.StateControlCommand.UNDO:
                onStateControlCommandUpdate(api_1.StateControlCommand.UNDO);
                break;
            case api_1.StateControlCommand.REDO:
                onStateControlCommandUpdate(api_1.StateControlCommand.REDO);
                break;
            default:
                console.info("Unknown message type received: ".concat(command));
                break;
        }
    }, [onStateControlCommandUpdate]);
    var useSwfTextEditorChannelApiArgs = (0, react_1.useMemo)(function () { return ({
        apiOverrides: {
            kogitoWorkspace_newEdit: onTextEditorNewEdit,
            kogitoEditor_stateControlCommandUpdate: onTextEditorStateControlCommandUpdate,
            kogitoEditor_ready: onTextEditorReady,
            kogitoEditor_setContentError: onTextEditorSetContentError,
        },
        channelApi: editorEnvelopeCtx.channelApi,
        locale: props.locale,
        embeddedEditorFile: embeddedTextEditorFile,
        swfDiagramEditorEnvelopeApi: diagramEditor === null || diagramEditor === void 0 ? void 0 : diagramEditor.getEnvelopeServer().envelopeApi,
    }); }, [
        onTextEditorNewEdit,
        onTextEditorStateControlCommandUpdate,
        onTextEditorReady,
        onTextEditorSetContentError,
        editorEnvelopeCtx.channelApi,
        props.locale,
        embeddedTextEditorFile,
        diagramEditor,
    ]);
    var _q = (0, useSwfDiagramEditorChannelApi_1.useSwfDiagramEditorChannelApi)(useSwfDiagramEditorChannelApiArgs), diagramEditorStateControl = _q.stateControl, diagramEditorChannelApi = _q.channelApi;
    var _r = (0, useSwfTextEditorChannelApi_1.useSwfTextEditorChannelApi)(useSwfTextEditorChannelApiArgs), textEditorStateControl = _r.stateControl, textEditorChannelApi = _r.channelApi;
    var renderTextEditor = function () {
        return (embeddedTextEditorFile && ((0, jsx_runtime_1.jsx)(embedded_1.EmbeddedEditor, { ref: textEditorRef, file: embeddedTextEditorFile, channelType: props.channelType, editorEnvelopeLocator: textEditorEnvelopeLocator, locale: props.locale, customChannelApiImpl: textEditorChannelApi, stateControl: textEditorStateControl, isReady: isTextEditorReady })));
    };
    var renderDiagramEditor = function () {
        return (embeddedDiagramEditorFile && ((0, jsx_runtime_1.jsx)(embedded_1.EmbeddedEditor, { ref: diagramEditorRef, file: embeddedDiagramEditorFile, channelType: props.channelType, kogitoEditor_ready: onDiagramEditorReady, kogitoEditor_setContentError: onDiagramEditorSetContentError, editorEnvelopeLocator: diagramEditorEnvelopeLocator, locale: props.locale, customChannelApiImpl: diagramEditorChannelApi, stateControl: diagramEditorStateControl })));
    };
    window.editor = (0, react_1.useMemo)(function () {
        return new ServerlessWorkflowStunnerEditor_1.SwfStunnerEditor(diagramEditor === null || diagramEditor === void 0 ? void 0 : diagramEditor.getEnvelopeServer().envelopeApi);
    }, [diagramEditor]);
    (0, react_1.useEffect)(function () {
        if (isCombinedEditorReady) {
            editorEnvelopeCtx.channelApi.notifications.kogitoSwfCombinedEditor_combinedEditorReady.send();
        }
    }, [editorEnvelopeCtx, isCombinedEditorReady]);
    var themeStyle = getThemeStyle(theme);
    return ((0, jsx_runtime_1.jsxs)("div", { style: { height: "100%", background: themeStyle.backgroundColor }, children: [(0, jsx_runtime_1.jsx)(envelope_1.LoadingScreen, { loading: !isCombinedEditorReady, styleTag: themeStyle.loadScreen }), (previewOptions === null || previewOptions === void 0 ? void 0 : previewOptions.editorMode) === "diagram" ? (renderDiagramEditor()) : (previewOptions === null || previewOptions === void 0 ? void 0 : previewOptions.editorMode) === "text" ? (renderTextEditor()) : ((0, jsx_runtime_1.jsx)(Drawer_1.Drawer, { isExpanded: true, isInline: true, className: themeStyle.drawer, children: (0, jsx_runtime_1.jsx)(Drawer_1.DrawerContent, { panelContent: (0, jsx_runtime_1.jsx)(Drawer_1.DrawerPanelContent, { isResizable: true, defaultSize: (_c = previewOptions === null || previewOptions === void 0 ? void 0 : previewOptions.defaultWidth) !== null && _c !== void 0 ? _c : "50%", children: (0, jsx_runtime_1.jsx)(Drawer_1.DrawerPanelBody, { style: { padding: 0 }, children: renderDiagramEditor() }) }), children: (0, jsx_runtime_1.jsx)(Drawer_1.DrawerContentBody, { children: renderTextEditor() }) }) }))] }));
};
function getThemeStyle(theme) {
    switch (theme) {
        case api_1.EditorTheme.DARK: {
            return {
                drawer: "dark",
                loadScreen: "vscode-dark",
                backgroundColor: "black",
            };
        }
        default: {
            return {
                drawer: "",
                loadScreen: "",
                backgroundColor: "",
            };
        }
    }
}
exports.ServerlessWorkflowCombinedEditor = (0, react_1.forwardRef)(RefForwardingServerlessWorkflowCombinedEditor);
//# sourceMappingURL=ServerlessWorkflowCombinedEditor.js.map