import { BoxedExpressionEditorI18n } from "@kie-tools/boxed-expression-component/dist/i18n";
import * as React from "react";
import { UnitablesColumnType, UnitablesInputsConfigs } from "../UnitablesTypes";
import "@kie-tools/boxed-expression-component/dist/@types/react-table";
import { UnitablesJsonSchemaBridge } from "../uniforms/UnitablesJsonSchemaBridge";
export type ROWTYPE = Record<string, any>;
export interface UnitablesBeeTable {
    id: string;
    i18n: BoxedExpressionEditorI18n;
    rows: object[];
    columns: UnitablesColumnType[];
    scrollableParentRef: React.RefObject<HTMLElement>;
    rowWrapper?: React.FunctionComponent<React.PropsWithChildren<{
        row: object;
        rowIndex: number;
    }>>;
    onRowAdded: (args: {
        beforeIndex: number;
    }) => void;
    onRowDuplicated: (args: {
        rowIndex: number;
    }) => void;
    onRowReset: (args: {
        rowIndex: number;
    }) => void;
    onRowDeleted: (args: {
        rowIndex: number;
    }) => void;
    configs: UnitablesInputsConfigs;
    setWidth: (newWidth: number, fieldName: string) => void;
    bridge: UnitablesJsonSchemaBridge;
}
export declare function UnitablesBeeTable({ id, i18n, columns, rows, scrollableParentRef, rowWrapper, onRowAdded, onRowDuplicated, onRowReset, onRowDeleted, configs, setWidth, bridge, }: UnitablesBeeTable): JSX.Element;
//# sourceMappingURL=UnitablesBeeTable.d.ts.map