import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback, useMemo, useRef, useState } from "react";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { ActionGroup, Form, FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { Stack, StackItem } from "@patternfly/react-core/dist/js/layouts/Stack";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Alert } from "@patternfly/react-core/dist/js/components/Alert";
import { Popover } from "@patternfly/react-core/dist/js/components/Popover";
import { ValidatedOptions } from "@patternfly/react-core/dist/js/helpers";
import HelpIcon from "@patternfly/react-icons/dist/esm/icons/help-icon";
import ExclamationCircleIcon from "@patternfly/react-icons/dist/esm/icons/exclamation-circle-icon";
import { validateWorkflowData } from "./validateWorkflowData";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { RequestDataEditor, } from "@kie-tools/runtime-tools-components/dist/components/RequestDataEditor";
const WorkflowForm = ({ workflowDefinition, driver, ouiaId, ouiaSafe }) => {
    const [data, setData] = useState("");
    const [isValid, setIsValid] = useState(true);
    const [isLoading, setIsLoading] = useState(false);
    const requestDataEditorRef = useRef(null);
    const resetForm = useCallback(() => {
        var _a;
        driver.resetBusinessKey();
        setData("");
        setIsValid(true);
        (_a = requestDataEditorRef.current) === null || _a === void 0 ? void 0 : _a.setContent("");
    }, []);
    const onSubmit = useCallback(async () => {
        const valid = validateWorkflowData(data);
        setIsValid(valid);
        if (!valid) {
            return;
        }
        setIsLoading(true);
        await driver.startWorkflow(workflowDefinition.endpoint, data.trim() ? JSON.parse(data) : {});
        setIsLoading(false);
        resetForm();
    }, [driver, data]);
    const requestDataEditor = useMemo(() => {
        return (_jsx(RequestDataEditor, { ref: requestDataEditorRef, content: "", onContentChange: (args) => setData(args.content), isReadOnly: false }));
    }, [setData]);
    if (isLoading) {
        return (_jsx(Bullseye, { children: _jsx(KogitoSpinner, { spinnerText: "Starting workflow...", ouiaId: "workflow-form-loading" }) }));
    }
    return (_jsx("div", { ...componentOuiaProps(ouiaId, "workflow-form", ouiaSafe), children: _jsxs(Stack, { hasGutter: true, children: [_jsx(StackItem, { children: _jsxs(Alert, { isInline: true, variant: "info", title: "Couldn't find JSON schema to display the Start Form.", children: [_jsxs("p", { children: ["Please type the data in JSON format in the Code Editor and press the ", _jsx("b", { children: "Start" }), " to submit it and start the Workflow."] }), _jsxs("p", { children: ["If you want to use a Form to start the workflow, please provide a valid JSON schema in the", " ", _jsx("code", { children: "dataInputSchema" }), " property in your workflow file."] })] }) }), _jsx(StackItem, { children: _jsxs(Form, { isHorizontal: true, children: [_jsx(FormGroup, { label: "Start Workflow Data", isRequired: true, fieldId: "workflowData", helperTextInvalid: !isValid && "The Workflow Data should have a JSON format.", helperTextInvalidIcon: _jsx(ExclamationCircleIcon, {}), validated: !isValid ? ValidatedOptions.error : ValidatedOptions.default, labelIcon: _jsx(Popover, { id: "workflow-form-data-help", bodyContent: _jsx("div", { children: "Fill the data to start the Workflow in JSON format." }), children: _jsx("button", { type: "button", "aria-label": "More info for data field", onClick: (e) => e.preventDefault(), className: "pf-c-form__group-label-help", children: _jsx(HelpIcon, { noVerticalAlign: true }) }) }), children: requestDataEditor }), _jsxs(ActionGroup, { children: [_jsx(Button, { variant: "primary", onClick: onSubmit, "data-testid": "start-button", children: "Start" }), _jsx(Button, { variant: "secondary", onClick: resetForm, children: "Reset" })] })] }) })] }) }));
};
export default WorkflowForm;
//# sourceMappingURL=WorkflowForm.js.map